/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.opcua.readwrite.UserIdentityTokenDefinition;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class UserIdentityToken
extends ExtensionObjectDefinition
implements Message {
    protected final PascalString policyId;
    protected final UserIdentityTokenDefinition userIdentityTokenDefinition;

    @Override
    public String getIdentifier() {
        return "316";
    }

    public UserIdentityToken(PascalString policyId, UserIdentityTokenDefinition userIdentityTokenDefinition) {
        this.policyId = policyId;
        this.userIdentityTokenDefinition = userIdentityTokenDefinition;
    }

    public PascalString getPolicyId() {
        return this.policyId;
    }

    public UserIdentityTokenDefinition getUserIdentityTokenDefinition() {
        return this.userIdentityTokenDefinition;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("UserIdentityToken", new WithWriterArgs[0]);
        int policyLength = this.getPolicyId().getLengthInBytes() + this.getUserIdentityTokenDefinition().getLengthInBytes();
        FieldWriterFactory.writeImplicitField("policyLength", policyLength, DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("policyId", this.policyId, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("userIdentityTokenDefinition", this.userIdentityTokenDefinition, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        writeBuffer.popContext("UserIdentityToken", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        UserIdentityToken _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 32;
        lengthInBits += this.policyId.getLengthInBits();
        return lengthInBits += this.userIdentityTokenDefinition.getLengthInBits();
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("UserIdentityToken", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        int policyLength = FieldReaderFactory.readImplicitField("policyLength", DataReaderFactory.readSignedInt(readBuffer, 32), new WithReaderArgs[0]);
        PascalString policyId = FieldReaderFactory.readSimpleField("policyId", new DataReaderComplexDefault<PascalString>(() -> PascalString.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        UserIdentityTokenDefinition userIdentityTokenDefinition = FieldReaderFactory.readSimpleField("userIdentityTokenDefinition", new DataReaderComplexDefault<UserIdentityTokenDefinition>(() -> UserIdentityTokenDefinition.staticParse(readBuffer, policyId.getStringValue()), readBuffer), new WithReaderArgs[0]);
        readBuffer.closeContext("UserIdentityToken", new WithReaderArgs[0]);
        return new UserIdentityTokenBuilderImpl(policyId, userIdentityTokenDefinition);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserIdentityToken)) {
            return false;
        }
        UserIdentityToken that = (UserIdentityToken)o;
        return this.getPolicyId() == that.getPolicyId() && this.getUserIdentityTokenDefinition() == that.getUserIdentityTokenDefinition() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getPolicyId(), this.getUserIdentityTokenDefinition());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class UserIdentityTokenBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final PascalString policyId;
        private final UserIdentityTokenDefinition userIdentityTokenDefinition;

        public UserIdentityTokenBuilderImpl(PascalString policyId, UserIdentityTokenDefinition userIdentityTokenDefinition) {
            this.policyId = policyId;
            this.userIdentityTokenDefinition = userIdentityTokenDefinition;
        }

        @Override
        public UserIdentityToken build() {
            UserIdentityToken userIdentityToken = new UserIdentityToken(this.policyId, this.userIdentityTokenDefinition);
            return userIdentityToken;
        }
    }
}

