/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.opcua.readwrite.AnonymousIdentityToken;
import org.apache.plc4x.java.opcua.readwrite.IssuedIdentityToken;
import org.apache.plc4x.java.opcua.readwrite.UserNameIdentityToken;
import org.apache.plc4x.java.opcua.readwrite.X509IdentityToken;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public abstract class UserIdentityTokenDefinition
implements Message {
    public abstract String getIdentifier();

    protected abstract void serializeUserIdentityTokenDefinitionChild(WriteBuffer var1) throws SerializationException;

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("UserIdentityTokenDefinition", new WithWriterArgs[0]);
        this.serializeUserIdentityTokenDefinitionChild(writeBuffer);
        writeBuffer.popContext("UserIdentityTokenDefinition", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = 0;
        UserIdentityTokenDefinition _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        return lengthInBits;
    }

    public static UserIdentityTokenDefinition staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        String identifier;
        ReadBuffer positionAware = readBuffer;
        if (args == null || args.length != 1) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 1, but got " + args.length);
        }
        if (args[0] instanceof String) {
            identifier = (String)args[0];
        } else if (args[0] instanceof String) {
            identifier = String.valueOf((String)args[0]);
        } else {
            throw new PlcRuntimeException("Argument 0 expected to be of type String or a string which is parseable but was " + args[0].getClass().getName());
        }
        return UserIdentityTokenDefinition.staticParse(readBuffer, identifier);
    }

    public static UserIdentityTokenDefinition staticParse(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("UserIdentityTokenDefinition", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        UserIdentityTokenDefinitionBuilder builder = null;
        if (EvaluationHelper.equals(identifier, "anonymous")) {
            builder = AnonymousIdentityToken.staticParseUserIdentityTokenDefinitionBuilder(readBuffer, identifier);
        } else if (EvaluationHelper.equals(identifier, "username")) {
            builder = UserNameIdentityToken.staticParseUserIdentityTokenDefinitionBuilder(readBuffer, identifier);
        } else if (EvaluationHelper.equals(identifier, "certificate")) {
            builder = X509IdentityToken.staticParseUserIdentityTokenDefinitionBuilder(readBuffer, identifier);
        } else if (EvaluationHelper.equals(identifier, "identity")) {
            builder = IssuedIdentityToken.staticParseUserIdentityTokenDefinitionBuilder(readBuffer, identifier);
        }
        if (builder == null) {
            throw new ParseException("Unsupported case for discriminated type parameters [identifier=" + identifier + "]");
        }
        readBuffer.closeContext("UserIdentityTokenDefinition", new WithReaderArgs[0]);
        UserIdentityTokenDefinition _userIdentityTokenDefinition = builder.build();
        return _userIdentityTokenDefinition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserIdentityTokenDefinition)) {
            return false;
        }
        UserIdentityTokenDefinition that = (UserIdentityTokenDefinition)o;
        return true;
    }

    public int hashCode() {
        return Objects.hash(new Object[0]);
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static interface UserIdentityTokenDefinitionBuilder {
        public UserIdentityTokenDefinition build();
    }
}

