/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.VariantBoolean;
import org.apache.plc4x.java.opcua.readwrite.VariantByte;
import org.apache.plc4x.java.opcua.readwrite.VariantByteString;
import org.apache.plc4x.java.opcua.readwrite.VariantDataValue;
import org.apache.plc4x.java.opcua.readwrite.VariantDateTime;
import org.apache.plc4x.java.opcua.readwrite.VariantDiagnosticInfo;
import org.apache.plc4x.java.opcua.readwrite.VariantDouble;
import org.apache.plc4x.java.opcua.readwrite.VariantExpandedNodeId;
import org.apache.plc4x.java.opcua.readwrite.VariantExtensionObject;
import org.apache.plc4x.java.opcua.readwrite.VariantFloat;
import org.apache.plc4x.java.opcua.readwrite.VariantGuid;
import org.apache.plc4x.java.opcua.readwrite.VariantInt16;
import org.apache.plc4x.java.opcua.readwrite.VariantInt32;
import org.apache.plc4x.java.opcua.readwrite.VariantInt64;
import org.apache.plc4x.java.opcua.readwrite.VariantLocalizedText;
import org.apache.plc4x.java.opcua.readwrite.VariantNodeId;
import org.apache.plc4x.java.opcua.readwrite.VariantNull;
import org.apache.plc4x.java.opcua.readwrite.VariantQualifiedName;
import org.apache.plc4x.java.opcua.readwrite.VariantSByte;
import org.apache.plc4x.java.opcua.readwrite.VariantStatusCode;
import org.apache.plc4x.java.opcua.readwrite.VariantString;
import org.apache.plc4x.java.opcua.readwrite.VariantUInt16;
import org.apache.plc4x.java.opcua.readwrite.VariantUInt32;
import org.apache.plc4x.java.opcua.readwrite.VariantUInt64;
import org.apache.plc4x.java.opcua.readwrite.VariantVariant;
import org.apache.plc4x.java.opcua.readwrite.VariantXmlElement;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public abstract class Variant
implements Message {
    protected final boolean arrayLengthSpecified;
    protected final boolean arrayDimensionsSpecified;
    protected final Integer noOfArrayDimensions;
    protected final List<Boolean> arrayDimensions;

    public abstract Byte getVariantType();

    public Variant(boolean arrayLengthSpecified, boolean arrayDimensionsSpecified, Integer noOfArrayDimensions, List<Boolean> arrayDimensions) {
        this.arrayLengthSpecified = arrayLengthSpecified;
        this.arrayDimensionsSpecified = arrayDimensionsSpecified;
        this.noOfArrayDimensions = noOfArrayDimensions;
        this.arrayDimensions = arrayDimensions;
    }

    public boolean getArrayLengthSpecified() {
        return this.arrayLengthSpecified;
    }

    public boolean getArrayDimensionsSpecified() {
        return this.arrayDimensionsSpecified;
    }

    public Integer getNoOfArrayDimensions() {
        return this.noOfArrayDimensions;
    }

    public List<Boolean> getArrayDimensions() {
        return this.arrayDimensions;
    }

    protected abstract void serializeVariantChild(WriteBuffer var1) throws SerializationException;

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("Variant", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("arrayLengthSpecified", this.arrayLengthSpecified, DataWriterFactory.writeBoolean(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("arrayDimensionsSpecified", this.arrayDimensionsSpecified, DataWriterFactory.writeBoolean(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeDiscriminatorField("VariantType", this.getVariantType(), DataWriterFactory.writeUnsignedByte(writeBuffer, 6), new WithWriterArgs[0]);
        this.serializeVariantChild(writeBuffer);
        FieldWriterFactory.writeOptionalField("noOfArrayDimensions", this.noOfArrayDimensions, DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleTypeArrayField("arrayDimensions", this.arrayDimensions, DataWriterFactory.writeBoolean(writeBuffer), new WithWriterArgs[0]);
        writeBuffer.popContext("Variant", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = 0;
        Variant _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        ++lengthInBits;
        ++lengthInBits;
        lengthInBits += 6;
        if (this.noOfArrayDimensions != null) {
            lengthInBits += 32;
        }
        if (this.arrayDimensions != null) {
            lengthInBits += 1 * this.arrayDimensions.size();
        }
        return lengthInBits;
    }

    public static Variant staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        ReadBuffer positionAware = readBuffer;
        return Variant.staticParse(readBuffer);
    }

    public static Variant staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("Variant", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        boolean arrayLengthSpecified = FieldReaderFactory.readSimpleField("arrayLengthSpecified", DataReaderFactory.readBoolean(readBuffer), new WithReaderArgs[0]);
        boolean arrayDimensionsSpecified = FieldReaderFactory.readSimpleField("arrayDimensionsSpecified", DataReaderFactory.readBoolean(readBuffer), new WithReaderArgs[0]);
        byte VariantType = FieldReaderFactory.readDiscriminatorField("VariantType", DataReaderFactory.readUnsignedByte(readBuffer, 6), new WithReaderArgs[0]);
        VariantBuilder builder = null;
        if (EvaluationHelper.equals(VariantType, (byte)0)) {
            builder = VariantNull.staticParseVariantBuilder(readBuffer);
        } else if (EvaluationHelper.equals(VariantType, (byte)1)) {
            builder = VariantBoolean.staticParseVariantBuilder(readBuffer, arrayLengthSpecified);
        } else if (EvaluationHelper.equals(VariantType, (byte)2)) {
            builder = VariantSByte.staticParseVariantBuilder(readBuffer, arrayLengthSpecified);
        } else if (EvaluationHelper.equals(VariantType, (byte)3)) {
            builder = VariantByte.staticParseVariantBuilder(readBuffer, arrayLengthSpecified);
        } else if (EvaluationHelper.equals(VariantType, (byte)4)) {
            builder = VariantInt16.staticParseVariantBuilder(readBuffer, arrayLengthSpecified);
        } else if (EvaluationHelper.equals(VariantType, (byte)5)) {
            builder = VariantUInt16.staticParseVariantBuilder(readBuffer, arrayLengthSpecified);
        } else if (EvaluationHelper.equals(VariantType, (byte)6)) {
            builder = VariantInt32.staticParseVariantBuilder(readBuffer, arrayLengthSpecified);
        } else if (EvaluationHelper.equals(VariantType, (byte)7)) {
            builder = VariantUInt32.staticParseVariantBuilder(readBuffer, arrayLengthSpecified);
        } else if (EvaluationHelper.equals(VariantType, (byte)8)) {
            builder = VariantInt64.staticParseVariantBuilder(readBuffer, arrayLengthSpecified);
        } else if (EvaluationHelper.equals(VariantType, (byte)9)) {
            builder = VariantUInt64.staticParseVariantBuilder(readBuffer, arrayLengthSpecified);
        } else if (EvaluationHelper.equals(VariantType, (byte)10)) {
            builder = VariantFloat.staticParseVariantBuilder(readBuffer, arrayLengthSpecified);
        } else if (EvaluationHelper.equals(VariantType, (byte)11)) {
            builder = VariantDouble.staticParseVariantBuilder(readBuffer, arrayLengthSpecified);
        } else if (EvaluationHelper.equals(VariantType, (byte)12)) {
            builder = VariantString.staticParseVariantBuilder(readBuffer, arrayLengthSpecified);
        } else if (EvaluationHelper.equals(VariantType, (byte)13)) {
            builder = VariantDateTime.staticParseVariantBuilder(readBuffer, arrayLengthSpecified);
        } else if (EvaluationHelper.equals(VariantType, (byte)14)) {
            builder = VariantGuid.staticParseVariantBuilder(readBuffer, arrayLengthSpecified);
        } else if (EvaluationHelper.equals(VariantType, (byte)15)) {
            builder = VariantByteString.staticParseVariantBuilder(readBuffer, arrayLengthSpecified);
        } else if (EvaluationHelper.equals(VariantType, (byte)16)) {
            builder = VariantXmlElement.staticParseVariantBuilder(readBuffer, arrayLengthSpecified);
        } else if (EvaluationHelper.equals(VariantType, (byte)17)) {
            builder = VariantNodeId.staticParseVariantBuilder(readBuffer, arrayLengthSpecified);
        } else if (EvaluationHelper.equals(VariantType, (byte)18)) {
            builder = VariantExpandedNodeId.staticParseVariantBuilder(readBuffer, arrayLengthSpecified);
        } else if (EvaluationHelper.equals(VariantType, (byte)19)) {
            builder = VariantStatusCode.staticParseVariantBuilder(readBuffer, arrayLengthSpecified);
        } else if (EvaluationHelper.equals(VariantType, (byte)20)) {
            builder = VariantQualifiedName.staticParseVariantBuilder(readBuffer, arrayLengthSpecified);
        } else if (EvaluationHelper.equals(VariantType, (byte)21)) {
            builder = VariantLocalizedText.staticParseVariantBuilder(readBuffer, arrayLengthSpecified);
        } else if (EvaluationHelper.equals(VariantType, (byte)22)) {
            builder = VariantExtensionObject.staticParseVariantBuilder(readBuffer, arrayLengthSpecified);
        } else if (EvaluationHelper.equals(VariantType, (byte)23)) {
            builder = VariantDataValue.staticParseVariantBuilder(readBuffer, arrayLengthSpecified);
        } else if (EvaluationHelper.equals(VariantType, (byte)24)) {
            builder = VariantVariant.staticParseVariantBuilder(readBuffer, arrayLengthSpecified);
        } else if (EvaluationHelper.equals(VariantType, (byte)25)) {
            builder = VariantDiagnosticInfo.staticParseVariantBuilder(readBuffer, arrayLengthSpecified);
        }
        if (builder == null) {
            throw new ParseException("Unsupported case for discriminated type parameters [VariantType=" + VariantType + " " + "arrayLengthSpecified=" + arrayLengthSpecified + "]");
        }
        Integer noOfArrayDimensions = FieldReaderFactory.readOptionalField("noOfArrayDimensions", DataReaderFactory.readSignedInt(readBuffer, 32), arrayDimensionsSpecified, new WithReaderArgs[0]);
        List<Boolean> arrayDimensions = FieldReaderFactory.readCountArrayField("arrayDimensions", DataReaderFactory.readBoolean(readBuffer), noOfArrayDimensions == null ? 0 : noOfArrayDimensions, new WithReaderArgs[0]);
        readBuffer.closeContext("Variant", new WithReaderArgs[0]);
        Variant _variant = builder.build(arrayLengthSpecified, arrayDimensionsSpecified, noOfArrayDimensions, arrayDimensions);
        return _variant;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Variant)) {
            return false;
        }
        Variant that = (Variant)o;
        return this.getArrayLengthSpecified() == that.getArrayLengthSpecified() && this.getArrayDimensionsSpecified() == that.getArrayDimensionsSpecified() && this.getNoOfArrayDimensions() == that.getNoOfArrayDimensions() && this.getArrayDimensions() == that.getArrayDimensions();
    }

    public int hashCode() {
        return Objects.hash(this.getArrayLengthSpecified(), this.getArrayDimensionsSpecified(), this.getNoOfArrayDimensions(), this.getArrayDimensions());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static interface VariantBuilder {
        public Variant build(boolean var1, boolean var2, Integer var3, List<Boolean> var4);
    }
}

