/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.NodeId;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class ViewDescription
extends ExtensionObjectDefinition
implements Message {
    protected final NodeId viewId;
    protected final long timestamp;
    protected final long viewVersion;

    @Override
    public String getIdentifier() {
        return "513";
    }

    public ViewDescription(NodeId viewId, long timestamp, long viewVersion) {
        this.viewId = viewId;
        this.timestamp = timestamp;
        this.viewVersion = viewVersion;
    }

    public NodeId getViewId() {
        return this.viewId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getViewVersion() {
        return this.viewVersion;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("ViewDescription", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("viewId", this.viewId, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("timestamp", this.timestamp, DataWriterFactory.writeSignedLong(writeBuffer, 64), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("viewVersion", this.viewVersion, DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        writeBuffer.popContext("ViewDescription", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        ViewDescription _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.viewId.getLengthInBits();
        lengthInBits += 64;
        return lengthInBits += 32;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("ViewDescription", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        NodeId viewId = FieldReaderFactory.readSimpleField("viewId", new DataReaderComplexDefault<NodeId>(() -> NodeId.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        long timestamp = FieldReaderFactory.readSimpleField("timestamp", DataReaderFactory.readSignedLong(readBuffer, 64), new WithReaderArgs[0]);
        long viewVersion = FieldReaderFactory.readSimpleField("viewVersion", DataReaderFactory.readUnsignedLong(readBuffer, 32), new WithReaderArgs[0]);
        readBuffer.closeContext("ViewDescription", new WithReaderArgs[0]);
        return new ViewDescriptionBuilderImpl(viewId, timestamp, viewVersion);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ViewDescription)) {
            return false;
        }
        ViewDescription that = (ViewDescription)o;
        return this.getViewId() == that.getViewId() && this.getTimestamp() == that.getTimestamp() && this.getViewVersion() == that.getViewVersion() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getViewId(), this.getTimestamp(), this.getViewVersion());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class ViewDescriptionBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final NodeId viewId;
        private final long timestamp;
        private final long viewVersion;

        public ViewDescriptionBuilderImpl(NodeId viewId, long timestamp, long viewVersion) {
            this.viewId = viewId;
            this.timestamp = timestamp;
            this.viewVersion = viewVersion;
        }

        @Override
        public ViewDescription build() {
            ViewDescription viewDescription = new ViewDescription(this.viewId, this.timestamp, this.viewVersion);
            return viewDescription;
        }
    }
}

