/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.events;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcSubscriptionRequest;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.s7.events.S7Event;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCyclicServicesChangeDrivenPush;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCyclicServicesChangeDrivenSubscribeResponse;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCyclicServicesPush;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCyclicServicesSubscribeResponse;
import org.apache.plc4x.java.s7.readwrite.utils.StaticHelper;

public class S7CyclicEvent
implements S7Event {
    private final PlcSubscriptionRequest request;
    private final Instant timeStamp;
    private final Map<String, Object> map = new HashMap<String, Object>();
    private int j;

    public S7CyclicEvent(PlcSubscriptionRequest request, short jobid, S7PayloadUserDataItemCyclicServicesPush event) {
        this.timeStamp = Instant.now();
        this.request = request;
        this.map.put(Fields.TYPE.name(), "CYCEVENT");
        this.map.put(Fields.TIMESTAMP.name(), this.timeStamp);
        this.map.put(Fields.JOBID.name(), jobid);
        this.map.put(Fields.ITEMSCOUNT.name(), event.getItemsCount());
        int[] n = new int[1];
        request.getTagNames().forEach(tagname -> {
            int i = n[0];
            this.map.put(String.valueOf(Fields.RETURNCODE_.name()) + i, event.getItems().get(i).getReturnCode().getValue());
            this.map.put(String.valueOf(Fields.TRANSPORTSIZE_.name()) + i, event.getItems().get(i).getTransportSize().getValue());
            byte[] buffer = new byte[event.getItems().get(i).getData().size()];
            this.j = 0;
            event.getItems().get(i).getData().forEach(s -> {
                byArray[this.j] = s.byteValue();
                ++this.j;
            });
            this.map.put((String)tagname, buffer);
            nArray[0] = n[0] + 1;
        });
    }

    public S7CyclicEvent(PlcSubscriptionRequest request, short jobid, S7PayloadUserDataItemCyclicServicesChangeDrivenPush event) {
        this.timeStamp = Instant.now();
        this.request = request;
        this.map.put(Fields.TYPE.name(), "CYCEVENT");
        this.map.put(Fields.TIMESTAMP.name(), this.timeStamp);
        this.map.put(Fields.JOBID.name(), jobid);
        this.map.put(Fields.ITEMSCOUNT.name(), event.getItemsCount());
        int[] n = new int[1];
        request.getTagNames().forEach(tagname -> {
            int i = n[0];
            this.map.put(String.valueOf(Fields.RETURNCODE_.name()) + i, event.getItems().get(i).getReturnCode().getValue());
            this.map.put(String.valueOf(Fields.TRANSPORTSIZE_.name()) + i, event.getItems().get(i).getTransportSize().getValue());
            byte[] buffer = new byte[event.getItems().get(i).getData().size()];
            this.j = 0;
            event.getItems().get(i).getData().forEach(s -> {
                byArray[this.j] = s.byteValue();
                ++this.j;
            });
            this.map.put((String)tagname, buffer);
            nArray[0] = n[0] + 1;
        });
    }

    public S7CyclicEvent(PlcSubscriptionRequest request, short jobid, S7PayloadUserDataItemCyclicServicesSubscribeResponse event) {
        this.timeStamp = Instant.now();
        this.request = request;
        this.map.put(Fields.TYPE.name(), "CYCEVENT");
        this.map.put(Fields.TIMESTAMP.name(), this.timeStamp);
        this.map.put(Fields.JOBID.name(), jobid);
        this.map.put(Fields.ITEMSCOUNT.name(), event.getItemsCount());
        int[] n = new int[1];
        request.getTagNames().forEach(tagname -> {
            int i = n[0];
            this.map.put(String.valueOf(Fields.RETURNCODE_.name()) + i, event.getItems().get(i).getReturnCode().getValue());
            this.map.put(String.valueOf(Fields.TRANSPORTSIZE_.name()) + i, event.getItems().get(i).getTransportSize().getValue());
            byte[] buffer = new byte[event.getItems().get(i).getData().size()];
            this.j = 0;
            event.getItems().get(i).getData().forEach(s -> {
                byArray[this.j] = s.byteValue();
                ++this.j;
            });
            this.map.put((String)tagname, buffer);
            nArray[0] = n[0] + 1;
        });
    }

    public S7CyclicEvent(PlcSubscriptionRequest request, short jobid, S7PayloadUserDataItemCyclicServicesChangeDrivenSubscribeResponse event) {
        this.timeStamp = Instant.now();
        this.request = request;
        this.map.put(Fields.TYPE.name(), "CYCEVENT");
        this.map.put(Fields.TIMESTAMP.name(), this.timeStamp);
        this.map.put(Fields.JOBID.name(), jobid);
        this.map.put(Fields.ITEMSCOUNT.name(), event.getItemsCount());
        int[] n = new int[1];
        request.getTagNames().forEach(tagname -> {
            int i = n[0];
            this.map.put(String.valueOf(Fields.RETURNCODE_.name()) + i, event.getItems().get(i).getReturnCode().getValue());
            this.map.put(String.valueOf(Fields.TRANSPORTSIZE_.name()) + i, event.getItems().get(i).getTransportSize().getValue());
            byte[] buffer = new byte[event.getItems().get(i).getData().size()];
            this.j = 0;
            event.getItems().get(i).getData().forEach(s -> {
                byArray[this.j] = s.byteValue();
                ++this.j;
            });
            this.map.put((String)tagname, buffer);
            nArray[0] = n[0] + 1;
        });
    }

    @Override
    public Map<String, Object> getMap() {
        return this.map;
    }

    @Override
    public Instant getTimestamp() {
        return this.timeStamp;
    }

    @Override
    public PlcReadRequest getRequest() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public PlcValue getAsPlcValue() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public PlcValue getPlcValue(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getNumberOfValues(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object getObject(String name) {
        if ("REQUEST".equals(name)) {
            return this.request;
        }
        return null;
    }

    @Override
    public Object getObject(String name, int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Collection<Object> getAllObjects(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isValidBoolean(String name) {
        return this.isValidBoolean(name, 0);
    }

    @Override
    public boolean isValidBoolean(String name, int index) {
        try {
            this.getBoolean(name, index);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public Boolean getBoolean(String name) {
        return this.getBoolean(name, 0);
    }

    @Override
    public Boolean getBoolean(String name, int index) {
        if (!(this.map.get(name) instanceof byte[])) {
            throw new UnsupportedOperationException("Field is not a buffer of bytes. Required byte[] type.");
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])this.map.get(name));
        return byteBuf.getBoolean(index);
    }

    @Override
    public Collection<Boolean> getAllBooleans(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isValidByte(String name) {
        return this.isValidByte(name, 0);
    }

    @Override
    public boolean isValidByte(String name, int index) {
        try {
            this.getByte(name, index);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public Byte getByte(String name) {
        return this.getByte(name, 0);
    }

    @Override
    public Byte getByte(String name, int index) {
        if (!(this.map.get(name) instanceof byte[])) {
            throw new UnsupportedOperationException("Field is not a buffer of bytes. Required byte[] type.");
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])this.map.get(name));
        int pos = index * 1;
        return byteBuf.getByte(pos);
    }

    @Override
    public Collection<Byte> getAllBytes(String name) {
        if (!(this.map.get(name) instanceof byte[])) {
            throw new UnsupportedOperationException("Field is not a buffer of bytes. Required byte[] type.");
        }
        byte[] array = (byte[])this.map.get(name);
        return IntStream.range(0, array.length).mapToObj(i -> array[i]).collect(Collectors.toList());
    }

    @Override
    public boolean isValidShort(String name) {
        return this.isValidShort(name, 0);
    }

    @Override
    public boolean isValidShort(String name, int index) {
        try {
            this.getShort(name, index);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public Short getShort(String name) {
        return this.getShort(name, 0);
    }

    @Override
    public Short getShort(String name, int index) {
        if (!(this.map.get(name) instanceof byte[])) {
            throw new UnsupportedOperationException("Field is not a buffer of bytes. Required byte[] type.");
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])this.map.get(name));
        int pos = index * 2;
        return byteBuf.getShort(pos);
    }

    @Override
    public Collection<Short> getAllShorts(String name) {
        if (!(this.map.get(name) instanceof byte[])) {
            throw new UnsupportedOperationException("Field is not a buffer of bytes. Required byte[] type.");
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])this.map.get(name));
        ArrayList<Short> list = new ArrayList<Short>();
        while (byteBuf.isReadable(2)) {
            list.add(byteBuf.readShort());
        }
        return list;
    }

    @Override
    public boolean isValidInteger(String name) {
        return this.isValidInteger(name, 0);
    }

    @Override
    public boolean isValidInteger(String name, int index) {
        try {
            this.getInteger(name, index);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public Integer getInteger(String name) {
        return this.getInteger(name, 0);
    }

    @Override
    public Integer getInteger(String name, int index) {
        if (!(this.map.get(name) instanceof byte[])) {
            throw new UnsupportedOperationException("Field is not a buffer of bytes. Required byte[] type.");
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])this.map.get(name));
        int pos = index * 4;
        return byteBuf.getInt(pos);
    }

    @Override
    public Collection<Integer> getAllIntegers(String name) {
        if (!(this.map.get(name) instanceof byte[])) {
            throw new UnsupportedOperationException("Field is not a buffer of bytes. Required byte[] type.");
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])this.map.get(name));
        ArrayList<Integer> list = new ArrayList<Integer>();
        while (byteBuf.isReadable(4)) {
            list.add(byteBuf.readInt());
        }
        return list;
    }

    @Override
    public boolean isValidBigInteger(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isValidBigInteger(String name, int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public BigInteger getBigInteger(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public BigInteger getBigInteger(String name, int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Collection<BigInteger> getAllBigIntegers(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isValidLong(String name) {
        return this.isValidLong(name, 0);
    }

    @Override
    public boolean isValidLong(String name, int index) {
        try {
            this.getLong(name, index);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public Long getLong(String name) {
        return this.getLong(name, 0);
    }

    @Override
    public Long getLong(String name, int index) {
        if (!(this.map.get(name) instanceof byte[])) {
            throw new UnsupportedOperationException("Field is not a buffer of bytes. Required byte[] type.");
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])this.map.get(name));
        int pos = index * 8;
        return byteBuf.getLong(pos);
    }

    @Override
    public Collection<Long> getAllLongs(String name) {
        if (!(this.map.get(name) instanceof byte[])) {
            throw new UnsupportedOperationException("Field is not a buffer of bytes. Required byte[] type.");
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])this.map.get(name));
        ArrayList<Long> list = new ArrayList<Long>();
        while (byteBuf.isReadable(8)) {
            list.add(byteBuf.readLong());
        }
        return list;
    }

    @Override
    public boolean isValidFloat(String name) {
        return this.isValidFloat(name, 0);
    }

    @Override
    public boolean isValidFloat(String name, int index) {
        try {
            this.getFloat(name, index);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public Float getFloat(String name) {
        return this.getFloat(name, 0);
    }

    @Override
    public Float getFloat(String name, int index) {
        if (!(this.map.get(name) instanceof byte[])) {
            throw new UnsupportedOperationException("Field is not a buffer of bytes. Required byte[] type.");
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])this.map.get(name));
        int pos = index * 4;
        return Float.valueOf(byteBuf.getFloat(pos));
    }

    @Override
    public Collection<Float> getAllFloats(String name) {
        if (!(this.map.get(name) instanceof byte[])) {
            throw new UnsupportedOperationException("Field is not a buffer of bytes. Required byte[] type.");
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])this.map.get(name));
        ArrayList<Float> list = new ArrayList<Float>();
        while (byteBuf.isReadable(4)) {
            list.add(Float.valueOf(byteBuf.readFloat()));
        }
        return list;
    }

    @Override
    public boolean isValidDouble(String name) {
        return this.isValidDouble(name, 0);
    }

    @Override
    public boolean isValidDouble(String name, int index) {
        try {
            this.getDouble(name, index);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public Double getDouble(String name) {
        return this.getDouble(name, 0);
    }

    @Override
    public Double getDouble(String name, int index) {
        if (!(this.map.get(name) instanceof byte[])) {
            throw new UnsupportedOperationException("Field is not a buffer of bytes. Required byte[] type.");
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])this.map.get(name));
        int pos = index * 8;
        return byteBuf.getDouble(pos);
    }

    @Override
    public Collection<Double> getAllDoubles(String name) {
        if (!(this.map.get(name) instanceof byte[])) {
            throw new UnsupportedOperationException("Field is not a buffer of bytes. Required byte[] type.");
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])this.map.get(name));
        ArrayList<Double> list = new ArrayList<Double>();
        while (byteBuf.isReadable(8)) {
            list.add(byteBuf.readDouble());
        }
        return list;
    }

    @Override
    public boolean isValidBigDecimal(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isValidBigDecimal(String name, int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public BigDecimal getBigDecimal(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public BigDecimal getBigDecimal(String name, int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Collection<BigDecimal> getAllBigDecimals(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isValidString(String name) {
        return this.isValidString(name, 0);
    }

    @Override
    public boolean isValidString(String name, int index) {
        try {
            this.getString(name, index);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public String getString(String name) {
        if (!(this.map.get(name) instanceof byte[])) {
            throw new UnsupportedOperationException("Field is not a buffer of bytes. Required byte[] type.");
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])this.map.get(name));
        return byteBuf.toString(Charset.defaultCharset());
    }

    @Override
    public String getString(String name, int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Collection<String> getAllStrings(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isValidTime(String name) {
        return this.isValidTime(name, 0);
    }

    @Override
    public boolean isValidTime(String name, int index) {
        try {
            this.getTime(name, index);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public LocalTime getTime(String name) {
        return this.getTime(name, 0);
    }

    @Override
    public LocalTime getTime(String name, int index) {
        if (!(this.map.get(name) instanceof byte[])) {
            throw new UnsupportedOperationException("Field is not a buffer of bytes. Required byte[] type.");
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])this.map.get(name));
        int pos = index * 4;
        int value = byteBuf.getInt(pos);
        Duration dr = StaticHelper.s7TimeToDuration(value);
        return LocalTime.of(dr.toHoursPart(), dr.toMinutesPart(), dr.toSecondsPart(), dr.toNanosPart());
    }

    @Override
    public Collection<LocalTime> getAllTimes(String name) {
        if (!(this.map.get(name) instanceof byte[])) {
            throw new UnsupportedOperationException("Field is not a buffer of bytes. Required byte[] type.");
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])this.map.get(name));
        int nitems = byteBuf.capacity() / 4;
        ArrayList<LocalTime> items = new ArrayList<LocalTime>();
        int i = 0;
        while (i < nitems) {
            items.add(this.getTime(name, i));
            ++i;
        }
        return items;
    }

    @Override
    public boolean isValidDate(String name) {
        return this.isValidDate(name, 0);
    }

    @Override
    public boolean isValidDate(String name, int index) {
        try {
            this.getDate(name, index);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public LocalDate getDate(String name) {
        return this.getDate(name, 0);
    }

    @Override
    public LocalDate getDate(String name, int index) {
        if (!(this.map.get(name) instanceof byte[])) {
            throw new UnsupportedOperationException("Field is not a buffer of bytes. Required byte[] type.");
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])this.map.get(name));
        int pos = index * 2;
        short value = byteBuf.getShort(pos);
        return StaticHelper.s7DateToLocalDate(value);
    }

    @Override
    public Collection<LocalDate> getAllDates(String name) {
        if (!(this.map.get(name) instanceof byte[])) {
            throw new UnsupportedOperationException("Field is not a buffer of bytes. Required byte[] type.");
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])this.map.get(name));
        int nItems = byteBuf.capacity() / 2;
        ArrayList<LocalDate> items = new ArrayList<LocalDate>();
        int i = 0;
        while (i < nItems) {
            items.add(this.getDate(name, i));
            ++i;
        }
        return items;
    }

    @Override
    public boolean isValidDateTime(String name) {
        return this.isValidDateTime(name, 0);
    }

    @Override
    public boolean isValidDateTime(String name, int index) {
        try {
            this.getDateTime(name, index);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public LocalDateTime getDateTime(String name) {
        return this.getDateTime(name, 0);
    }

    @Override
    public LocalDateTime getDateTime(String name, int index) {
        if (!(this.map.get(name) instanceof byte[])) {
            throw new UnsupportedOperationException("Field is not a buffer of bytes. Required byte[] type.");
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])this.map.get(name));
        int pos = index * 8;
        return StaticHelper.s7DateTimeToLocalDateTime(byteBuf.slice(pos, 8));
    }

    @Override
    public Collection<LocalDateTime> getAllDateTimes(String name) {
        if (!(this.map.get(name) instanceof byte[])) {
            throw new UnsupportedOperationException("Field is not a buffer of bytes. Required byte[] type.");
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])this.map.get(name));
        int nitems = byteBuf.capacity() / 8;
        ArrayList<LocalDateTime> items = new ArrayList<LocalDateTime>();
        int i = 0;
        while (i < nitems) {
            items.add(this.getDateTime(name, i));
            ++i;
        }
        return items;
    }

    @Override
    public Collection<String> getTagNames() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public PlcTag getTag(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public PlcResponseCode getResponseCode(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static enum Fields {
        TYPE,
        JOBID,
        TIMESTAMP,
        ITEMSCOUNT,
        REQUEST,
        MAP,
        RETURNCODE_,
        TRANSPORTSIZE_,
        DATA_;

    }
}

