/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.s7.readwrite.COTPParameterCalledTsap;
import org.apache.plc4x.java.s7.readwrite.COTPParameterCallingTsap;
import org.apache.plc4x.java.s7.readwrite.COTPParameterChecksum;
import org.apache.plc4x.java.s7.readwrite.COTPParameterDisconnectAdditionalInformation;
import org.apache.plc4x.java.s7.readwrite.COTPParameterTpduSize;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public abstract class COTPParameter
implements Message {
    public abstract Short getParameterType();

    protected abstract void serializeCOTPParameterChild(WriteBuffer var1) throws SerializationException;

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("COTPParameter", new WithWriterArgs[0]);
        FieldWriterFactory.writeDiscriminatorField("parameterType", this.getParameterType(), DataWriterFactory.writeUnsignedShort(writeBuffer, 8), new WithWriterArgs[0]);
        short parameterLength = (short)(this.getLengthInBytes() - 2);
        FieldWriterFactory.writeImplicitField("parameterLength", parameterLength, DataWriterFactory.writeUnsignedShort(writeBuffer, 8), new WithWriterArgs[0]);
        this.serializeCOTPParameterChild(writeBuffer);
        writeBuffer.popContext("COTPParameter", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = 0;
        COTPParameter _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 8;
        return lengthInBits += 8;
    }

    public static COTPParameter staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        Short rest;
        ReadBuffer positionAware = readBuffer;
        if (args == null || args.length != 1) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 1, but got " + args.length);
        }
        if (args[0] instanceof Short) {
            rest = (Short)args[0];
        } else if (args[0] instanceof String) {
            rest = Short.valueOf((String)args[0]);
        } else {
            throw new PlcRuntimeException("Argument 0 expected to be of type Short or a string which is parseable but was " + args[0].getClass().getName());
        }
        return COTPParameter.staticParse(readBuffer, rest);
    }

    public static COTPParameter staticParse(ReadBuffer readBuffer, Short rest) throws ParseException {
        readBuffer.pullContext("COTPParameter", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        short parameterType = FieldReaderFactory.readDiscriminatorField("parameterType", DataReaderFactory.readUnsignedShort(readBuffer, 8), new WithReaderArgs[0]);
        short parameterLength = FieldReaderFactory.readImplicitField("parameterLength", DataReaderFactory.readUnsignedShort(readBuffer, 8), new WithReaderArgs[0]);
        COTPParameterBuilder builder = null;
        if (EvaluationHelper.equals(parameterType, (short)192)) {
            builder = COTPParameterTpduSize.staticParseCOTPParameterBuilder(readBuffer, rest);
        } else if (EvaluationHelper.equals(parameterType, (short)193)) {
            builder = COTPParameterCallingTsap.staticParseCOTPParameterBuilder(readBuffer, rest);
        } else if (EvaluationHelper.equals(parameterType, (short)194)) {
            builder = COTPParameterCalledTsap.staticParseCOTPParameterBuilder(readBuffer, rest);
        } else if (EvaluationHelper.equals(parameterType, (short)195)) {
            builder = COTPParameterChecksum.staticParseCOTPParameterBuilder(readBuffer, rest);
        } else if (EvaluationHelper.equals(parameterType, (short)224)) {
            builder = COTPParameterDisconnectAdditionalInformation.staticParseCOTPParameterBuilder(readBuffer, rest);
        }
        if (builder == null) {
            throw new ParseException("Unsupported case for discriminated type parameters [parameterType=" + parameterType + "]");
        }
        readBuffer.closeContext("COTPParameter", new WithReaderArgs[0]);
        COTPParameter _cOTPParameter = builder.build();
        return _cOTPParameter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof COTPParameter)) {
            return false;
        }
        COTPParameter that = (COTPParameter)o;
        return true;
    }

    public int hashCode() {
        return Objects.hash(new Object[0]);
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static interface COTPParameterBuilder {
        public COTPParameter build();
    }
}

