/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.s7.readwrite.MemoryArea;
import org.apache.plc4x.java.s7.readwrite.S7Address;
import org.apache.plc4x.java.s7.readwrite.TransportSize;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class S7AddressAny
extends S7Address
implements Message {
    protected final TransportSize transportSize;
    protected final int numberOfElements;
    protected final int dbNumber;
    protected final MemoryArea area;
    protected final int byteAddress;
    protected final byte bitAddress;

    @Override
    public Short getAddressType() {
        return (short)16;
    }

    public S7AddressAny(TransportSize transportSize, int numberOfElements, int dbNumber, MemoryArea area, int byteAddress, byte bitAddress) {
        this.transportSize = transportSize;
        this.numberOfElements = numberOfElements;
        this.dbNumber = dbNumber;
        this.area = area;
        this.byteAddress = byteAddress;
        this.bitAddress = bitAddress;
    }

    public TransportSize getTransportSize() {
        return this.transportSize;
    }

    public int getNumberOfElements() {
        return this.numberOfElements;
    }

    public int getDbNumber() {
        return this.dbNumber;
    }

    public MemoryArea getArea() {
        return this.area;
    }

    public int getByteAddress() {
        return this.byteAddress;
    }

    public byte getBitAddress() {
        return this.bitAddress;
    }

    @Override
    protected void serializeS7AddressChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("S7AddressAny", new WithWriterArgs[0]);
        FieldWriterFactory.writeEnumField("transportSize", "TransportSize", this.transportSize, new DataWriterEnumDefault<TransportSize, Short>(TransportSize::getCode, Enum::name, DataWriterFactory.writeUnsignedShort(writeBuffer, 8)), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("numberOfElements", this.numberOfElements, DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("dbNumber", this.dbNumber, DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField("area", "MemoryArea", this.area, new DataWriterEnumDefault<MemoryArea, Short>(MemoryArea::getValue, Enum::name, DataWriterFactory.writeUnsignedShort(writeBuffer, 8)), new WithWriterArgs[0]);
        FieldWriterFactory.writeReservedField("reserved", (byte)0, DataWriterFactory.writeUnsignedByte(writeBuffer, 5), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("byteAddress", this.byteAddress, DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("bitAddress", this.bitAddress, DataWriterFactory.writeUnsignedByte(writeBuffer, 3), new WithWriterArgs[0]);
        writeBuffer.popContext("S7AddressAny", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        S7AddressAny _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 8;
        lengthInBits += 16;
        lengthInBits += 16;
        lengthInBits += 8;
        lengthInBits += 5;
        lengthInBits += 16;
        return lengthInBits += 3;
    }

    public static S7Address.S7AddressBuilder staticParseS7AddressBuilder(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("S7AddressAny", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        TransportSize transportSize = (TransportSize)((Object)FieldReaderFactory.readEnumField("transportSize", "TransportSize", DataReaderFactory.readEnum(TransportSize::firstEnumForFieldCode, DataReaderFactory.readUnsignedShort(readBuffer, 8)), new WithReaderArgs[0]));
        int numberOfElements = FieldReaderFactory.readSimpleField("numberOfElements", DataReaderFactory.readUnsignedInt(readBuffer, 16), new WithReaderArgs[0]);
        int dbNumber = FieldReaderFactory.readSimpleField("dbNumber", DataReaderFactory.readUnsignedInt(readBuffer, 16), new WithReaderArgs[0]);
        MemoryArea area = (MemoryArea)((Object)FieldReaderFactory.readEnumField("area", "MemoryArea", new DataReaderEnumDefault<MemoryArea, Short>(MemoryArea::enumForValue, DataReaderFactory.readUnsignedShort(readBuffer, 8)), new WithReaderArgs[0]));
        Byte reservedField0 = FieldReaderFactory.readReservedField("reserved", DataReaderFactory.readUnsignedByte(readBuffer, 5), (byte)0, new WithReaderArgs[0]);
        int byteAddress = FieldReaderFactory.readSimpleField("byteAddress", DataReaderFactory.readUnsignedInt(readBuffer, 16), new WithReaderArgs[0]);
        byte bitAddress = FieldReaderFactory.readSimpleField("bitAddress", DataReaderFactory.readUnsignedByte(readBuffer, 3), new WithReaderArgs[0]);
        readBuffer.closeContext("S7AddressAny", new WithReaderArgs[0]);
        return new S7AddressAnyBuilderImpl(transportSize, numberOfElements, dbNumber, area, byteAddress, bitAddress);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof S7AddressAny)) {
            return false;
        }
        S7AddressAny that = (S7AddressAny)o;
        return this.getTransportSize() == that.getTransportSize() && this.getNumberOfElements() == that.getNumberOfElements() && this.getDbNumber() == that.getDbNumber() && this.getArea() == that.getArea() && this.getByteAddress() == that.getByteAddress() && this.getBitAddress() == that.getBitAddress() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getTransportSize(), this.getNumberOfElements(), this.getDbNumber(), this.getArea(), this.getByteAddress(), this.getBitAddress()});
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class S7AddressAnyBuilderImpl
    implements S7Address.S7AddressBuilder {
        private final TransportSize transportSize;
        private final int numberOfElements;
        private final int dbNumber;
        private final MemoryArea area;
        private final int byteAddress;
        private final byte bitAddress;

        public S7AddressAnyBuilderImpl(TransportSize transportSize, int numberOfElements, int dbNumber, MemoryArea area, int byteAddress, byte bitAddress) {
            this.transportSize = transportSize;
            this.numberOfElements = numberOfElements;
            this.dbNumber = dbNumber;
            this.area = area;
            this.byteAddress = byteAddress;
            this.bitAddress = bitAddress;
        }

        @Override
        public S7AddressAny build() {
            S7AddressAny s7AddressAny = new S7AddressAny(this.transportSize, this.numberOfElements, this.dbNumber, this.area, this.byteAddress, this.bitAddress);
            return s7AddressAny;
        }
    }
}

