/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.s7.readwrite.S7MessageRequest;
import org.apache.plc4x.java.s7.readwrite.S7MessageResponse;
import org.apache.plc4x.java.s7.readwrite.S7MessageResponseData;
import org.apache.plc4x.java.s7.readwrite.S7MessageUserData;
import org.apache.plc4x.java.s7.readwrite.S7Parameter;
import org.apache.plc4x.java.s7.readwrite.S7Payload;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public abstract class S7Message
implements Message {
    public static final Short PROTOCOLID = 50;
    protected final int tpduReference;
    protected final S7Parameter parameter;
    protected final S7Payload payload;

    public abstract Short getMessageType();

    public S7Message(int tpduReference, S7Parameter parameter, S7Payload payload) {
        this.tpduReference = tpduReference;
        this.parameter = parameter;
        this.payload = payload;
    }

    public int getTpduReference() {
        return this.tpduReference;
    }

    public S7Parameter getParameter() {
        return this.parameter;
    }

    public S7Payload getPayload() {
        return this.payload;
    }

    public short getProtocolId() {
        return PROTOCOLID;
    }

    protected abstract void serializeS7MessageChild(WriteBuffer var1) throws SerializationException;

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("S7Message", new WithWriterArgs[0]);
        FieldWriterFactory.writeConstField("protocolId", PROTOCOLID, DataWriterFactory.writeUnsignedShort(writeBuffer, 8), new WithWriterArgs[0]);
        FieldWriterFactory.writeDiscriminatorField("messageType", this.getMessageType(), DataWriterFactory.writeUnsignedShort(writeBuffer, 8), new WithWriterArgs[0]);
        FieldWriterFactory.writeReservedField("reserved", 0, DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("tpduReference", this.tpduReference, DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        int parameterLength = this.getParameter() != null ? this.getParameter().getLengthInBytes() : 0;
        FieldWriterFactory.writeImplicitField("parameterLength", parameterLength, DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        int payloadLength = this.getPayload() != null ? this.getPayload().getLengthInBytes() : 0;
        FieldWriterFactory.writeImplicitField("payloadLength", payloadLength, DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        this.serializeS7MessageChild(writeBuffer);
        FieldWriterFactory.writeOptionalField("parameter", this.parameter, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField("payload", this.payload, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        writeBuffer.popContext("S7Message", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = 0;
        S7Message _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 8;
        lengthInBits += 8;
        lengthInBits += 16;
        lengthInBits += 16;
        lengthInBits += 16;
        lengthInBits += 16;
        if (this.parameter != null) {
            lengthInBits += this.parameter.getLengthInBits();
        }
        if (this.payload != null) {
            lengthInBits += this.payload.getLengthInBits();
        }
        return lengthInBits;
    }

    public static S7Message staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        ReadBuffer positionAware = readBuffer;
        return S7Message.staticParse(readBuffer);
    }

    public static S7Message staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("S7Message", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        short protocolId = FieldReaderFactory.readConstField("protocolId", DataReaderFactory.readUnsignedShort(readBuffer, 8), PROTOCOLID, new WithReaderArgs[0]);
        short messageType = FieldReaderFactory.readDiscriminatorField("messageType", DataReaderFactory.readUnsignedShort(readBuffer, 8), new WithReaderArgs[0]);
        Integer reservedField0 = FieldReaderFactory.readReservedField("reserved", DataReaderFactory.readUnsignedInt(readBuffer, 16), 0, new WithReaderArgs[0]);
        int tpduReference = FieldReaderFactory.readSimpleField("tpduReference", DataReaderFactory.readUnsignedInt(readBuffer, 16), new WithReaderArgs[0]);
        int parameterLength = FieldReaderFactory.readImplicitField("parameterLength", DataReaderFactory.readUnsignedInt(readBuffer, 16), new WithReaderArgs[0]);
        int payloadLength = FieldReaderFactory.readImplicitField("payloadLength", DataReaderFactory.readUnsignedInt(readBuffer, 16), new WithReaderArgs[0]);
        S7MessageBuilder builder = null;
        if (EvaluationHelper.equals(messageType, (short)1)) {
            builder = S7MessageRequest.staticParseS7MessageBuilder(readBuffer);
        } else if (EvaluationHelper.equals(messageType, (short)2)) {
            builder = S7MessageResponse.staticParseS7MessageBuilder(readBuffer);
        } else if (EvaluationHelper.equals(messageType, (short)3)) {
            builder = S7MessageResponseData.staticParseS7MessageBuilder(readBuffer);
        } else if (EvaluationHelper.equals(messageType, (short)7)) {
            builder = S7MessageUserData.staticParseS7MessageBuilder(readBuffer);
        }
        if (builder == null) {
            throw new ParseException("Unsupported case for discriminated type parameters [messageType=" + messageType + "]");
        }
        S7Parameter parameter = FieldReaderFactory.readOptionalField("parameter", new DataReaderComplexDefault<S7Parameter>(() -> S7Parameter.staticParse(readBuffer, messageType), readBuffer), parameterLength > 0, new WithReaderArgs[0]);
        S7Payload payload = FieldReaderFactory.readOptionalField("payload", new DataReaderComplexDefault<S7Payload>(() -> S7Payload.staticParse(readBuffer, messageType, parameter), readBuffer), payloadLength > 0, new WithReaderArgs[0]);
        readBuffer.closeContext("S7Message", new WithReaderArgs[0]);
        S7Message _s7Message = builder.build(tpduReference, parameter, payload);
        return _s7Message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof S7Message)) {
            return false;
        }
        S7Message that = (S7Message)o;
        return this.getTpduReference() == that.getTpduReference() && this.getParameter() == that.getParameter() && this.getPayload() == that.getPayload();
    }

    public int hashCode() {
        return Objects.hash(this.getTpduReference(), this.getParameter(), this.getPayload());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static interface S7MessageBuilder {
        public S7Message build(int var1, S7Parameter var2, S7Payload var3);
    }
}

