/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.s7.readwrite.S7Parameter;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class S7ParameterSetupCommunication
extends S7Parameter
implements Message {
    protected final int maxAmqCaller;
    protected final int maxAmqCallee;
    protected final int pduLength;

    @Override
    public Short getParameterType() {
        return (short)240;
    }

    @Override
    public Short getMessageType() {
        return (short)0;
    }

    public S7ParameterSetupCommunication(int maxAmqCaller, int maxAmqCallee, int pduLength) {
        this.maxAmqCaller = maxAmqCaller;
        this.maxAmqCallee = maxAmqCallee;
        this.pduLength = pduLength;
    }

    public int getMaxAmqCaller() {
        return this.maxAmqCaller;
    }

    public int getMaxAmqCallee() {
        return this.maxAmqCallee;
    }

    public int getPduLength() {
        return this.pduLength;
    }

    @Override
    protected void serializeS7ParameterChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("S7ParameterSetupCommunication", new WithWriterArgs[0]);
        FieldWriterFactory.writeReservedField("reserved", (short)0, DataWriterFactory.writeUnsignedShort(writeBuffer, 8), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("maxAmqCaller", this.maxAmqCaller, DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("maxAmqCallee", this.maxAmqCallee, DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("pduLength", this.pduLength, DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        writeBuffer.popContext("S7ParameterSetupCommunication", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        S7ParameterSetupCommunication _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 8;
        lengthInBits += 16;
        lengthInBits += 16;
        return lengthInBits += 16;
    }

    public static S7Parameter.S7ParameterBuilder staticParseS7ParameterBuilder(ReadBuffer readBuffer, Short messageType) throws ParseException {
        readBuffer.pullContext("S7ParameterSetupCommunication", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        Short reservedField0 = FieldReaderFactory.readReservedField("reserved", DataReaderFactory.readUnsignedShort(readBuffer, 8), (short)0, new WithReaderArgs[0]);
        int maxAmqCaller = FieldReaderFactory.readSimpleField("maxAmqCaller", DataReaderFactory.readUnsignedInt(readBuffer, 16), new WithReaderArgs[0]);
        int maxAmqCallee = FieldReaderFactory.readSimpleField("maxAmqCallee", DataReaderFactory.readUnsignedInt(readBuffer, 16), new WithReaderArgs[0]);
        int pduLength = FieldReaderFactory.readSimpleField("pduLength", DataReaderFactory.readUnsignedInt(readBuffer, 16), new WithReaderArgs[0]);
        readBuffer.closeContext("S7ParameterSetupCommunication", new WithReaderArgs[0]);
        return new S7ParameterSetupCommunicationBuilderImpl(maxAmqCaller, maxAmqCallee, pduLength);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof S7ParameterSetupCommunication)) {
            return false;
        }
        S7ParameterSetupCommunication that = (S7ParameterSetupCommunication)o;
        return this.getMaxAmqCaller() == that.getMaxAmqCaller() && this.getMaxAmqCallee() == that.getMaxAmqCallee() && this.getPduLength() == that.getPduLength() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getMaxAmqCaller(), this.getMaxAmqCallee(), this.getPduLength());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class S7ParameterSetupCommunicationBuilderImpl
    implements S7Parameter.S7ParameterBuilder {
        private final int maxAmqCaller;
        private final int maxAmqCallee;
        private final int pduLength;

        public S7ParameterSetupCommunicationBuilderImpl(int maxAmqCaller, int maxAmqCallee, int pduLength) {
            this.maxAmqCaller = maxAmqCaller;
            this.maxAmqCallee = maxAmqCallee;
            this.pduLength = pduLength;
        }

        @Override
        public S7ParameterSetupCommunication build() {
            S7ParameterSetupCommunication s7ParameterSetupCommunication = new S7ParameterSetupCommunication(this.maxAmqCaller, this.maxAmqCallee, this.pduLength);
            return s7ParameterSetupCommunication;
        }
    }
}

