/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.s7.readwrite.DataTransportErrorCode;
import org.apache.plc4x.java.s7.readwrite.DataTransportSize;
import org.apache.plc4x.java.s7.readwrite.DateAndTime;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItem;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class S7PayloadDiagnosticMessage
extends S7PayloadUserDataItem
implements Message {
    protected final int eventId;
    protected final short priorityClass;
    protected final short obNumber;
    protected final int datId;
    protected final int info1;
    protected final long info2;
    protected final DateAndTime timeStamp;

    @Override
    public Byte getCpuFunctionGroup() {
        return (byte)4;
    }

    @Override
    public Byte getCpuFunctionType() {
        return (byte)0;
    }

    @Override
    public Short getCpuSubfunction() {
        return (short)3;
    }

    public S7PayloadDiagnosticMessage(DataTransportErrorCode returnCode, DataTransportSize transportSize, int dataLength, int eventId, short priorityClass, short obNumber, int datId, int info1, long info2, DateAndTime timeStamp) {
        super(returnCode, transportSize, dataLength);
        this.eventId = eventId;
        this.priorityClass = priorityClass;
        this.obNumber = obNumber;
        this.datId = datId;
        this.info1 = info1;
        this.info2 = info2;
        this.timeStamp = timeStamp;
    }

    public int getEventId() {
        return this.eventId;
    }

    public short getPriorityClass() {
        return this.priorityClass;
    }

    public short getObNumber() {
        return this.obNumber;
    }

    public int getDatId() {
        return this.datId;
    }

    public int getInfo1() {
        return this.info1;
    }

    public long getInfo2() {
        return this.info2;
    }

    public DateAndTime getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    protected void serializeS7PayloadUserDataItemChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("S7PayloadDiagnosticMessage", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("eventId", this.eventId, DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("priorityClass", this.priorityClass, DataWriterFactory.writeUnsignedShort(writeBuffer, 8), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("obNumber", this.obNumber, DataWriterFactory.writeUnsignedShort(writeBuffer, 8), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("datId", this.datId, DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("info1", this.info1, DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("info2", this.info2, DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("timeStamp", this.timeStamp, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        writeBuffer.popContext("S7PayloadDiagnosticMessage", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        S7PayloadDiagnosticMessage _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 16;
        lengthInBits += 8;
        lengthInBits += 8;
        lengthInBits += 16;
        lengthInBits += 16;
        lengthInBits += 32;
        return lengthInBits += this.timeStamp.getLengthInBits();
    }

    public static S7PayloadUserDataItem.S7PayloadUserDataItemBuilder staticParseS7PayloadUserDataItemBuilder(ReadBuffer readBuffer, Byte cpuFunctionGroup, Byte cpuFunctionType, Short cpuSubfunction) throws ParseException {
        readBuffer.pullContext("S7PayloadDiagnosticMessage", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        int eventId = FieldReaderFactory.readSimpleField("eventId", DataReaderFactory.readUnsignedInt(readBuffer, 16), new WithReaderArgs[0]);
        short priorityClass = FieldReaderFactory.readSimpleField("priorityClass", DataReaderFactory.readUnsignedShort(readBuffer, 8), new WithReaderArgs[0]);
        short obNumber = FieldReaderFactory.readSimpleField("obNumber", DataReaderFactory.readUnsignedShort(readBuffer, 8), new WithReaderArgs[0]);
        int datId = FieldReaderFactory.readSimpleField("datId", DataReaderFactory.readUnsignedInt(readBuffer, 16), new WithReaderArgs[0]);
        int info1 = FieldReaderFactory.readSimpleField("info1", DataReaderFactory.readUnsignedInt(readBuffer, 16), new WithReaderArgs[0]);
        long info2 = FieldReaderFactory.readSimpleField("info2", DataReaderFactory.readUnsignedLong(readBuffer, 32), new WithReaderArgs[0]);
        DateAndTime timeStamp = FieldReaderFactory.readSimpleField("timeStamp", new DataReaderComplexDefault<DateAndTime>(() -> DateAndTime.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        readBuffer.closeContext("S7PayloadDiagnosticMessage", new WithReaderArgs[0]);
        return new S7PayloadDiagnosticMessageBuilderImpl(eventId, priorityClass, obNumber, datId, info1, info2, timeStamp);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof S7PayloadDiagnosticMessage)) {
            return false;
        }
        S7PayloadDiagnosticMessage that = (S7PayloadDiagnosticMessage)o;
        return this.getEventId() == that.getEventId() && this.getPriorityClass() == that.getPriorityClass() && this.getObNumber() == that.getObNumber() && this.getDatId() == that.getDatId() && this.getInfo1() == that.getInfo1() && this.getInfo2() == that.getInfo2() && this.getTimeStamp() == that.getTimeStamp() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getEventId(), this.getPriorityClass(), this.getObNumber(), this.getDatId(), this.getInfo1(), this.getInfo2(), this.getTimeStamp());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class S7PayloadDiagnosticMessageBuilderImpl
    implements S7PayloadUserDataItem.S7PayloadUserDataItemBuilder {
        private final int eventId;
        private final short priorityClass;
        private final short obNumber;
        private final int datId;
        private final int info1;
        private final long info2;
        private final DateAndTime timeStamp;

        public S7PayloadDiagnosticMessageBuilderImpl(int eventId, short priorityClass, short obNumber, int datId, int info1, long info2, DateAndTime timeStamp) {
            this.eventId = eventId;
            this.priorityClass = priorityClass;
            this.obNumber = obNumber;
            this.datId = datId;
            this.info1 = info1;
            this.info2 = info2;
            this.timeStamp = timeStamp;
        }

        @Override
        public S7PayloadDiagnosticMessage build(DataTransportErrorCode returnCode, DataTransportSize transportSize, int dataLength) {
            S7PayloadDiagnosticMessage s7PayloadDiagnosticMessage = new S7PayloadDiagnosticMessage(returnCode, transportSize, dataLength, this.eventId, this.priorityClass, this.obNumber, this.datId, this.info1, this.info2, this.timeStamp);
            return s7PayloadDiagnosticMessage;
        }
    }
}

