/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.s7.readwrite.COTPPacket;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class TPKTPacket
implements Message {
    public static final Short PROTOCOLID = 3;
    protected final COTPPacket payload;

    public TPKTPacket(COTPPacket payload) {
        this.payload = payload;
    }

    public COTPPacket getPayload() {
        return this.payload;
    }

    public short getProtocolId() {
        return PROTOCOLID;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("TPKTPacket", new WithWriterArgs[0]);
        FieldWriterFactory.writeConstField("protocolId", PROTOCOLID, DataWriterFactory.writeUnsignedShort(writeBuffer, 8), WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));
        FieldWriterFactory.writeReservedField("reserved", (short)0, DataWriterFactory.writeUnsignedShort(writeBuffer, 8), WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));
        int len = this.getPayload().getLengthInBytes() + 4;
        FieldWriterFactory.writeImplicitField("len", len, DataWriterFactory.writeUnsignedInt(writeBuffer, 16), WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));
        FieldWriterFactory.writeSimpleField("payload", this.payload, new DataWriterComplexDefault(writeBuffer), WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));
        writeBuffer.popContext("TPKTPacket", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = 0;
        TPKTPacket _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 8;
        lengthInBits += 8;
        lengthInBits += 16;
        return lengthInBits += this.payload.getLengthInBits();
    }

    public static TPKTPacket staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        ReadBuffer positionAware = readBuffer;
        return TPKTPacket.staticParse(readBuffer);
    }

    public static TPKTPacket staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("TPKTPacket", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        short protocolId = FieldReaderFactory.readConstField("protocolId", DataReaderFactory.readUnsignedShort(readBuffer, 8), PROTOCOLID, WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));
        Short reservedField0 = FieldReaderFactory.readReservedField("reserved", DataReaderFactory.readUnsignedShort(readBuffer, 8), (short)0, WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));
        int len = FieldReaderFactory.readImplicitField("len", DataReaderFactory.readUnsignedInt(readBuffer, 16), WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));
        COTPPacket payload = FieldReaderFactory.readSimpleField("payload", new DataReaderComplexDefault<COTPPacket>(() -> COTPPacket.staticParse(readBuffer, len - 4), readBuffer), WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));
        readBuffer.closeContext("TPKTPacket", new WithReaderArgs[0]);
        TPKTPacket _tPKTPacket = new TPKTPacket(payload);
        return _tPKTPacket;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TPKTPacket)) {
            return false;
        }
        TPKTPacket that = (TPKTPacket)o;
        return this.getPayload() == that.getPayload();
    }

    public int hashCode() {
        return Objects.hash(this.getPayload());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

