/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite.connection;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.AttributeKey;
import java.time.LocalTime;
import java.util.List;
import org.apache.plc4x.java.s7.readwrite.connection.S7HMux;
import org.apache.plc4x.java.spi.events.ConnectEvent;
import org.apache.plc4x.java.spi.events.DisconnectEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class S7HMuxImpl
extends MessageToMessageCodec<ByteBuf, ByteBuf>
implements S7HMux {
    private static final Logger logger = LoggerFactory.getLogger(S7HMuxImpl.class);
    public static final AttributeKey<Boolean> IS_CONNECTED = AttributeKey.valueOf("IS_CONNECTED");
    public static final AttributeKey<Boolean> IS_PRIMARY = AttributeKey.valueOf("IS_PRIMARY");
    public static final AttributeKey<Integer> READ_TIME_OUT = AttributeKey.valueOf("READ_TIME_OUT");
    public static final AttributeKey<Boolean> IS_PING_ACTIVE = AttributeKey.valueOf("IS_PIN_ACTIVE");
    public static final AttributeKey<Integer> PING_TIME = AttributeKey.valueOf("PING_TIME");
    public static final AttributeKey<Integer> RETRY_TIME = AttributeKey.valueOf("RETRY_TIME");
    ChannelHandlerContext embed_ctx = null;
    protected Channel embeded_channel = null;
    protected Channel tcp_channel = null;
    protected Channel primary_channel = null;
    protected Channel secondary_channel = null;

    @Override
    protected void encode(ChannelHandlerContext ctx, ByteBuf outbb, List<Object> list) throws Exception {
        logger.debug("ENCODE: " + outbb.toString());
        if (this.embed_ctx == null && ctx.channel() instanceof EmbeddedChannel) {
            this.embed_ctx = ctx;
        }
        if (this.tcp_channel != null && this.embed_ctx == ctx) {
            this.tcp_channel.writeAndFlush(outbb.copy());
        } else {
            list.add(outbb.copy());
        }
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf inbb, List<Object> list) throws Exception {
        this.embed_ctx.fireChannelRead(inbb.copy());
    }

    @Override
    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        super.channelRegistered(ctx);
        logger.debug("channelRegistered: {}", (Object)ctx.name());
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        super.exceptionCaught(ctx, cause);
        logger.debug("exceptionCaught: {}", (Object)ctx.name());
    }

    @Override
    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        super.channelWritabilityChanged(ctx);
        logger.debug("channelWritabilityChanged: {}", (Object)ctx.name());
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        super.userEventTriggered(ctx, evt);
        logger.info("{}  userEventTriggered: {} Event: {}", new Object[]{LocalTime.now(), ctx.name(), evt});
        if (evt instanceof ConnectEvent) {
            try {
                this.tcp_channel.pipeline().remove("watchdog");
            }
            catch (Exception ex) {
                logger.info(ex.toString());
            }
            try {
                this.tcp_channel.pipeline().addFirst("watchdog", (ChannelHandler)new ReadTimeoutHandler(30));
                if (this.tcp_channel.isActive()) {
                    this.embeded_channel.attr(IS_CONNECTED).set(true);
                } else {
                    this.embeded_channel.attr(IS_CONNECTED).set(false);
                }
            }
            catch (Exception ex) {
                logger.info(ex.toString());
            }
        }
        if (evt instanceof DisconnectEvent) {
            logger.info("DisconnectEvent");
        }
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        super.channelReadComplete(ctx);
        logger.debug("{} channelReadComplete: {}", (Object)LocalTime.now(), (Object)ctx.name());
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        logger.debug("channelInactive: {}", (Object)ctx.name());
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        logger.debug("channelActive: {}", (Object)ctx.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        Channel channel;
        super.channelUnregistered(ctx);
        logger.debug("{} channelUnregistered: {}", (Object)LocalTime.now(), (Object)ctx.name());
        String strCanal = this.tcp_channel == this.primary_channel ? "PRIMARY" : "SECONDARY";
        logger.debug("Unregistered of channel: " + strCanal);
        if (ctx == this.embed_ctx) {
            return;
        }
        if (this.tcp_channel == ctx.channel()) {
            this.embeded_channel.attr(IS_CONNECTED).set(false);
        }
        logger.info(this.embed_ctx.executor().toString());
        if (this.tcp_channel == this.primary_channel && this.primary_channel == ctx.channel() && !this.primary_channel.isActive() && this.secondary_channel != null && this.secondary_channel.isActive()) {
            channel = this.tcp_channel;
            synchronized (channel) {
                logger.info("Using secondary TCP channel.");
                this.tcp_channel = this.secondary_channel;
                this.embeded_channel.attr(IS_PRIMARY).set(false);
                this.embeded_channel.pipeline().fireUserEventTriggered(new ConnectEvent());
            }
        }
        if (this.tcp_channel == this.secondary_channel && this.secondary_channel == ctx.channel() && !this.secondary_channel.isActive() && this.primary_channel.isActive()) {
            channel = this.tcp_channel;
            synchronized (channel) {
                logger.info("Using primary TCP channel.");
                this.tcp_channel = this.primary_channel;
                this.embeded_channel.attr(IS_PRIMARY).set(true);
                this.embeded_channel.pipeline().fireUserEventTriggered(new ConnectEvent());
            }
        }
    }

    @Override
    public void setEmbeddedChannel(Channel embeded_channel) {
        this.embeded_channel = embeded_channel;
        this.embeded_channel.attr(IS_CONNECTED).set(false);
        this.embeded_channel.attr(IS_PRIMARY).set(true);
        this.embeded_channel.attr(READ_TIME_OUT).set(8);
        this.embeded_channel.attr(IS_PING_ACTIVE).set(false);
        this.embeded_channel.attr(PING_TIME).set(-1);
        this.embeded_channel.attr(RETRY_TIME).set(8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPrimaryChannel(Channel primary_channel) {
        if (this.primary_channel == null && this.tcp_channel == null) {
            if (primary_channel != null) {
                this.primary_channel = primary_channel;
                this.tcp_channel = primary_channel;
                this.embeded_channel.attr(IS_PRIMARY).set(true);
            }
        } else if (!this.primary_channel.isActive() && this.tcp_channel == this.secondary_channel) {
            this.primary_channel = primary_channel;
        } else if (!this.primary_channel.isActive() && this.tcp_channel == this.primary_channel) {
            Channel channel = this.tcp_channel;
            synchronized (channel) {
                this.tcp_channel.close();
                this.primary_channel = primary_channel;
                this.tcp_channel = primary_channel;
                this.embeded_channel.attr(IS_PRIMARY).set(true);
                if (this.tcp_channel.isActive()) {
                    this.embed_ctx.fireUserEventTriggered(new ConnectEvent());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSecondaryChannel(Channel secondary_channel) {
        if (this.primary_channel == null && this.tcp_channel == null) {
            if (secondary_channel != null) {
                this.secondary_channel = secondary_channel;
                this.tcp_channel = secondary_channel;
                this.embeded_channel.attr(IS_PRIMARY).set(false);
            }
        } else if (this.secondary_channel == null || this.tcp_channel == this.primary_channel) {
            this.secondary_channel = secondary_channel;
        } else if (!this.secondary_channel.isActive() && this.tcp_channel == this.primary_channel) {
            this.secondary_channel = secondary_channel;
        } else if (!this.secondary_channel.isActive() && this.tcp_channel == this.secondary_channel) {
            Channel channel = this.tcp_channel;
            synchronized (channel) {
                this.tcp_channel.close();
                this.secondary_channel = secondary_channel;
                this.tcp_channel = secondary_channel;
                this.embeded_channel.attr(IS_PRIMARY).set(false);
            }
            if (this.tcp_channel.isActive()) {
                this.embed_ctx.fireUserEventTriggered(new ConnectEvent());
            }
        }
    }
}

