/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.simulated;

import org.apache.plc4x.java.api.PlcConnection;
import org.apache.plc4x.java.api.PlcDriver;
import org.apache.plc4x.java.api.authentication.PlcAuthentication;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.simulated.connection.SimulatedConnection;
import org.apache.plc4x.java.simulated.connection.SimulatedDevice;
import org.apache.plc4x.java.simulated.tag.SimulatedTag;

public class SimulatedDriver
implements PlcDriver {
    @Override
    public String getProtocolCode() {
        return "simulated";
    }

    @Override
    public String getProtocolName() {
        return "Simulated PLC4X Datasource";
    }

    @Override
    public PlcConnection getConnection(String url) throws PlcConnectionException {
        String deviceName = url.substring(this.getProtocolCode().length() + 1);
        if (deviceName.isEmpty()) {
            throw new PlcConnectionException("Invalid URL: no device name given.");
        }
        SimulatedDevice device = new SimulatedDevice(deviceName);
        return new SimulatedConnection(device);
    }

    @Override
    public PlcConnection getConnection(String url, PlcAuthentication authentication) throws PlcConnectionException {
        throw new PlcConnectionException("Test driver does not support authentication.");
    }

    @Override
    public SimulatedTag prepareTag(String tagAddress) {
        return SimulatedTag.of(tagAddress);
    }
}

