/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.simulated.connection;

import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.plc4x.java.api.messages.PlcPingResponse;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.api.messages.PlcSubscriptionEvent;
import org.apache.plc4x.java.api.messages.PlcSubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcSubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.messages.PlcWriteResponse;
import org.apache.plc4x.java.api.model.PlcConsumerRegistration;
import org.apache.plc4x.java.api.model.PlcSubscriptionHandle;
import org.apache.plc4x.java.api.model.PlcSubscriptionTag;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.simulated.connection.SimulatedDevice;
import org.apache.plc4x.java.simulated.tag.SimulatedTag;
import org.apache.plc4x.java.simulated.tag.SimulatedTagHandler;
import org.apache.plc4x.java.spi.connection.AbstractPlcConnection;
import org.apache.plc4x.java.spi.messages.DefaultPlcPingRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcPingResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcSubscriptionEvent;
import org.apache.plc4x.java.spi.messages.DefaultPlcSubscriptionResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcUnsubscriptionResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteResponse;
import org.apache.plc4x.java.spi.messages.PlcReader;
import org.apache.plc4x.java.spi.messages.PlcSubscriber;
import org.apache.plc4x.java.spi.messages.PlcWriter;
import org.apache.plc4x.java.spi.messages.utils.ResponseItem;
import org.apache.plc4x.java.spi.model.DefaultPlcConsumerRegistration;
import org.apache.plc4x.java.spi.model.DefaultPlcSubscriptionHandle;
import org.apache.plc4x.java.spi.values.PlcValueHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimulatedConnection
extends AbstractPlcConnection
implements PlcReader,
PlcWriter,
PlcSubscriber {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimulatedConnection.class);
    private final SimulatedDevice device;
    private boolean connected = false;
    private final Map<PlcSubscriptionHandle, PlcConsumerRegistration> registrations = new ConcurrentHashMap<PlcSubscriptionHandle, PlcConsumerRegistration>();
    private final Map<Integer, Consumer<PlcSubscriptionEvent>> consumerIdMap = new ConcurrentHashMap<Integer, Consumer<PlcSubscriptionEvent>>();

    public SimulatedConnection(SimulatedDevice device) {
        super(true, true, true, true, false, new SimulatedTagHandler(), new PlcValueHandler(), null, null);
        this.device = device;
    }

    @Override
    public void connect() {
        this.connected = true;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public void close() {
        this.connected = false;
    }

    @Override
    public CompletableFuture<? extends PlcPingResponse> ping() {
        return CompletableFuture.completedFuture(new DefaultPlcPingResponse(new DefaultPlcPingRequest(this), PlcResponseCode.OK));
    }

    @Override
    public CompletableFuture<PlcReadResponse> read(PlcReadRequest readRequest) {
        HashMap<String, ResponseItem<PlcValue>> tags = new HashMap<String, ResponseItem<PlcValue>>();
        for (String tagName : readRequest.getTagNames()) {
            SimulatedTag tag = (SimulatedTag)readRequest.getTag(tagName);
            Optional<PlcValue> valueOptional = this.device.get(tag);
            boolean present = valueOptional.isPresent();
            ResponseItem<PlcValue> tagPair = present ? new ResponseItem<PlcValue>(PlcResponseCode.OK, valueOptional.get()) : new ResponseItem<Object>(PlcResponseCode.NOT_FOUND, null);
            tags.put(tagName, tagPair);
        }
        DefaultPlcReadResponse response = new DefaultPlcReadResponse(readRequest, tags);
        return CompletableFuture.completedFuture(response);
    }

    @Override
    public CompletableFuture<PlcWriteResponse> write(PlcWriteRequest writeRequest) {
        HashMap<String, PlcResponseCode> tags = new HashMap<String, PlcResponseCode>();
        for (String tagName : writeRequest.getTagNames()) {
            SimulatedTag tag = (SimulatedTag)writeRequest.getTag(tagName);
            PlcValue value = writeRequest.getPlcValue(tagName);
            this.device.set(tag, value);
            tags.put(tagName, PlcResponseCode.OK);
        }
        DefaultPlcWriteResponse response = new DefaultPlcWriteResponse(writeRequest, tags);
        return CompletableFuture.completedFuture(response);
    }

    public String toString() {
        return String.format("simulated:%s", this.device);
    }

    @Override
    public CompletableFuture<PlcSubscriptionResponse> subscribe(PlcSubscriptionRequest subscriptionRequest) {
        LOGGER.info("subscribing {}", (Object)subscriptionRequest);
        HashMap<String, ResponseItem<PlcSubscriptionHandle>> values = new HashMap<String, ResponseItem<PlcSubscriptionHandle>>();
        subscriptionRequest.getTagNames().forEach(name -> {
            LOGGER.info("creating handle for tag name {}", name);
            DefaultPlcSubscriptionHandle handle = new DefaultPlcSubscriptionHandle(this);
            PlcSubscriptionTag subscriptionTag = subscriptionRequest.getTag((String)name);
            switch (subscriptionTag.getPlcSubscriptionType()) {
                case CYCLIC: {
                    LOGGER.info("Adding cyclic subscription for tag name {}", name);
                    this.device.addCyclicSubscription(this.dispatchSubscriptionEvent((String)name, handle), handle, subscriptionTag, subscriptionTag.getDuration().orElseThrow(RuntimeException::new));
                    break;
                }
                case CHANGE_OF_STATE: {
                    LOGGER.info("Adding change of state subscription for tag name {}", name);
                    this.device.addChangeOfStateSubscription(this.dispatchSubscriptionEvent((String)name, handle), handle, subscriptionTag);
                    break;
                }
                case EVENT: {
                    LOGGER.info("Adding event subscription for tag name {}", name);
                    this.device.addEventSubscription(this.dispatchSubscriptionEvent((String)name, handle), handle, subscriptionTag);
                }
            }
            values.put((String)name, (ResponseItem<PlcSubscriptionHandle>)new ResponseItem<DefaultPlcSubscriptionHandle>(PlcResponseCode.OK, handle));
        });
        DefaultPlcSubscriptionResponse response = new DefaultPlcSubscriptionResponse(subscriptionRequest, values);
        return CompletableFuture.completedFuture(response);
    }

    private Consumer<PlcValue> dispatchSubscriptionEvent(String name, PlcSubscriptionHandle handle) {
        return plcValue -> {
            LOGGER.info("handling plc value {}", plcValue);
            PlcConsumerRegistration plcConsumerRegistration = this.registrations.get(handle);
            if (plcConsumerRegistration == null) {
                LOGGER.warn("no registration for handle {}", (Object)handle);
                return;
            }
            int consumerId = plcConsumerRegistration.getConsumerId();
            Consumer<PlcSubscriptionEvent> consumer = this.consumerIdMap.get(consumerId);
            if (consumer == null) {
                LOGGER.warn("no consumer for id {}", (Object)consumerId);
                return;
            }
            consumer.accept(new DefaultPlcSubscriptionEvent(Instant.now(), Collections.singletonMap(name, new ResponseItem<PlcValue>(PlcResponseCode.OK, (PlcValue)plcValue))));
        };
    }

    @Override
    public CompletableFuture<PlcUnsubscriptionResponse> unsubscribe(PlcUnsubscriptionRequest unsubscriptionRequest) {
        LOGGER.info("unsubscribing {}", (Object)unsubscriptionRequest);
        this.device.removeHandles(unsubscriptionRequest.getSubscriptionHandles());
        DefaultPlcUnsubscriptionResponse response = new DefaultPlcUnsubscriptionResponse(unsubscriptionRequest);
        return CompletableFuture.completedFuture(response);
    }

    @Override
    public PlcConsumerRegistration register(Consumer<PlcSubscriptionEvent> consumer, Collection<PlcSubscriptionHandle> handles) {
        LOGGER.info("Registering consumer {} with handles {}", consumer, handles);
        DefaultPlcConsumerRegistration plcConsumerRegistration = new DefaultPlcConsumerRegistration(this, consumer, handles.toArray(new PlcSubscriptionHandle[0]));
        handles.stream().map(PlcSubscriptionHandle.class::cast).forEach(handle -> {
            PlcConsumerRegistration plcConsumerRegistration2 = this.registrations.put((PlcSubscriptionHandle)handle, plcConsumerRegistration);
        });
        this.consumerIdMap.put(plcConsumerRegistration.getConsumerId(), consumer);
        return plcConsumerRegistration;
    }

    @Override
    public void unregister(PlcConsumerRegistration registration) {
        LOGGER.info("Unregistering {}", (Object)registration);
        Iterator<Map.Entry<PlcSubscriptionHandle, PlcConsumerRegistration>> entryIterator = this.registrations.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<PlcSubscriptionHandle, PlcConsumerRegistration> entry = entryIterator.next();
            if (!entry.getValue().equals(registration)) {
                LOGGER.debug("not the value we looking for {}. We are looking for {}", (Object)entry.getValue(), (Object)registration);
                continue;
            }
            PlcConsumerRegistration consumerRegistration = entry.getValue();
            int consumerId = consumerRegistration.getConsumerId();
            LOGGER.info("Removing consumer {}", (Object)consumerId);
            this.consumerIdMap.remove(consumerId);
            LOGGER.info("Removing handles {}", consumerRegistration.getSubscriptionHandles());
            this.device.removeHandles(consumerRegistration.getSubscriptionHandles());
            entryIterator.remove();
        }
    }
}

