/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.simulated.connection;

import java.security.SecureRandom;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.plc4x.java.api.model.PlcSubscriptionHandle;
import org.apache.plc4x.java.api.model.PlcSubscriptionTag;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.simulated.readwrite.DataItem;
import org.apache.plc4x.java.simulated.readwrite.SimulatedDataTypeSizes;
import org.apache.plc4x.java.simulated.tag.SimulatedTag;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBufferByteBased;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WriteBufferByteBased;
import org.apache.plc4x.java.spi.model.DefaultPlcSubscriptionTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimulatedDevice {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimulatedDevice.class);
    private final Random random = new SecureRandom();
    private final String name;
    private final Map<SimulatedTag, PlcValue> state = new HashMap<SimulatedTag, PlcValue>();
    private final Map<PlcSubscriptionHandle, ScheduledFuture<?>> cyclicSubscriptions = new HashMap();
    private final Map<PlcSubscriptionHandle, Future<?>> eventSubscriptions = new HashMap();
    private final IdentityHashMap<PlcSubscriptionHandle, Pair<SimulatedTag, Consumer<PlcValue>>> changeOfStateSubscriptions = new IdentityHashMap();
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private final ExecutorService pool = Executors.newCachedThreadPool();

    public SimulatedDevice(String name) {
        this.name = name;
    }

    public Optional<PlcValue> get(SimulatedTag tag) {
        LOGGER.debug("getting tag {}", (Object)tag);
        Objects.requireNonNull(tag);
        switch (tag.getType()) {
            case STATE: {
                return Optional.ofNullable(this.state.get(tag));
            }
            case RANDOM: {
                return Optional.ofNullable(this.randomValue(tag));
            }
            case STDOUT: {
                return Optional.empty();
            }
        }
        throw new IllegalArgumentException("Unsupported tag type: " + tag.getType().name());
    }

    public void set(SimulatedTag tag, PlcValue value) {
        LOGGER.debug("setting tag {} to {}", (Object)tag, (Object)value);
        Objects.requireNonNull(tag);
        switch (tag.getType()) {
            case STATE: {
                this.changeOfStateSubscriptions.values().stream().filter(pair -> ((SimulatedTag)pair.getKey()).equals(tag)).map(Pair::getValue).peek(plcValueConsumer -> LOGGER.debug("{} is getting notified with {}", plcValueConsumer, (Object)value)).forEach(baseDefaultPlcValueConsumer -> baseDefaultPlcValueConsumer.accept(value));
                this.state.put(tag, value);
                return;
            }
            case STDOUT: {
                LOGGER.info("TEST PLC STDOUT [{}]: {}", (Object)tag.getName(), (Object)value.toString());
                return;
            }
            case RANDOM: {
                switch (tag.getPlcValueType()) {
                    case STRING: 
                    case WSTRING: {
                        break;
                    }
                    default: {
                        try {
                            int lengthInBits = DataItem.getLengthInBits(value, tag.getPlcValueType().name(), tag.getArrayInfo().get(0).getSize());
                            WriteBufferByteBased writeBuffer = new WriteBufferByteBased((int)Math.ceil((float)lengthInBits / 8.0f));
                            DataItem.staticSerialize(writeBuffer, value, tag.getPlcValueType().name(), tag.getArrayInfo().get(0).getSize(), ByteOrder.BIG_ENDIAN);
                            break;
                        }
                        catch (SerializationException e) {
                            LOGGER.info("Write failed");
                        }
                    }
                }
                LOGGER.info("TEST PLC RANDOM [{}]: {}", (Object)tag.getName(), (Object)value);
                return;
            }
        }
        throw new IllegalArgumentException("Unsupported tag type: " + tag.getType().name());
    }

    private PlcValue randomValue(SimulatedTag tag) {
        short tagDataTypeSize = SimulatedDataTypeSizes.valueOf(tag.getPlcValueType().name()).getDataTypeSize();
        byte[] b = new byte[tagDataTypeSize * tag.getArrayInfo().get(0).getSize()];
        this.random.nextBytes(b);
        ReadBufferByteBased io = new ReadBufferByteBased(b);
        try {
            return DataItem.staticParse(io, tag.getPlcValueType().name(), tag.getArrayInfo().get(0).getSize());
        }
        catch (ParseException e) {
            return null;
        }
    }

    public String toString() {
        return this.name;
    }

    public void addCyclicSubscription(Consumer<PlcValue> consumer, PlcSubscriptionHandle handle, PlcSubscriptionTag subscriptionTag, Duration duration) {
        LOGGER.debug("Adding cyclic subscription: {}, {}, {}, {}", new Object[]{consumer, handle, subscriptionTag, duration});
        assert (subscriptionTag instanceof DefaultPlcSubscriptionTag);
        ScheduledFuture<?> scheduledFuture = this.scheduler.scheduleAtFixedRate(() -> {
            PlcTag innerPlcTag = ((DefaultPlcSubscriptionTag)subscriptionTag).getTag();
            assert (innerPlcTag instanceof SimulatedTag);
            PlcValue baseDefaultPlcValue = this.state.get(innerPlcTag);
            if (baseDefaultPlcValue == null) {
                return;
            }
            consumer.accept(baseDefaultPlcValue);
        }, duration.toMillis(), duration.toMillis(), TimeUnit.MILLISECONDS);
        this.cyclicSubscriptions.put(handle, scheduledFuture);
    }

    public void addChangeOfStateSubscription(Consumer<PlcValue> consumer, PlcSubscriptionHandle handle, PlcSubscriptionTag subscriptionTag) {
        LOGGER.debug("Adding change of state subscription: {}, {}, {}", new Object[]{consumer, handle, subscriptionTag});
        this.changeOfStateSubscriptions.put(handle, Pair.of((SimulatedTag)((DefaultPlcSubscriptionTag)subscriptionTag).getTag(), consumer));
    }

    public void addEventSubscription(Consumer<PlcValue> consumer, PlcSubscriptionHandle handle, PlcSubscriptionTag subscriptionTag) {
        LOGGER.debug("Adding event subscription: {}, {}, {}", new Object[]{consumer, handle, subscriptionTag});
        assert (subscriptionTag instanceof DefaultPlcSubscriptionTag);
        Future<?> submit = this.pool.submit(() -> {
            LOGGER.debug("WORKER: starting for {}, {}, {}", new Object[]{consumer, handle, subscriptionTag});
            while (!Thread.currentThread().isInterrupted()) {
                LOGGER.debug("WORKER: running for {}, {}, {}", new Object[]{consumer, handle, subscriptionTag});
                PlcTag innerPlcTag = ((DefaultPlcSubscriptionTag)subscriptionTag).getTag();
                assert (innerPlcTag instanceof SimulatedTag);
                PlcValue baseDefaultPlcValue = this.state.get(innerPlcTag);
                if (baseDefaultPlcValue == null) {
                    LOGGER.debug("WORKER: no value for {}, {}, {}", new Object[]{consumer, handle, subscriptionTag});
                    continue;
                }
                LOGGER.debug("WORKER: accepting {} for {}, {}, {}", new Object[]{baseDefaultPlcValue, consumer, handle, subscriptionTag});
                consumer.accept(baseDefaultPlcValue);
                try {
                    long sleepTime = Math.min((long)this.random.nextInt((int)TimeUnit.SECONDS.toNanos(5L)), TimeUnit.MILLISECONDS.toNanos(500L));
                    LOGGER.debug("WORKER: sleeping {} milliseconds for {}, {}, {}", new Object[]{TimeUnit.NANOSECONDS.toMillis(sleepTime), consumer, handle, subscriptionTag});
                    TimeUnit.NANOSECONDS.sleep(sleepTime);
                }
                catch (InterruptedException ignore) {
                    Thread.currentThread().interrupt();
                    LOGGER.debug("WORKER: got interrupted for {}, {}, {}", new Object[]{consumer, handle, subscriptionTag});
                    return;
                }
            }
        });
        this.eventSubscriptions.put(handle, submit);
    }

    public void removeHandles(Collection<? extends PlcSubscriptionHandle> internalPlcSubscriptionHandles) {
        LOGGER.debug("remove handles {}", internalPlcSubscriptionHandles);
        internalPlcSubscriptionHandles.forEach(handle -> {
            ScheduledFuture<?> remove = this.cyclicSubscriptions.remove(handle);
            if (remove == null) {
                LOGGER.debug("nothing to cancel {}", handle);
                return;
            }
            remove.cancel(true);
        });
        internalPlcSubscriptionHandles.forEach(handle -> {
            Future<?> remove = this.eventSubscriptions.remove(handle);
            if (remove == null) {
                LOGGER.debug("nothing to cancel {}", handle);
                return;
            }
            remove.cancel(true);
        });
        internalPlcSubscriptionHandles.forEach(this.changeOfStateSubscriptions::remove);
    }
}

