/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.codegen.io;

import org.apache.commons.lang3.StringUtils;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplex;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.utils.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataWriterComplexDefault<T extends Message>
implements DataWriterComplex<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataWriterComplexDefault.class);
    protected final WriteBuffer writeBuffer;

    public DataWriterComplexDefault(WriteBuffer writeBuffer) {
        this.writeBuffer = writeBuffer;
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.writeBuffer.getByteOrder();
    }

    @Override
    public void setByteOrder(ByteOrder byteOrder) {
        this.writeBuffer.setByteOrder(byteOrder);
    }

    @Override
    public void pushContext(String logicalName, WithWriterArgs ... writerArgs) {
        this.writeBuffer.pushContext(logicalName, writerArgs);
    }

    @Override
    public void popContext(String logicalName, WithWriterArgs ... writerArgs) {
        this.writeBuffer.popContext(logicalName, writerArgs);
    }

    @Override
    public void write(String logicalName, T value, WithWriterArgs ... writerArgs) throws SerializationException {
        boolean hasLogicalName = StringUtils.isNotBlank(logicalName);
        if (hasLogicalName) {
            this.writeBuffer.pushContext(logicalName, new WithWriterArgs[0]);
        }
        if (value == null) {
            LOGGER.warn("Trying to serialize null value for {}", (Object)logicalName);
        }
        this.writeBuffer.writeSerializable((Serializable)value);
        if (hasLogicalName) {
            this.writeBuffer.popContext(logicalName, new WithWriterArgs[0]);
        }
    }

    @Override
    public WriteBuffer getWriteBuffer() {
        return this.writeBuffer;
    }
}

