/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.codegen.io;

import java.util.function.Function;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterEnum;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderWriterArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataWriterEnumDefault<T, I>
implements DataWriterEnum<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataWriterEnumDefault.class);
    private final Function<T, I> enumSerializer;
    private final Function<T, String> enumNamer;
    private final DataWriter<I> dataWriter;

    public DataWriterEnumDefault(Function<T, I> enumSerializer, Function<T, String> enumNamer, DataWriter<I> dataWriter) {
        this.enumSerializer = enumSerializer;
        this.dataWriter = dataWriter;
        this.enumNamer = enumNamer;
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.dataWriter.getByteOrder();
    }

    @Override
    public void setByteOrder(ByteOrder byteOrder) {
        this.dataWriter.setByteOrder(byteOrder);
    }

    @Override
    public void write(String logicalName, T value, WithWriterArgs ... writerArgs) throws SerializationException {
        this.write(logicalName, value, this.enumSerializer, this.enumNamer, this.dataWriter, writerArgs);
    }

    public void write(String logicalName, T value, Function<T, I> enumSerializer, Function<T, String> enumNamer, DataWriter<I> rawWriter, WithWriterArgs ... writerArgs) throws SerializationException {
        if (value == null) {
            LOGGER.warn("Trying to serialize null value for {}", (Object)logicalName);
            return;
        }
        I rawValue = enumSerializer.apply(value);
        rawWriter.write(logicalName, rawValue, ArrayUtils.addAll(writerArgs, WithReaderWriterArgs.WithAdditionalStringRepresentation(enumNamer.apply(value))));
    }

    @Override
    public void pushContext(String logicalName, WithWriterArgs ... writerArgs) {
        this.dataWriter.pushContext(logicalName, writerArgs);
    }

    @Override
    public void popContext(String logicalName, WithWriterArgs ... writerArgs) {
        this.dataWriter.popContext(logicalName, writerArgs);
    }

    @Override
    public WriteBuffer getWriteBuffer() {
        return this.dataWriter.getWriteBuffer();
    }
}

