/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.messages;

import java.time.Duration;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.messages.PlcSubscriptionEvent;
import org.apache.plc4x.java.api.messages.PlcSubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcSubscriptionResponse;
import org.apache.plc4x.java.api.model.PlcSubscriptionTag;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.types.PlcSubscriptionType;
import org.apache.plc4x.java.spi.connection.PlcTagHandler;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.messages.PlcSubscriber;
import org.apache.plc4x.java.spi.model.DefaultPlcSubscriptionTag;
import org.apache.plc4x.java.spi.utils.Serializable;

public class DefaultPlcSubscriptionRequest
implements PlcSubscriptionRequest,
Serializable {
    private final PlcSubscriber subscriber;
    private final LinkedHashMap<String, PlcSubscriptionTag> tags;
    private final LinkedHashMap<String, List<Consumer<PlcSubscriptionEvent>>> preRegisteredConsumers;

    public DefaultPlcSubscriptionRequest(PlcSubscriber subscriber, LinkedHashMap<String, PlcSubscriptionTag> tags, LinkedHashMap<String, List<Consumer<PlcSubscriptionEvent>>> preRegisteredConsumers) {
        this.subscriber = subscriber;
        this.tags = tags;
        this.preRegisteredConsumers = preRegisteredConsumers;
    }

    public CompletableFuture<PlcSubscriptionResponse> execute() {
        return this.subscriber.subscribe(this);
    }

    @Override
    public int getNumberOfTags() {
        return this.tags.size();
    }

    @Override
    public LinkedHashSet<String> getTagNames() {
        return new LinkedHashSet<String>(this.tags.keySet());
    }

    @Override
    public PlcSubscriptionTag getTag(String name) {
        return this.tags.get(name);
    }

    @Override
    public List<PlcSubscriptionTag> getTags() {
        return new ArrayList<PlcSubscriptionTag>(this.tags.values());
    }

    @Override
    public Map<String, List<Consumer<PlcSubscriptionEvent>>> getPreRegisteredConsumers() {
        return new LinkedHashMap<String, List<Consumer<PlcSubscriptionEvent>>>(this.preRegisteredConsumers);
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.pushContext("PlcSubscriptionRequest", new WithWriterArgs[0]);
        writeBuffer.pushContext("tags", new WithWriterArgs[0]);
        for (Map.Entry<String, PlcSubscriptionTag> tagEntry : this.tags.entrySet()) {
            String tagName = tagEntry.getKey();
            writeBuffer.pushContext(tagName, new WithWriterArgs[0]);
            PlcTag tag = tagEntry.getValue();
            if (!(tag instanceof Serializable)) {
                throw new RuntimeException("Error serializing. Tag doesn't implement XmlSerializable");
            }
            ((Serializable)((Object)tag)).serialize(writeBuffer);
            writeBuffer.popContext(tagName, new WithWriterArgs[0]);
        }
        writeBuffer.popContext("tags", new WithWriterArgs[0]);
        writeBuffer.popContext("PlcSubscriptionRequest", new WithWriterArgs[0]);
    }

    public String toString() {
        return "DefaultPlcSubscriptionRequest{subscriber=" + this.subscriber + ", tags=" + this.tags + '}';
    }

    public static class Builder
    implements PlcSubscriptionRequest.Builder {
        private final PlcSubscriber subscriber;
        private final PlcTagHandler tagHandler;
        private final Map<String, BuilderItem> tags;
        private final LinkedHashMap<String, List<Consumer<PlcSubscriptionEvent>>> preRegisteredConsumers;

        public Builder(PlcSubscriber subscriber, PlcTagHandler tagHandler) {
            this.subscriber = subscriber;
            this.tagHandler = tagHandler;
            this.tags = new TreeMap<String, BuilderItem>();
            this.preRegisteredConsumers = new LinkedHashMap();
        }

        @Override
        public PlcSubscriptionRequest.Builder addCyclicTagAddress(String name, String tagAddress, Duration pollingInterval) {
            if (this.tags.containsKey(name)) {
                throw new PlcRuntimeException("Duplicate tag definition '" + name + "'");
            }
            this.tags.put(name, new BuilderItem(() -> this.tagHandler.parseTag(tagAddress), PlcSubscriptionType.CYCLIC, pollingInterval));
            return this;
        }

        @Override
        public PlcSubscriptionRequest.Builder addCyclicTag(String name, PlcTag tag, Duration pollingInterval) {
            if (this.tags.containsKey(name)) {
                throw new PlcRuntimeException("Duplicate tag definition '" + name + "'");
            }
            this.tags.put(name, new BuilderItem(() -> tag, PlcSubscriptionType.CYCLIC, pollingInterval));
            return this;
        }

        @Override
        public PlcSubscriptionRequest.Builder addChangeOfStateTagAddress(String name, String tagAddress) {
            if (this.tags.containsKey(name)) {
                throw new PlcRuntimeException("Duplicate tag definition '" + name + "'");
            }
            this.tags.put(name, new BuilderItem(() -> this.tagHandler.parseTag(tagAddress), PlcSubscriptionType.CHANGE_OF_STATE));
            return this;
        }

        @Override
        public PlcSubscriptionRequest.Builder addChangeOfStateTag(String name, PlcTag tag) {
            if (this.tags.containsKey(name)) {
                throw new PlcRuntimeException("Duplicate tag definition '" + name + "'");
            }
            this.tags.put(name, new BuilderItem(() -> tag, PlcSubscriptionType.CHANGE_OF_STATE));
            return this;
        }

        @Override
        public PlcSubscriptionRequest.Builder addEventTagAddress(String name, String tagAddress) {
            if (this.tags.containsKey(name)) {
                throw new PlcRuntimeException("Duplicate tag definition '" + name + "'");
            }
            this.tags.put(name, new BuilderItem(() -> this.tagHandler.parseTag(tagAddress), PlcSubscriptionType.EVENT));
            return this;
        }

        @Override
        public PlcSubscriptionRequest.Builder addEventTag(String name, PlcTag tag) {
            if (this.tags.containsKey(name)) {
                throw new PlcRuntimeException("Duplicate tag definition '" + name + "'");
            }
            this.tags.put(name, new BuilderItem(() -> tag, PlcSubscriptionType.EVENT));
            return this;
        }

        @Override
        public PlcSubscriptionRequest.Builder addPreRegisteredConsumer(String name, Consumer<PlcSubscriptionEvent> consumer) {
            this.preRegisteredConsumers.putIfAbsent(name, new LinkedList());
            this.preRegisteredConsumers.get(name).add(consumer);
            return this;
        }

        @Override
        public PlcSubscriptionRequest build() {
            LinkedHashMap<String, PlcSubscriptionTag> parsedTags = new LinkedHashMap<String, PlcSubscriptionTag>();
            this.tags.forEach((name, builderItem) -> {
                PlcTag parsedTag = builderItem.tag.get();
                parsedTags.put((String)name, new DefaultPlcSubscriptionTag(builderItem.plcSubscriptionType, parsedTag, builderItem.duration));
            });
            this.preRegisteredConsumers.forEach((tagName, ignored) -> {
                if (!this.tags.containsKey(tagName)) {
                    throw new RuntimeException("tagName " + tagName + "for preRegisteredConsumer not found");
                }
            });
            return new DefaultPlcSubscriptionRequest(this.subscriber, parsedTags, this.preRegisteredConsumers);
        }

        private static class BuilderItem {
            private final Supplier<PlcTag> tag;
            private final PlcSubscriptionType plcSubscriptionType;
            private final Duration duration;

            private BuilderItem(Supplier<PlcTag> tag, PlcSubscriptionType plcSubscriptionType) {
                this(tag, plcSubscriptionType, null);
            }

            private BuilderItem(Supplier<PlcTag> tag, PlcSubscriptionType plcSubscriptionType, Duration duration) {
                this.tag = tag;
                this.plcSubscriptionType = plcSubscriptionType;
                this.duration = duration;
            }
        }
    }
}

