/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.model;

import java.time.Duration;
import java.util.List;
import java.util.Optional;
import org.apache.plc4x.java.api.model.ArrayInfo;
import org.apache.plc4x.java.api.model.PlcSubscriptionTag;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.types.PlcSubscriptionType;
import org.apache.plc4x.java.api.types.PlcValueType;

public class DefaultPlcSubscriptionTag
implements PlcSubscriptionTag {
    private final PlcSubscriptionType plcSubscriptionType;
    private final PlcTag plcTag;
    private final Duration duration;

    public DefaultPlcSubscriptionTag(PlcSubscriptionType plcSubscriptionType, PlcTag plcTag, Duration duration) {
        this.plcSubscriptionType = plcSubscriptionType;
        this.plcTag = plcTag;
        this.duration = duration;
    }

    @Override
    public String getAddressString() {
        return this.plcTag.getAddressString();
    }

    @Override
    public PlcValueType getPlcValueType() {
        return this.plcTag.getPlcValueType();
    }

    @Override
    public List<ArrayInfo> getArrayInfo() {
        return this.plcTag.getArrayInfo();
    }

    @Override
    public PlcSubscriptionType getPlcSubscriptionType() {
        return this.plcSubscriptionType;
    }

    @Override
    public PlcTag getTag() {
        return this.plcTag;
    }

    @Override
    public Optional<Duration> getDuration() {
        return Optional.ofNullable(this.duration);
    }

    public String toString() {
        return "DefaultPlcSubscriptionTag{plcSubscriptionType=" + (Object)((Object)this.plcSubscriptionType) + ", plcTag=" + this.plcTag + ", duration=" + this.duration + '}';
    }
}

