/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.utils.hex;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hex {
    private static final Logger LOGGER = LoggerFactory.getLogger(Hex.class);
    public static final int DefaultWidth = 46;
    public static final int boxLineOverheat = 2;
    public static final int blankWidth = 1;
    public static final int byteWidth = 3;
    public static final int pipeWidth = 1;
    public static boolean DebugHex;

    public static String dump(byte[] data) {
        return Hex.dump(data, 46, new int[0]);
    }

    public static String dump(byte[] data, int desiredCharWidth, int ... highlights) {
        if (data == null || data.length < 1) {
            return "";
        }
        Set highlightsSet = Arrays.stream(highlights).boxed().collect(Collectors.toSet());
        data = Arrays.copyOf(data, data.length);
        StringBuilder hexString = new StringBuilder();
        Pair<Integer, Integer> rowIndexCalculation = Hex.calculateBytesPerRowAndIndexWidth(data.length, desiredCharWidth);
        int maxBytesPerRow = rowIndexCalculation.getLeft();
        int indexWidth = rowIndexCalculation.getRight();
        int byteIndex = 0;
        int rowIndex = 0;
        while (byteIndex < data.length) {
            String stringRepresentation;
            String indexString = String.format("%1$" + indexWidth + "s|", byteIndex).replace(' ', '0');
            hexString.append(indexString);
            int columnIndex = 0;
            while (columnIndex < maxBytesPerRow) {
                int absoluteIndex = byteIndex + columnIndex;
                if (absoluteIndex < data.length) {
                    if (highlightsSet.contains(absoluteIndex)) {
                        hexString.append("\u001b[0;31m");
                    }
                    hexString.append(String.format("%02x ", data[absoluteIndex]));
                    if (highlightsSet.contains(absoluteIndex)) {
                        hexString.append("\u001b[0m");
                    }
                } else {
                    hexString.append(StringUtils.repeat(" ", 3));
                }
                ++columnIndex;
            }
            int endIndex = byteIndex + maxBytesPerRow;
            if (endIndex >= data.length) {
                endIndex = data.length;
            }
            if ((stringRepresentation = Hex.maskString(ArrayUtils.subarray(data, byteIndex, endIndex))).length() < maxBytesPerRow) {
                stringRepresentation = String.valueOf(stringRepresentation) + StringUtils.repeat(" ", (maxBytesPerRow - stringRepresentation.length()) % maxBytesPerRow);
            }
            hexString.append(String.format("'%s'\n", stringRepresentation));
            byteIndex += maxBytesPerRow;
            ++rowIndex;
        }
        return hexString.substring(0, hexString.length() - 1);
    }

    static Pair<Integer, Integer> calculateBytesPerRowAndIndexWidth(int numberOfBytes, int desiredStringWidth) {
        if (DebugHex) {
            LOGGER.debug("Calculating max row and index for {} number of bytes and a desired string width of {}", (Object)numberOfBytes, (Object)desiredStringWidth);
        }
        int indexDigits = (int)(Math.log10(numberOfBytes) + 1.0);
        int requiredIndexWidth = indexDigits + 1;
        if (DebugHex) {
            LOGGER.debug("index width {} for indexDigits {} for bytes {}", new Object[]{requiredIndexWidth, indexDigits, numberOfBytes});
        }
        int quoteRune = 1;
        int potentialStringRenderRune = 1;
        int availableSpace = requiredIndexWidth + 3 + quoteRune + potentialStringRenderRune + quoteRune;
        if (DebugHex) {
            LOGGER.debug("calculated {} minimal width for number of bytes {}", (Object)availableSpace, (Object)numberOfBytes);
        }
        if (desiredStringWidth >= availableSpace) {
            availableSpace = desiredStringWidth;
        } else if (DebugHex) {
            LOGGER.debug("Overflow by {} runes", (Object)(desiredStringWidth - availableSpace));
        }
        if (DebugHex) {
            LOGGER.debug("Actual space {}", (Object)availableSpace);
        }
        double z = availableSpace;
        double y = requiredIndexWidth;
        double a = 3.0;
        double b = quoteRune;
        double x = (-2.0 * b - y + z) / (a + 1.0);
        if (DebugHex) {
            LOGGER.debug("Calculated number of bytes per row {} in int {}", (Object)x, (Object)((int)x));
        }
        return Pair.of((int)x, indexDigits);
    }

    static String maskString(byte[] data) {
        int i = 0;
        while (i < data.length) {
            if (data[i] < 32 || data[i] > 126) {
                data[i] = 46;
            }
            ++i;
        }
        return new String(data);
    }

    static byte[] toBytes(Object obj) {
        ByteArrayOutputStream boas = new ByteArrayOutputStream();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ObjectOutputStream ois = new ObjectOutputStream(boas);){
                ois.writeObject(obj);
                return boas.toByteArray();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

