/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcIECValue;

public class PlcBINT
extends PlcIECValue<BigInteger> {
    public static PlcBINT of(Object value) {
        if (value instanceof Boolean) {
            return new PlcBINT((Boolean)value);
        }
        if (value instanceof Byte) {
            return new PlcBINT((Byte)value);
        }
        if (value instanceof Short) {
            return new PlcBINT((Short)value);
        }
        if (value instanceof Integer) {
            return new PlcBINT((Integer)value);
        }
        if (value instanceof Long) {
            return new PlcBINT((Long)value);
        }
        if (value instanceof Float) {
            return new PlcBINT((Float)value);
        }
        if (value instanceof Double) {
            return new PlcBINT((Double)value);
        }
        if (value instanceof BigInteger) {
            return new PlcBINT((BigInteger)value);
        }
        if (value instanceof BigDecimal) {
            return new PlcBINT((BigDecimal)value);
        }
        return new PlcBINT((String)value);
    }

    public PlcBINT(Boolean value) {
        this.value = value != false ? BigInteger.valueOf(1L) : BigInteger.valueOf(0L);
        this.isNullable = false;
    }

    public PlcBINT(Byte value) {
        this.value = BigInteger.valueOf(value.byteValue());
        this.isNullable = false;
    }

    public PlcBINT(Short value) {
        this.value = BigInteger.valueOf(value.shortValue());
        this.isNullable = false;
    }

    public PlcBINT(Integer value) {
        this.value = BigInteger.valueOf(value.intValue());
        this.isNullable = false;
    }

    public PlcBINT(Long value) {
        this.value = BigInteger.valueOf(value);
        this.isNullable = false;
    }

    public PlcBINT(Float value) {
        this.value = BigDecimal.valueOf(value.floatValue()).toBigInteger();
        this.isNullable = false;
    }

    public PlcBINT(Double value) {
        this.value = BigDecimal.valueOf(value).toBigInteger();
        this.isNullable = false;
    }

    public PlcBINT(BigInteger value) {
        this.value = value;
        this.isNullable = false;
    }

    public PlcBINT(BigDecimal value) {
        this.value = value.toBigInteger();
        this.isNullable = false;
    }

    public PlcBINT(String value) {
        this.value = new BigInteger(value.trim());
        this.isNullable = false;
    }

    @Override
    public PlcValueType getPlcValueType() {
        return PlcValueType.ULINT;
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public boolean getBoolean() {
        return this.value != null && !((BigInteger)this.value).equals(BigInteger.ZERO);
    }

    @Override
    public boolean isByte() {
        return this.value != null && ((BigInteger)this.value).compareTo(BigInteger.valueOf(127L)) <= 0 && ((BigInteger)this.value).compareTo(BigInteger.valueOf(-128L)) >= 0;
    }

    @Override
    public byte getByte() {
        return ((BigInteger)this.value).byteValue();
    }

    @Override
    public boolean isShort() {
        return this.value != null && ((BigInteger)this.value).compareTo(BigInteger.valueOf(32767L)) <= 0 && ((BigInteger)this.value).compareTo(BigInteger.valueOf(-32768L)) >= 0;
    }

    @Override
    public short getShort() {
        return ((BigInteger)this.value).shortValue();
    }

    @Override
    public boolean isInteger() {
        return this.value != null && ((BigInteger)this.value).compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) <= 0 && ((BigInteger)this.value).compareTo(BigInteger.valueOf(Integer.MIN_VALUE)) >= 0;
    }

    @Override
    public int getInteger() {
        return ((BigInteger)this.value).intValue();
    }

    @Override
    public boolean isLong() {
        return this.value != null && ((BigInteger)this.value).compareTo(BigInteger.valueOf(Long.MAX_VALUE)) <= 0 && ((BigInteger)this.value).compareTo(BigInteger.valueOf(Long.MIN_VALUE)) >= 0;
    }

    @Override
    public long getLong() {
        return ((BigInteger)this.value).longValue();
    }

    @Override
    public boolean isBigInteger() {
        return true;
    }

    @Override
    public BigInteger getBigInteger() {
        return (BigInteger)this.value;
    }

    @Override
    public boolean isFloat() {
        return true;
    }

    @Override
    public float getFloat() {
        return ((BigInteger)this.value).floatValue();
    }

    @Override
    public boolean isDouble() {
        return true;
    }

    @Override
    public double getDouble() {
        return ((BigInteger)this.value).doubleValue();
    }

    @Override
    public boolean isBigDecimal() {
        return true;
    }

    @Override
    public BigDecimal getBigDecimal() {
        return new BigDecimal((BigInteger)this.value);
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public String getString() {
        return this.toString();
    }

    public String toString() {
        return ((BigInteger)this.value).toString();
    }

    public byte[] getBytes() {
        byte[] tmp = ((BigInteger)this.value).toByteArray();
        byte[] bytes = new byte[8];
        int i = 0;
        while (i < bytes.length) {
            bytes[i] = i >= bytes.length - tmp.length ? tmp[i - (bytes.length - tmp.length)] : (byte)0;
            ++i;
        }
        return bytes;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.writeBigInteger(this.getClass().getSimpleName(), 64, (BigInteger)this.value, new WithWriterArgs[0]);
    }
}

