/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import org.apache.commons.codec.binary.Hex;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcIECValue;

public class PlcRawByteArray
extends PlcIECValue<byte[]> {
    public static PlcRawByteArray of(Object value) {
        if (value instanceof byte[]) {
            return new PlcRawByteArray((byte[])value);
        }
        throw new IllegalArgumentException("Only byte[] supported here");
    }

    public PlcRawByteArray(byte[] value) {
        this.value = value;
        this.isNullable = false;
    }

    @Override
    public PlcValueType getPlcValueType() {
        return PlcValueType.RAW_BYTE_ARRAY;
    }

    public String toString() {
        return Hex.encodeHexString((byte[])this.value);
    }

    public byte[] getBytes() {
        return (byte[])this.value;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.writeByteArray(this.getClass().getSimpleName(), (byte[])this.value, new WithWriterArgs[0]);
    }
}

