/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.utils.Serializable;
import org.apache.plc4x.java.spi.values.PlcValueAdapter;

public class PlcStruct
extends PlcValueAdapter {
    private final Map<String, PlcValue> map;

    @Override
    public Object getObject() {
        return this.map;
    }

    public PlcStruct(Map<String, PlcValue> map) {
        this.map = Collections.unmodifiableMap(map);
    }

    @Override
    public PlcValueType getPlcValueType() {
        return PlcValueType.Struct;
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public boolean isStruct() {
        return true;
    }

    @Override
    public Set<String> getKeys() {
        return this.map.keySet();
    }

    @Override
    public boolean hasKey(String key) {
        return this.map.containsKey(key);
    }

    @Override
    public PlcValue getValue(String key) {
        return this.map.get(key);
    }

    @Override
    public Map<String, ? extends PlcValue> getStruct() {
        return this.map;
    }

    public String toString() {
        return "{" + this.map.entrySet().stream().map(entry -> String.format("\"%s\": %s", entry.getKey(), entry.getValue())).collect(Collectors.joining(",")) + "}";
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.pushContext("PlcStruct", new WithWriterArgs[0]);
        for (Map.Entry<String, PlcValue> entry : this.map.entrySet()) {
            String tagName = entry.getKey();
            writeBuffer.pushContext(tagName, new WithWriterArgs[0]);
            PlcValue tagValue = entry.getValue();
            if (!(tagValue instanceof Serializable)) {
                throw new PlcRuntimeException("Error serializing. List item doesn't implement XmlSerializable");
            }
            ((Serializable)((Object)tagValue)).serialize(writeBuffer);
            writeBuffer.popContext(tagName, new WithWriterArgs[0]);
        }
        writeBuffer.popContext("PlcStruct", new WithWriterArgs[0]);
    }
}

