/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.transport.rawsocketpassive;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ThreadPerChannelEventLoop;
import io.netty.channel.oio.OioEventLoopGroup;
import java.net.SocketAddress;
import org.apache.plc4x.java.spi.configuration.HasConfiguration;
import org.apache.plc4x.java.spi.connection.NettyChannelFactory;
import org.apache.plc4x.java.transport.rawsocketpassive.RawSocketPassiveTransportConfiguration;
import org.apache.plc4x.java.utils.pcap.netty.config.PcapChannelOption;
import org.apache.plc4x.java.utils.rawsockets.netty.RawSocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawSocketPassiveChannelFactory
extends NettyChannelFactory
implements HasConfiguration<RawSocketPassiveTransportConfiguration> {
    private static final Logger logger = LoggerFactory.getLogger(RawSocketPassiveChannelFactory.class);
    private RawSocketPassiveTransportConfiguration configuration;

    public RawSocketPassiveChannelFactory(SocketAddress address) {
        super(address);
    }

    @Override
    public void setConfiguration(RawSocketPassiveTransportConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public Class<? extends Channel> getChannel() {
        return RawSocketChannel.class;
    }

    @Override
    public boolean isPassive() {
        return true;
    }

    @Override
    public EventLoopGroup getEventLoopGroup() {
        return new ThreadPerChannelEventLoop(new OioEventLoopGroup());
    }

    @Override
    public void configureBootstrap(Bootstrap bootstrap) {
        if (this.configuration != null) {
            logger.info("Configuring Bootstrap with {}", (Object)this.configuration);
            if (this.configuration.getPcapPacketHandler() != null) {
                bootstrap.option(PcapChannelOption.PACKET_HANDLER, this.configuration.getPcapPacketHandler());
            }
        }
    }
}

