/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.transport.serial;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.net.SocketAddress;
import java.nio.channels.spi.SelectorProvider;
import org.apache.plc4x.java.spi.configuration.HasConfiguration;
import org.apache.plc4x.java.spi.connection.NettyChannelFactory;
import org.apache.plc4x.java.transport.serial.SerialChannel;
import org.apache.plc4x.java.transport.serial.SerialChannelOptions;
import org.apache.plc4x.java.transport.serial.SerialSelectorProvider;
import org.apache.plc4x.java.transport.serial.SerialTransportConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialChannelFactory
extends NettyChannelFactory
implements HasConfiguration<SerialTransportConfiguration> {
    private static final Logger logger = LoggerFactory.getLogger(SerialChannelFactory.class);
    private SerialTransportConfiguration configuration;

    public SerialChannelFactory(SocketAddress address) {
        super(address);
    }

    @Override
    public void setConfiguration(SerialTransportConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public Class<? extends Channel> getChannel() {
        return SerialChannel.class;
    }

    @Override
    public boolean isPassive() {
        return false;
    }

    @Override
    public void configureBootstrap(Bootstrap bootstrap) {
        if (this.configuration != null) {
            logger.info("Configuring Bootstrap with {}", (Object)this.configuration);
            bootstrap.option(SerialChannelOptions.BAUD_RATE, this.configuration.getBaudRate());
            bootstrap.option(SerialChannelOptions.DATA_BITS, this.configuration.getNumDataBits());
            bootstrap.option(SerialChannelOptions.STOP_BITS, this.configuration.getNumStopBits());
            bootstrap.option(SerialChannelOptions.PARITY, this.configuration.getParity());
        }
    }

    @Override
    public EventLoopGroup getEventLoopGroup() {
        return new NioEventLoopGroup(0, null, (SelectorProvider)new SerialSelectorProvider());
    }
}

