/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.transport.tcp;

import java.net.InetSocketAddress;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.spi.configuration.HasConfiguration;
import org.apache.plc4x.java.spi.configuration.PlcTransportConfiguration;
import org.apache.plc4x.java.spi.connection.ChannelFactory;
import org.apache.plc4x.java.spi.transport.Transport;
import org.apache.plc4x.java.transport.tcp.DefaultTcpTransportConfiguration;
import org.apache.plc4x.java.transport.tcp.TcpChannelFactory;
import org.apache.plc4x.java.transport.tcp.TcpTransportConfiguration;

public class TcpTransport
implements Transport,
HasConfiguration<TcpTransportConfiguration> {
    private static final Pattern TRANSPORT_TCP_PATTERN = Pattern.compile("^((?<ip>[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3})|(?<hostname>[a-zA-Z0-9.\\-]+))(:(?<port>[0-9]{1,5}))?.*");
    private TcpTransportConfiguration configuration;

    @Override
    public String getTransportCode() {
        return "tcp";
    }

    @Override
    public String getTransportName() {
        return "IP/TCP Transport";
    }

    @Override
    public void setConfiguration(TcpTransportConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public ChannelFactory createChannelFactory(String transportConfig) {
        int port;
        Matcher matcher = TRANSPORT_TCP_PATTERN.matcher(transportConfig);
        if (!matcher.matches()) {
            throw new PlcRuntimeException("Invalid url for TCP transport: " + transportConfig);
        }
        String ip = matcher.group("ip");
        String hostname = matcher.group("hostname");
        String portString = matcher.group("port");
        if (portString != null) {
            port = Integer.parseInt(portString);
        } else if (this.configuration != null && this.configuration.getDefaultPort() != -1) {
            port = this.configuration.getDefaultPort();
        } else {
            throw new PlcRuntimeException("No port defined");
        }
        InetSocketAddress address = new InetSocketAddress(ip == null ? hostname : ip, port);
        TcpChannelFactory tcpChannelFactory = new TcpChannelFactory(address);
        if (this.configuration != null) {
            tcpChannelFactory.setConfiguration(this.configuration);
        }
        return tcpChannelFactory;
    }

    @Override
    public Class<? extends PlcTransportConfiguration> getTransportConfigType() {
        return DefaultTcpTransportConfiguration.class;
    }
}

