/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.utils.pcapreplay.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.AbstractChannel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.channel.oio.OioByteStreamChannel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.sql.Timestamp;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.plc4x.java.utils.pcap.netty.exception.PcapException;
import org.apache.plc4x.java.utils.pcapreplay.netty.address.PcapReplayAddress;
import org.apache.plc4x.java.utils.pcapreplay.netty.config.PcapReplayChannelConfig;
import org.pcap4j.core.BpfProgram;
import org.pcap4j.core.NotOpenException;
import org.pcap4j.core.PacketListener;
import org.pcap4j.core.PcapHandle;
import org.pcap4j.core.PcapNativeException;
import org.pcap4j.core.Pcaps;
import org.pcap4j.packet.Packet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcapReplayChannel
extends OioByteStreamChannel {
    private static final Logger logger = LoggerFactory.getLogger(PcapReplayChannel.class);
    private final PcapReplayChannelConfig config = new PcapReplayChannelConfig(this);
    private PcapReplayAddress remoteRawSocketAddress;
    private SocketAddress localAddress;
    private PcapHandle handle;
    private Thread loopThread;

    public PcapReplayChannel() {
        super(null);
    }

    @Override
    protected boolean isInputShutdown() {
        return false;
    }

    @Override
    protected ChannelFuture shutdownInput() {
        throw new NotImplementedException("");
    }

    @Override
    protected void doConnect(SocketAddress remoteAddress, SocketAddress localAddress) throws Exception {
        this.localAddress = localAddress;
        if (!(remoteAddress instanceof PcapReplayAddress)) {
            logger.error("Expecting remote address of type PcapSocketAddress");
            this.pipeline().fireExceptionCaught(new PcapException("Expecting remote address of type PcapSocketAddress"));
            return;
        }
        this.remoteRawSocketAddress = (PcapReplayAddress)remoteAddress;
        File pcapFile = this.remoteRawSocketAddress.getPcapFile();
        if (!pcapFile.exists()) {
            logger.error("Couldn't find PCAP capture file at: {}", (Object)pcapFile.getAbsolutePath());
            PcapException exception = new PcapException(String.format("Couldn't find PCAP capture file at: %s", pcapFile.getAbsolutePath()));
            this.pipeline().fireExceptionCaught(exception);
            return;
        }
        logger.debug("Opening PCAP capture file at: {}", (Object)pcapFile.getAbsolutePath());
        this.handle = Pcaps.openOffline(this.remoteRawSocketAddress.getPcapFile().getAbsolutePath(), PcapHandle.TimestampPrecision.NANO);
        String filter = this.config.getFilter();
        if (filter.length() > 0) {
            this.handle.setFilter(filter, BpfProgram.BpfCompileMode.OPTIMIZE);
        }
        final ByteBuf buffer = Unpooled.buffer();
        this.loopThread = new Thread(() -> {
            try {
                this.handle.loop(-1, new PacketListener(){
                    private Timestamp lastPacketTime = null;

                    @Override
                    public void gotPacket(Packet packet) {
                        byte[] data;
                        Timestamp curPacketTime = PcapReplayChannel.this.handle.getTimestamp();
                        if (PcapReplayChannel.this.config.getSpeedFactor() != 0.0f && this.lastPacketTime != null) {
                            int numMicrosecondsSleep = (int)((float)(curPacketTime.getNanos() - this.lastPacketTime.getNanos()) / PcapReplayChannel.this.config.getSpeedFactor());
                            PcapReplayChannel.this.nanoSecondSleep(numMicrosecondsSleep);
                        }
                        if ((data = PcapReplayChannel.this.config.getPacketHandler().getData(packet)) != null) {
                            buffer.writeBytes(data);
                        }
                        this.lastPacketTime = curPacketTime;
                    }
                });
            }
            catch (NotOpenException | PcapNativeException e) {
                logger.error("PCAP loop thread died!", (Throwable)e);
                this.pipeline().fireExceptionCaught(e);
            }
            catch (InterruptedException e) {
                logger.warn("PCAP loop thread was interrupted (hopefully intentionally)", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        });
        this.loopThread.start();
        this.activate(new PcapInputStream(buffer), new DiscardingOutputStream());
    }

    @Override
    protected SocketAddress localAddress0() {
        return this.localAddress;
    }

    @Override
    protected SocketAddress remoteAddress0() {
        return this.remoteRawSocketAddress;
    }

    @Override
    protected void doBind(SocketAddress localAddress) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    protected void doDisconnect() {
        this.loopThread.interrupt();
        if (this.handle != null) {
            this.handle.close();
        }
    }

    @Override
    protected int doReadBytes(ByteBuf buf) throws Exception {
        if (this.handle == null || !this.handle.isOpen()) {
            return -1;
        }
        try {
            return super.doReadBytes(buf);
        }
        catch (SocketTimeoutException ignored) {
            return 0;
        }
    }

    @Override
    public ChannelConfig config() {
        return this.config;
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    protected AbstractChannel.AbstractUnsafe newUnsafe() {
        return new RawSocketUnsafe();
    }

    private void nanoSecondSleep(long numNanos) {
        try {
            TimeUnit.NANOSECONDS.sleep(numNanos);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private static class DiscardingOutputStream
    extends OutputStream {
        private DiscardingOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            logger.debug("Discarding {}", (Object)b);
        }

        @Override
        public void write(byte[] b, int off, int len) {
            logger.debug("Discarding {}", (Object)b);
        }
    }

    private static class PcapInputStream
    extends InputStream {
        final ByteBuf buf;

        private PcapInputStream(ByteBuf buf) {
            this.buf = buf;
        }

        @Override
        public int available() {
            return this.buf.readableBytes();
        }

        @Override
        public int read() throws IOException {
            long timeout = System.nanoTime() + 10000L;
            while (System.nanoTime() < timeout) {
                if (this.buf.readableBytes() <= 0) continue;
                return this.buf.readByte() & 0xFF;
            }
            throw new SocketTimeoutException();
        }
    }

    private class RawSocketUnsafe
    extends AbstractChannel.AbstractUnsafe {
        private RawSocketUnsafe() {
        }

        @Override
        public void connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            try {
                PcapReplayChannel.this.doConnect(remoteAddress, localAddress);
                PcapReplayChannel.this.pipeline().fireChannelActive();
                promise.setSuccess();
            }
            catch (Exception e) {
                promise.setFailure(e);
            }
        }
    }
}

