/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.utils.pcapreplay.netty.config;

import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import java.util.Map;
import org.apache.plc4x.java.utils.pcap.netty.config.PcapChannelConfig;
import org.apache.plc4x.java.utils.pcapreplay.netty.config.PcapReplayChannelOption;

public class PcapReplayChannelConfig
extends PcapChannelConfig {
    public static final float SPEED_SLOW_HALF = 0.5f;
    public static final float SPEED_REALTIME = 1.0f;
    public static final float SPEED_FAST_DOUBLE = 2.0f;
    public static final float SPEED_FAST_FULL = 0.0f;
    private float speedFactor = 1.0f;
    private boolean loop = false;
    private String filter = "";

    public PcapReplayChannelConfig(Channel channel) {
        super(channel);
    }

    @Override
    public Map<ChannelOption<?>, Object> getOptions() {
        return this.getOptions(super.getOptions(), PcapReplayChannelOption.SPEED_FACTOR);
    }

    @Override
    public <T> boolean setOption(ChannelOption<T> option, T value) {
        if (option == PcapReplayChannelOption.SPEED_FACTOR) {
            if (value instanceof Float) {
                this.speedFactor = ((Float)value).floatValue();
                return this.speedFactor >= 0.0f;
            }
            return false;
        }
        if (option == PcapReplayChannelOption.LOOP) {
            if (value instanceof Boolean) {
                this.loop = (Boolean)value;
                return true;
            }
            return false;
        }
        if (option == PcapReplayChannelOption.FILTER) {
            if (value instanceof String) {
                this.filter = (String)value;
                return true;
            }
            return false;
        }
        return super.setOption(option, value);
    }

    public float getSpeedFactor() {
        return this.speedFactor;
    }

    public void setSpeedFactor(float speedFactor) {
        this.speedFactor = speedFactor;
    }

    public boolean isLoop() {
        return this.loop;
    }

    public void setLoop(boolean loop) {
        this.loop = loop;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }
}

