/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pubnub;

import com.pubnub.api.PubNubException;
import com.pubnub.api.callbacks.PNCallback;
import com.pubnub.api.models.consumer.PNErrorData;
import com.pubnub.api.models.consumer.PNPublishResult;
import com.pubnub.api.models.consumer.PNStatus;
import com.pubnub.api.models.consumer.history.PNHistoryResult;
import com.pubnub.api.models.consumer.presence.PNGetStateResult;
import com.pubnub.api.models.consumer.presence.PNHereNowResult;
import com.pubnub.api.models.consumer.presence.PNSetStateResult;
import com.pubnub.api.models.consumer.presence.PNWhereNowResult;
import java.util.Arrays;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelException;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.pubnub.PubNubConfiguration;
import org.apache.camel.component.pubnub.PubNubEndpoint;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PubNubProducer
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(PubNubProducer.class);
    private final PubNubEndpoint endpoint;
    private final PubNubConfiguration pubnubConfiguration;

    public PubNubProducer(PubNubEndpoint endpoint, PubNubConfiguration pubNubConfiguration) {
        super(endpoint);
        this.endpoint = endpoint;
        this.pubnubConfiguration = pubNubConfiguration;
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        Operation operation = this.getOperation(exchange);
        LOG.debug("Executing {} operation", (Object)operation);
        try {
            switch (operation) {
                case PUBLISH: {
                    this.doPublish(exchange, callback);
                    break;
                }
                case FIRE: {
                    this.doFire(exchange, callback);
                    break;
                }
                case GETHISTORY: {
                    this.doGetHistory(exchange, callback);
                    break;
                }
                case GETSTATE: {
                    this.doGetState(exchange, callback);
                    break;
                }
                case HERENOW: {
                    this.doHereNow(exchange, callback);
                    break;
                }
                case SETSTATE: {
                    this.doSetState(exchange, callback);
                    break;
                }
                case WHERENOW: {
                    this.doWhereNow(exchange, callback);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(operation.toString());
                }
            }
        }
        catch (Exception e) {
            exchange.setException(e);
            callback.done(true);
            return true;
        }
        return false;
    }

    private void doPublish(final Exchange exchange, final AsyncCallback callback) {
        Object body = exchange.getIn().getBody();
        if (ObjectHelper.isEmpty(body)) {
            throw new RuntimeCamelException("Can not publish empty message");
        }
        LOG.debug("Sending message [{}] to channel [{}]", body, (Object)this.getChannel(exchange));
        this.endpoint.getPubnub().publish().message(body).channel(this.getChannel(exchange)).usePOST(true).async(new PNCallback<PNPublishResult>(){

            @Override
            public void onResponse(PNPublishResult result, PNStatus status) {
                if (!status.isError()) {
                    exchange.getIn().setHeader("CamelPubNubTimeToken", result.getTimetoken());
                }
                PubNubProducer.this.processMessage(exchange, callback, status, null);
            }
        });
    }

    private void doFire(final Exchange exchange, final AsyncCallback callback) {
        Object body = exchange.getIn().getBody();
        if (ObjectHelper.isEmpty(body)) {
            exchange.setException(new CamelException("Can not fire empty message"));
            callback.done(true);
        }
        LOG.debug("Sending message [{}] to channel [{}]", body, (Object)this.getChannel(exchange));
        this.endpoint.getPubnub().fire().message(body).channel(this.getChannel(exchange)).async(new PNCallback<PNPublishResult>(){

            @Override
            public void onResponse(PNPublishResult result, PNStatus status) {
                if (!status.isError()) {
                    exchange.getIn().setHeader("CamelPubNubTimeToken", result.getTimetoken());
                }
                PubNubProducer.this.processMessage(exchange, callback, status, null);
            }
        });
    }

    private void doGetHistory(final Exchange exchange, final AsyncCallback callback) {
        this.endpoint.getPubnub().history().channel(this.getChannel(exchange)).async(new PNCallback<PNHistoryResult>(){

            @Override
            public void onResponse(PNHistoryResult result, PNStatus status) {
                LOG.debug("Got history message [{}]", (Object)result);
                PubNubProducer.this.processMessage(exchange, callback, status, result.getMessages());
            }
        });
    }

    private void doSetState(final Exchange exchange, final AsyncCallback callback) {
        Object body = exchange.getIn().getBody();
        if (ObjectHelper.isEmpty(body)) {
            exchange.setException(new CamelException("Can not publish empty message"));
            callback.done(true);
        }
        LOG.debug("Sending setState [{}] to channel [{}]", body, (Object)this.getChannel(exchange));
        this.endpoint.getPubnub().setPresenceState().channels(Arrays.asList(this.getChannel(exchange))).state(body).uuid(this.getUUID(exchange)).async(new PNCallback<PNSetStateResult>(){

            @Override
            public void onResponse(PNSetStateResult result, PNStatus status) {
                LOG.debug("Got setState responsee [{}]", (Object)result);
                PubNubProducer.this.processMessage(exchange, callback, status, result);
            }
        });
    }

    private void doGetState(final Exchange exchange, final AsyncCallback callback) {
        this.endpoint.getPubnub().getPresenceState().channels(Arrays.asList(this.getChannel(exchange))).uuid(this.getUUID(exchange)).async(new PNCallback<PNGetStateResult>(){

            @Override
            public void onResponse(PNGetStateResult result, PNStatus status) {
                LOG.debug("Got state [{}]", result.getStateByUUID());
                PubNubProducer.this.processMessage(exchange, callback, status, result);
            }
        });
    }

    private void doHereNow(final Exchange exchange, final AsyncCallback callback) {
        this.endpoint.getPubnub().hereNow().channels(Arrays.asList(this.getChannel(exchange))).includeState(true).includeUUIDs(true).async(new PNCallback<PNHereNowResult>(){

            @Override
            public void onResponse(PNHereNowResult result, PNStatus status) {
                LOG.debug("Got herNow message [{}]", (Object)result);
                PubNubProducer.this.processMessage(exchange, callback, status, result);
            }
        });
    }

    private void doWhereNow(final Exchange exchange, final AsyncCallback callback) {
        this.endpoint.getPubnub().whereNow().uuid(this.getUUID(exchange)).async(new PNCallback<PNWhereNowResult>(){

            @Override
            public void onResponse(PNWhereNowResult result, PNStatus status) {
                LOG.debug("Got whereNow message [{}]", result.getChannels());
                PubNubProducer.this.processMessage(exchange, callback, status, result.getChannels());
            }
        });
    }

    private void processMessage(Exchange exchange, AsyncCallback callback, PNStatus status, Object body) {
        if (status.isError()) {
            PNErrorData errorData = status.getErrorData();
            exchange.setException(errorData.getThrowable());
            if (errorData != null && errorData.getThrowable() instanceof PubNubException) {
                PubNubException pubNubException = (PubNubException)errorData.getThrowable();
                throw new RuntimeCamelException(pubNubException.getPubnubError().getMessage(), errorData.getThrowable());
            }
            throw new RuntimeCamelException(status.getErrorData().getThrowable());
        }
        ExchangeHelper.setInOutBodyPatternAware(exchange, body);
        callback.done(false);
    }

    private Operation getOperation(Exchange exchange) {
        String operation = exchange.getIn().getHeader("CamelPubNubOperation", String.class);
        if (operation == null) {
            operation = this.pubnubConfiguration.getOperation();
        }
        return operation != null ? Operation.valueOf(operation.toUpperCase()) : Operation.PUBLISH;
    }

    private String getChannel(Exchange exchange) {
        String channel = exchange.getIn().getHeader("CamelPubNubChannel", String.class);
        return channel != null ? channel : this.pubnubConfiguration.getChannel();
    }

    private String getUUID(Exchange exchange) {
        String uuid = exchange.getIn().getHeader("CamelPubNubUUID", String.class);
        return uuid != null ? uuid : this.pubnubConfiguration.getUuid();
    }

    private static enum Operation {
        HERENOW,
        WHERENOW,
        GETSTATE,
        SETSTATE,
        GETHISTORY,
        PUBLISH,
        FIRE;

    }
}

