/*
 * Decompiled with CFR 0.152.
 */
package co.nstant.in.cbor.encoder;

import co.nstant.in.cbor.CborEncoder;
import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.encoder.AbstractEncoder;
import co.nstant.in.cbor.model.MajorType;
import co.nstant.in.cbor.model.SimpleValue;
import co.nstant.in.cbor.model.UnicodeString;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class UnicodeStringEncoder
extends AbstractEncoder<UnicodeString> {
    public UnicodeStringEncoder(CborEncoder encoder, OutputStream outputStream2) {
        super(encoder, outputStream2);
    }

    @Override
    public void encode(UnicodeString dataItem) throws CborException {
        String string = dataItem.getString();
        if (dataItem.isChunked()) {
            this.encodeTypeChunked(MajorType.UNICODE_STRING);
            if (string != null) {
                this.encode(new UnicodeString(string));
            }
        } else if (string == null) {
            this.encoder.encode(SimpleValue.NULL);
        } else {
            byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
            this.encodeTypeAndLength(MajorType.UNICODE_STRING, bytes.length);
            this.write(bytes);
        }
    }
}

