/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.channel_groups;

import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.models.consumer.channel_group.PNChannelGroupsAddChannelResult;
import com.pubnub.api.retry.RetryableEndpointGroup;
import com.pubnub.internal.EndpointCore;
import com.pubnub.internal.PubNubCore;
import com.pubnub.internal.PubNubUtilKt;
import com.pubnub.internal.endpoints.channel_groups.AddChannelChannelGroupInterface;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004B%\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n\u00a2\u0006\u0002\u0010\u000bJ\u001c\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0013H\u0002J\u0016\u0010\u0014\u001a\u00020\u00032\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016H\u0014J2\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u00182\"\u0010\u0012\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0019j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b`\u001aH\u0014J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0014J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0014J\b\u0010\u001d\u001a\u00020\u001eH\u0014J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u0011H\u0014R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\""}, d2={"Lcom/pubnub/internal/endpoints/channel_groups/AddChannelChannelGroupEndpoint;", "Lcom/pubnub/internal/EndpointCore;", "Ljava/lang/Void;", "Lcom/pubnub/api/models/consumer/channel_group/PNChannelGroupsAddChannelResult;", "Lcom/pubnub/internal/endpoints/channel_groups/AddChannelChannelGroupInterface;", "pubnub", "Lcom/pubnub/internal/PubNubCore;", "channelGroup", "", "channels", "", "(Lcom/pubnub/internal/PubNubCore;Ljava/lang/String;Ljava/util/List;)V", "getChannelGroup", "()Ljava/lang/String;", "getChannels", "()Ljava/util/List;", "addQueryParams", "", "queryParams", "", "createResponse", "input", "Lretrofit2/Response;", "doWork", "Lretrofit2/Call;", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getAffectedChannelGroups", "getAffectedChannels", "getEndpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "operationType", "Lcom/pubnub/api/enums/PNOperationType$PNAddChannelsToGroupOperation;", "validateParams", "pubnub-core-impl"})
public final class AddChannelChannelGroupEndpoint
extends EndpointCore<Void, PNChannelGroupsAddChannelResult>
implements AddChannelChannelGroupInterface {
    @NotNull
    private final String channelGroup;
    @NotNull
    private final List<String> channels;

    public AddChannelChannelGroupEndpoint(@NotNull PubNubCore pubnub, @NotNull String channelGroup, @NotNull List<String> channels) {
        Intrinsics.checkNotNullParameter(pubnub, "pubnub");
        Intrinsics.checkNotNullParameter(channelGroup, "channelGroup");
        Intrinsics.checkNotNullParameter(channels, "channels");
        super(pubnub);
        this.channelGroup = channelGroup;
        this.channels = channels;
    }

    @Override
    @NotNull
    public String getChannelGroup() {
        return this.channelGroup;
    }

    @Override
    @NotNull
    public List<String> getChannels() {
        return this.channels;
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return this.getChannels();
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannelGroups() {
        return CollectionsKt.listOf(this.getChannelGroup());
    }

    @Override
    protected void validateParams() {
        super.validateParams();
        if (StringsKt.isBlank(this.getChannelGroup())) {
            throw new PubNubException(PubNubError.GROUP_MISSING);
        }
        if (this.getChannels().isEmpty()) {
            throw new PubNubException(PubNubError.CHANNEL_MISSING);
        }
    }

    @Override
    @NotNull
    protected Call<Void> doWork(@NotNull HashMap<String, String> queryParams) {
        Intrinsics.checkNotNullParameter(queryParams, "queryParams");
        this.addQueryParams((Map<String, String>)queryParams);
        return this.getRetrofitManager().getChannelGroupService$pubnub_core_impl().addChannelChannelGroup(this.getConfiguration().getSubscribeKey(), this.getChannelGroup(), (Map<String, String>)queryParams);
    }

    @Override
    @NotNull
    protected PNChannelGroupsAddChannelResult createResponse(@NotNull Response<Void> input) {
        Intrinsics.checkNotNullParameter(input, "input");
        return new PNChannelGroupsAddChannelResult();
    }

    @Override
    @NotNull
    public PNOperationType.PNAddChannelsToGroupOperation operationType() {
        return PNOperationType.PNAddChannelsToGroupOperation;
    }

    @Override
    @NotNull
    protected RetryableEndpointGroup getEndpointGroupName() {
        return RetryableEndpointGroup.CHANNEL_GROUP;
    }

    private final void addQueryParams(Map<String, String> queryParams) {
        if (!((Collection)this.getChannels()).isEmpty()) {
            queryParams.put("add", PubNubUtilKt.toCsv(this.getChannels()));
        }
    }
}

