/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.message_actions;

import com.google.gson.JsonObject;
import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.models.consumer.message_actions.PNAddMessageActionResult;
import com.pubnub.api.models.consumer.message_actions.PNMessageAction;
import com.pubnub.api.retry.RetryableEndpointGroup;
import com.pubnub.internal.EndpointCore;
import com.pubnub.internal.PubNubCore;
import com.pubnub.internal.endpoints.message_actions.AddMessageActionInterface;
import com.pubnub.internal.models.server.objects_api.EntityEnvelope;
import com.pubnub.internal.services.MessageActionService;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u00012\u00020\u0005B\u001f\b\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000bJ\u001c\u0010\u0010\u001a\u00020\u00042\u0012\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0012H\u0014J8\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u00142\"\u0010\u0015\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0016j\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t`\u0017H\u0014J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\u0019H\u0014J\b\u0010\u001a\u001a\u00020\u001bH\u0014J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0014R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\n\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006 "}, d2={"Lcom/pubnub/internal/endpoints/message_actions/AddMessageActionEndpoint;", "Lcom/pubnub/internal/EndpointCore;", "Lcom/pubnub/internal/models/server/objects_api/EntityEnvelope;", "Lcom/pubnub/api/models/consumer/message_actions/PNMessageAction;", "Lcom/pubnub/api/models/consumer/message_actions/PNAddMessageActionResult;", "Lcom/pubnub/internal/endpoints/message_actions/AddMessageActionInterface;", "pubnub", "Lcom/pubnub/internal/PubNubCore;", "channel", "", "messageAction", "(Lcom/pubnub/internal/PubNubCore;Ljava/lang/String;Lcom/pubnub/api/models/consumer/message_actions/PNMessageAction;)V", "getChannel", "()Ljava/lang/String;", "getMessageAction", "()Lcom/pubnub/api/models/consumer/message_actions/PNMessageAction;", "createResponse", "input", "Lretrofit2/Response;", "doWork", "Lretrofit2/Call;", "queryParams", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getAffectedChannels", "", "getEndpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "operationType", "Lcom/pubnub/api/enums/PNOperationType$PNAddMessageAction;", "validateParams", "", "pubnub-core-impl"})
public final class AddMessageActionEndpoint
extends EndpointCore<EntityEnvelope<PNMessageAction>, PNAddMessageActionResult>
implements AddMessageActionInterface {
    @NotNull
    private final String channel;
    @NotNull
    private final PNMessageAction messageAction;

    public AddMessageActionEndpoint(@NotNull PubNubCore pubnub, @NotNull String channel, @NotNull PNMessageAction messageAction) {
        Intrinsics.checkNotNullParameter(pubnub, "pubnub");
        Intrinsics.checkNotNullParameter(channel, "channel");
        Intrinsics.checkNotNullParameter(messageAction, "messageAction");
        super(pubnub);
        this.channel = channel;
        this.messageAction = messageAction;
    }

    @Override
    @NotNull
    public String getChannel() {
        return this.channel;
    }

    @Override
    @NotNull
    public PNMessageAction getMessageAction() {
        return this.messageAction;
    }

    @Override
    protected void validateParams() {
        super.validateParams();
        if (StringsKt.isBlank(this.getChannel())) {
            throw new PubNubException(PubNubError.CHANNEL_MISSING);
        }
        if (StringsKt.isBlank(this.getMessageAction().type)) {
            throw new PubNubException(PubNubError.MESSAGE_ACTION_TYPE_MISSING);
        }
        if (StringsKt.isBlank(this.getMessageAction().value)) {
            throw new PubNubException(PubNubError.MESSAGE_ACTION_VALUE_MISSING);
        }
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return CollectionsKt.listOf(this.getChannel());
    }

    @Override
    @NotNull
    protected Call<EntityEnvelope<PNMessageAction>> doWork(@NotNull HashMap<String, String> queryParams) {
        Intrinsics.checkNotNullParameter(queryParams, "queryParams");
        Object object = new JsonObject();
        JsonObject $this$doWork_u24lambda_u240 = object;
        boolean bl = false;
        $this$doWork_u24lambda_u240.addProperty("type", this.getMessageAction().type);
        $this$doWork_u24lambda_u240.addProperty("value", this.getMessageAction().value);
        JsonObject body = object;
        MessageActionService messageActionService = this.getRetrofitManager().getMessageActionService$pubnub_core_impl();
        String string = this.getConfiguration().getSubscribeKey();
        String string2 = this.getChannel();
        object = String.valueOf(this.getMessageAction().messageTimetoken);
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue(locale, "getDefault()");
        String string3 = ((String)object).toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).toLowerCase(locale)");
        return messageActionService.addMessageAction(string, string2, string3, body, (Map<String, String>)queryParams);
    }

    @Override
    @NotNull
    protected PNAddMessageActionResult createResponse(@NotNull Response<EntityEnvelope<PNMessageAction>> input) {
        Intrinsics.checkNotNullParameter(input, "input");
        EntityEnvelope<PNMessageAction> entityEnvelope = input.body();
        Intrinsics.checkNotNull(entityEnvelope);
        PNMessageAction pNMessageAction = entityEnvelope.getData();
        Intrinsics.checkNotNull(pNMessageAction);
        return new PNAddMessageActionResult(pNMessageAction);
    }

    @Override
    @NotNull
    public PNOperationType.PNAddMessageAction operationType() {
        return PNOperationType.PNAddMessageAction;
    }

    @Override
    @NotNull
    protected RetryableEndpointGroup getEndpointGroupName() {
        return RetryableEndpointGroup.MESSAGE_REACTION;
    }
}

