/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.pubsub;

import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.models.consumer.PNPublishResult;
import com.pubnub.api.retry.RetryableEndpointGroup;
import com.pubnub.internal.EndpointCore;
import com.pubnub.internal.PubNubCore;
import com.pubnub.internal.endpoints.pubsub.SignalInterface;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u00012\u00020\u0005B\u001f\b\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000bJ\u001c\u0010\u0010\u001a\u00020\u00042\u0012\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0012H\u0014J8\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u00142\"\u0010\u0015\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0016j\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t`\u0017H\u0014J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\u0002H\u0014J\b\u0010\u0019\u001a\u00020\u001aH\u0014J\b\u0010\u001b\u001a\u00020\u001cH\u0014J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0014R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\n\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006!"}, d2={"Lcom/pubnub/internal/endpoints/pubsub/SignalEndpoint;", "Lcom/pubnub/internal/EndpointCore;", "", "", "Lcom/pubnub/api/models/consumer/PNPublishResult;", "Lcom/pubnub/internal/endpoints/pubsub/SignalInterface;", "pubnub", "Lcom/pubnub/internal/PubNubCore;", "channel", "", "message", "(Lcom/pubnub/internal/PubNubCore;Ljava/lang/String;Ljava/lang/Object;)V", "getChannel", "()Ljava/lang/String;", "getMessage", "()Ljava/lang/Object;", "createResponse", "input", "Lretrofit2/Response;", "doWork", "Lretrofit2/Call;", "queryParams", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getAffectedChannels", "getEndpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "isPubKeyRequired", "", "operationType", "Lcom/pubnub/api/enums/PNOperationType$PNSignalOperation;", "validateParams", "", "pubnub-core-impl"})
public final class SignalEndpoint
extends EndpointCore<List<? extends Object>, PNPublishResult>
implements SignalInterface {
    @NotNull
    private final String channel;
    @NotNull
    private final Object message;

    public SignalEndpoint(@NotNull PubNubCore pubnub, @NotNull String channel, @NotNull Object message) {
        Intrinsics.checkNotNullParameter(pubnub, "pubnub");
        Intrinsics.checkNotNullParameter(channel, "channel");
        Intrinsics.checkNotNullParameter(message, "message");
        super(pubnub);
        this.channel = channel;
        this.message = message;
    }

    @Override
    @NotNull
    public String getChannel() {
        return this.channel;
    }

    @Override
    @NotNull
    public Object getMessage() {
        return this.message;
    }

    @Override
    protected void validateParams() {
        super.validateParams();
        if (StringsKt.isBlank(this.getChannel())) {
            throw new PubNubException(PubNubError.CHANNEL_MISSING);
        }
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return CollectionsKt.listOf(this.getChannel());
    }

    @Override
    @NotNull
    protected Call<List<Object>> doWork(@NotNull HashMap<String, String> queryParams) {
        Intrinsics.checkNotNullParameter(queryParams, "queryParams");
        return this.getRetrofitManager().getSignalService$pubnub_core_impl().signal(this.getConfiguration().getPublishKey(), this.getConfiguration().getSubscribeKey(), this.getChannel(), this.getPubnub().getMapper().toJson(this.getMessage()), (Map<String, String>)queryParams);
    }

    @Override
    @NotNull
    protected PNPublishResult createResponse(@NotNull Response<List<Object>> input) {
        Intrinsics.checkNotNullParameter(input, "input");
        List<Object> list = input.body();
        Intrinsics.checkNotNull(list);
        return new PNPublishResult(Long.parseLong(list.get(2).toString()));
    }

    @Override
    @NotNull
    public PNOperationType.PNSignalOperation operationType() {
        return PNOperationType.PNSignalOperation;
    }

    @Override
    protected boolean isPubKeyRequired() {
        return true;
    }

    @Override
    @NotNull
    protected RetryableEndpointGroup getEndpointGroupName() {
        return RetryableEndpointGroup.PUBLISH;
    }
}

