/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.managers;

import com.pubnub.api.enums.PNLogVerbosity;
import com.pubnub.api.v2.BasePNConfiguration;
import com.pubnub.internal.PubNubCore;
import com.pubnub.internal.interceptor.SignatureInterceptor;
import com.pubnub.internal.managers.RetrofitManager;
import com.pubnub.internal.services.AccessManagerService;
import com.pubnub.internal.services.ChannelGroupService;
import com.pubnub.internal.services.FilesService;
import com.pubnub.internal.services.HistoryService;
import com.pubnub.internal.services.MessageActionService;
import com.pubnub.internal.services.ObjectsService;
import com.pubnub.internal.services.PresenceService;
import com.pubnub.internal.services.PublishService;
import com.pubnub.internal.services.PushService;
import com.pubnub.internal.services.S3Service;
import com.pubnub.internal.services.SignalService;
import com.pubnub.internal.services.SubscribeService;
import com.pubnub.internal.services.TimeService;
import com.pubnub.internal.vendor.AppEngineFactory;
import java.net.Proxy;
import java.net.ProxySelector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Authenticator;
import okhttp3.Call;
import okhttp3.CertificatePinner;
import okhttp3.ConnectionSpec;
import okhttp3.Dispatcher;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Retrofit;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B9\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\fJ\u001a\u0010M\u001a\u00020N2\b\u0010O\u001a\u0004\u0018\u00010\t2\u0006\u0010P\u001a\u00020QH\u0002J&\u0010R\u001a\u00020\t2\u0006\u0010S\u001a\u00020T2\b\b\u0002\u0010U\u001a\u00020Q2\n\b\u0002\u0010V\u001a\u0004\u0018\u00010\tH\u0002J\u0012\u0010W\u001a\u00020X2\b\u0010Y\u001a\u0004\u0018\u00010ZH\u0002J\u0010\u0010[\u001a\u00020N2\b\b\u0002\u0010P\u001a\u00020QJ\b\u0010\\\u001a\u0004\u0018\u00010]R\u0014\u0010\r\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u0016X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001aX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020&X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0014\u0010)\u001a\u00020*X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0014\u0010-\u001a\u00020.X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0014\u00103\u001a\u000204X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u0014\u00107\u001a\u000208X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u0014\u0010;\u001a\u00020<X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010>R\u000e\u0010?\u001a\u00020@X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010A\u001a\u00020BX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010DR\u001c\u0010\n\u001a\u0004\u0018\u00010\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010\"\"\u0004\bF\u0010$R\u0014\u0010G\u001a\u00020HX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010JR\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010\"\"\u0004\bL\u0010$\u00a8\u0006^"}, d2={"Lcom/pubnub/internal/managers/RetrofitManager;", "", "retrofitManager", "configuration", "Lcom/pubnub/api/v2/BasePNConfiguration;", "(Lcom/pubnub/internal/managers/RetrofitManager;Lcom/pubnub/api/v2/BasePNConfiguration;)V", "pubnub", "Lcom/pubnub/internal/PubNubCore;", "transactionClientInstance", "Lokhttp3/OkHttpClient;", "subscriptionClientInstance", "noSignatureClientInstance", "(Lcom/pubnub/internal/PubNubCore;Lcom/pubnub/api/v2/BasePNConfiguration;Lokhttp3/OkHttpClient;Lokhttp3/OkHttpClient;Lokhttp3/OkHttpClient;)V", "accessManagerService", "Lcom/pubnub/internal/services/AccessManagerService;", "getAccessManagerService$pubnub_core_impl", "()Lcom/pubnub/internal/services/AccessManagerService;", "channelGroupService", "Lcom/pubnub/internal/services/ChannelGroupService;", "getChannelGroupService$pubnub_core_impl", "()Lcom/pubnub/internal/services/ChannelGroupService;", "filesService", "Lcom/pubnub/internal/services/FilesService;", "getFilesService$pubnub_core_impl", "()Lcom/pubnub/internal/services/FilesService;", "historyService", "Lcom/pubnub/internal/services/HistoryService;", "getHistoryService$pubnub_core_impl", "()Lcom/pubnub/internal/services/HistoryService;", "messageActionService", "Lcom/pubnub/internal/services/MessageActionService;", "getMessageActionService$pubnub_core_impl", "()Lcom/pubnub/internal/services/MessageActionService;", "getNoSignatureClientInstance$pubnub_core_impl", "()Lokhttp3/OkHttpClient;", "setNoSignatureClientInstance$pubnub_core_impl", "(Lokhttp3/OkHttpClient;)V", "objectsService", "Lcom/pubnub/internal/services/ObjectsService;", "getObjectsService$pubnub_core_impl", "()Lcom/pubnub/internal/services/ObjectsService;", "presenceService", "Lcom/pubnub/internal/services/PresenceService;", "getPresenceService$pubnub_core_impl", "()Lcom/pubnub/internal/services/PresenceService;", "publishService", "Lcom/pubnub/internal/services/PublishService;", "getPublishService$pubnub_core_impl", "()Lcom/pubnub/internal/services/PublishService;", "getPubnub", "()Lcom/pubnub/internal/PubNubCore;", "pushService", "Lcom/pubnub/internal/services/PushService;", "getPushService$pubnub_core_impl", "()Lcom/pubnub/internal/services/PushService;", "s3Service", "Lcom/pubnub/internal/services/S3Service;", "getS3Service$pubnub_core_impl", "()Lcom/pubnub/internal/services/S3Service;", "signalService", "Lcom/pubnub/internal/services/SignalService;", "getSignalService$pubnub_core_impl", "()Lcom/pubnub/internal/services/SignalService;", "signatureInterceptor", "Lcom/pubnub/internal/interceptor/SignatureInterceptor;", "subscribeService", "Lcom/pubnub/internal/services/SubscribeService;", "getSubscribeService$pubnub_core_impl", "()Lcom/pubnub/internal/services/SubscribeService;", "getSubscriptionClientInstance$pubnub_core_impl", "setSubscriptionClientInstance$pubnub_core_impl", "timeService", "Lcom/pubnub/internal/services/TimeService;", "getTimeService$pubnub_core_impl", "()Lcom/pubnub/internal/services/TimeService;", "getTransactionClientInstance$pubnub_core_impl", "setTransactionClientInstance$pubnub_core_impl", "closeExecutor", "", "client", "force", "", "createOkHttpClient", "readTimeout", "", "withSignature", "parentOkHttpClient", "createRetrofit", "Lretrofit2/Retrofit;", "callFactory", "Lokhttp3/Call$Factory;", "destroy", "getTransactionClientExecutorService", "Ljava/util/concurrent/ExecutorService;", "pubnub-core-impl"})
@SourceDebugExtension(value={"SMAP\nRetrofitManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RetrofitManager.kt\ncom/pubnub/internal/managers/RetrofitManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,183:1\n1#2:184\n*E\n"})
public final class RetrofitManager {
    @NotNull
    private final PubNubCore pubnub;
    @NotNull
    private final BasePNConfiguration configuration;
    @Nullable
    private OkHttpClient transactionClientInstance;
    @Nullable
    private OkHttpClient subscriptionClientInstance;
    @Nullable
    private OkHttpClient noSignatureClientInstance;
    @NotNull
    private SignatureInterceptor signatureInterceptor;
    @NotNull
    private final TimeService timeService;
    @NotNull
    private final PublishService publishService;
    @NotNull
    private final HistoryService historyService;
    @NotNull
    private final PresenceService presenceService;
    @NotNull
    private final MessageActionService messageActionService;
    @NotNull
    private final SignalService signalService;
    @NotNull
    private final ChannelGroupService channelGroupService;
    @NotNull
    private final PushService pushService;
    @NotNull
    private final AccessManagerService accessManagerService;
    @NotNull
    private final SubscribeService subscribeService;
    @NotNull
    private final ObjectsService objectsService;
    @NotNull
    private final FilesService filesService;
    @NotNull
    private final S3Service s3Service;

    public RetrofitManager(@NotNull PubNubCore pubnub, @NotNull BasePNConfiguration configuration, @Nullable OkHttpClient transactionClientInstance, @Nullable OkHttpClient subscriptionClientInstance, @Nullable OkHttpClient noSignatureClientInstance) {
        Intrinsics.checkNotNullParameter(pubnub, "pubnub");
        Intrinsics.checkNotNullParameter(configuration, "configuration");
        this.pubnub = pubnub;
        this.configuration = configuration;
        this.transactionClientInstance = transactionClientInstance;
        this.subscriptionClientInstance = subscriptionClientInstance;
        this.noSignatureClientInstance = noSignatureClientInstance;
        this.signatureInterceptor = new SignatureInterceptor(this.configuration);
        if (!this.configuration.getGoogleAppEngineNetworking()) {
            this.transactionClientInstance = RetrofitManager.createOkHttpClient$default(this, this.configuration.getNonSubscribeReadTimeout(), false, this.transactionClientInstance, 2, null);
            this.subscriptionClientInstance = RetrofitManager.createOkHttpClient$default(this, this.configuration.getSubscribeTimeout(), false, this.subscriptionClientInstance, 2, null);
            this.noSignatureClientInstance = this.createOkHttpClient(this.configuration.getNonSubscribeReadTimeout(), false, this.noSignatureClientInstance);
        }
        Retrofit transactionInstance = this.createRetrofit(this.transactionClientInstance);
        Retrofit subscriptionInstance = this.createRetrofit(this.subscriptionClientInstance);
        Retrofit noSignatureInstance = this.createRetrofit(this.noSignatureClientInstance);
        TimeService timeService = transactionInstance.create(TimeService.class);
        Intrinsics.checkNotNullExpressionValue(timeService, "transactionInstance.crea\u2026(TimeService::class.java)");
        this.timeService = timeService;
        PublishService publishService = transactionInstance.create(PublishService.class);
        Intrinsics.checkNotNullExpressionValue(publishService, "transactionInstance.crea\u2026blishService::class.java)");
        this.publishService = publishService;
        HistoryService historyService = transactionInstance.create(HistoryService.class);
        Intrinsics.checkNotNullExpressionValue(historyService, "transactionInstance.crea\u2026storyService::class.java)");
        this.historyService = historyService;
        PresenceService presenceService = transactionInstance.create(PresenceService.class);
        Intrinsics.checkNotNullExpressionValue(presenceService, "transactionInstance.crea\u2026senceService::class.java)");
        this.presenceService = presenceService;
        MessageActionService messageActionService = transactionInstance.create(MessageActionService.class);
        Intrinsics.checkNotNullExpressionValue(messageActionService, "transactionInstance.crea\u2026ctionService::class.java)");
        this.messageActionService = messageActionService;
        SignalService signalService = transactionInstance.create(SignalService.class);
        Intrinsics.checkNotNullExpressionValue(signalService, "transactionInstance.crea\u2026ignalService::class.java)");
        this.signalService = signalService;
        ChannelGroupService channelGroupService = transactionInstance.create(ChannelGroupService.class);
        Intrinsics.checkNotNullExpressionValue(channelGroupService, "transactionInstance.crea\u2026GroupService::class.java)");
        this.channelGroupService = channelGroupService;
        PushService pushService = transactionInstance.create(PushService.class);
        Intrinsics.checkNotNullExpressionValue(pushService, "transactionInstance.crea\u2026(PushService::class.java)");
        this.pushService = pushService;
        AccessManagerService accessManagerService = transactionInstance.create(AccessManagerService.class);
        Intrinsics.checkNotNullExpressionValue(accessManagerService, "transactionInstance.crea\u2026nagerService::class.java)");
        this.accessManagerService = accessManagerService;
        ObjectsService objectsService = transactionInstance.create(ObjectsService.class);
        Intrinsics.checkNotNullExpressionValue(objectsService, "transactionInstance.crea\u2026jectsService::class.java)");
        this.objectsService = objectsService;
        FilesService filesService = transactionInstance.create(FilesService.class);
        Intrinsics.checkNotNullExpressionValue(filesService, "transactionInstance.crea\u2026FilesService::class.java)");
        this.filesService = filesService;
        S3Service s3Service = noSignatureInstance.create(S3Service.class);
        Intrinsics.checkNotNullExpressionValue(s3Service, "noSignatureInstance.create(S3Service::class.java)");
        this.s3Service = s3Service;
        SubscribeService subscribeService = subscriptionInstance.create(SubscribeService.class);
        Intrinsics.checkNotNullExpressionValue(subscribeService, "subscriptionInstance.cre\u2026cribeService::class.java)");
        this.subscribeService = subscribeService;
    }

    public /* synthetic */ RetrofitManager(PubNubCore pubNubCore, BasePNConfiguration basePNConfiguration, OkHttpClient okHttpClient, OkHttpClient okHttpClient2, OkHttpClient okHttpClient3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            okHttpClient = null;
        }
        if ((n & 8) != 0) {
            okHttpClient2 = null;
        }
        if ((n & 0x10) != 0) {
            okHttpClient3 = null;
        }
        this(pubNubCore, basePNConfiguration, okHttpClient, okHttpClient2, okHttpClient3);
    }

    @NotNull
    public final PubNubCore getPubnub() {
        return this.pubnub;
    }

    @Nullable
    public final OkHttpClient getTransactionClientInstance$pubnub_core_impl() {
        return this.transactionClientInstance;
    }

    public final void setTransactionClientInstance$pubnub_core_impl(@Nullable OkHttpClient okHttpClient) {
        this.transactionClientInstance = okHttpClient;
    }

    @Nullable
    public final OkHttpClient getSubscriptionClientInstance$pubnub_core_impl() {
        return this.subscriptionClientInstance;
    }

    public final void setSubscriptionClientInstance$pubnub_core_impl(@Nullable OkHttpClient okHttpClient) {
        this.subscriptionClientInstance = okHttpClient;
    }

    @Nullable
    public final OkHttpClient getNoSignatureClientInstance$pubnub_core_impl() {
        return this.noSignatureClientInstance;
    }

    public final void setNoSignatureClientInstance$pubnub_core_impl(@Nullable OkHttpClient okHttpClient) {
        this.noSignatureClientInstance = okHttpClient;
    }

    @NotNull
    public final TimeService getTimeService$pubnub_core_impl() {
        return this.timeService;
    }

    @NotNull
    public final PublishService getPublishService$pubnub_core_impl() {
        return this.publishService;
    }

    @NotNull
    public final HistoryService getHistoryService$pubnub_core_impl() {
        return this.historyService;
    }

    @NotNull
    public final PresenceService getPresenceService$pubnub_core_impl() {
        return this.presenceService;
    }

    @NotNull
    public final MessageActionService getMessageActionService$pubnub_core_impl() {
        return this.messageActionService;
    }

    @NotNull
    public final SignalService getSignalService$pubnub_core_impl() {
        return this.signalService;
    }

    @NotNull
    public final ChannelGroupService getChannelGroupService$pubnub_core_impl() {
        return this.channelGroupService;
    }

    @NotNull
    public final PushService getPushService$pubnub_core_impl() {
        return this.pushService;
    }

    @NotNull
    public final AccessManagerService getAccessManagerService$pubnub_core_impl() {
        return this.accessManagerService;
    }

    @NotNull
    public final SubscribeService getSubscribeService$pubnub_core_impl() {
        return this.subscribeService;
    }

    @NotNull
    public final ObjectsService getObjectsService$pubnub_core_impl() {
        return this.objectsService;
    }

    @NotNull
    public final FilesService getFilesService$pubnub_core_impl() {
        return this.filesService;
    }

    @NotNull
    public final S3Service getS3Service$pubnub_core_impl() {
        return this.s3Service;
    }

    public RetrofitManager(@NotNull RetrofitManager retrofitManager, @NotNull BasePNConfiguration configuration) {
        Intrinsics.checkNotNullParameter(retrofitManager, "retrofitManager");
        Intrinsics.checkNotNullParameter(configuration, "configuration");
        this(retrofitManager.pubnub, configuration, retrofitManager.transactionClientInstance, retrofitManager.subscriptionClientInstance, retrofitManager.noSignatureClientInstance);
    }

    @Nullable
    public final ExecutorService getTransactionClientExecutorService() {
        Object object = this.transactionClientInstance;
        return object != null && (object = ((OkHttpClient)object).dispatcher()) != null ? ((Dispatcher)object).executorService() : null;
    }

    /*
     * WARNING - void declaration
     */
    private final OkHttpClient createOkHttpClient(int readTimeout, boolean withSignature, OkHttpClient parentOkHttpClient) {
        OkHttpClient okHttpClient;
        block11: {
            Object object = parentOkHttpClient;
            if (object == null || (object = ((OkHttpClient)object).newBuilder()) == null) {
                object = new OkHttpClient.Builder();
            }
            Object okHttpBuilder = object;
            ((OkHttpClient.Builder)okHttpBuilder).retryOnConnectionFailure(false).readTimeout(readTimeout, TimeUnit.SECONDS).connectTimeout(this.configuration.getConnectTimeout(), TimeUnit.SECONDS);
            BasePNConfiguration $this$createOkHttpClient_u24lambda_u247 = this.configuration;
            boolean bl = false;
            if ($this$createOkHttpClient_u24lambda_u247.getLogVerbosity() == PNLogVerbosity.BODY) {
                void $this$createOkHttpClient_u24lambda_u247_u24lambda_u240;
                HttpLoggingInterceptor httpLoggingInterceptor;
                HttpLoggingInterceptor httpLoggingInterceptor2 = httpLoggingInterceptor = new HttpLoggingInterceptor(null, 1, null);
                Object object2 = okHttpBuilder;
                boolean bl2 = false;
                $this$createOkHttpClient_u24lambda_u247_u24lambda_u240.level(HttpLoggingInterceptor.Level.BODY);
                ((OkHttpClient.Builder)object2).addInterceptor(httpLoggingInterceptor);
            }
            if ($this$createOkHttpClient_u24lambda_u247.getHttpLoggingInterceptor() != null) {
                HttpLoggingInterceptor httpLoggingInterceptor = $this$createOkHttpClient_u24lambda_u247.getHttpLoggingInterceptor();
                Intrinsics.checkNotNull(httpLoggingInterceptor);
                ((OkHttpClient.Builder)okHttpBuilder).addInterceptor(httpLoggingInterceptor);
            }
            if ($this$createOkHttpClient_u24lambda_u247.getSslSocketFactory() != null && $this$createOkHttpClient_u24lambda_u247.getX509ExtendedTrustManager() != null) {
                SSLSocketFactory sSLSocketFactory = this.configuration.getSslSocketFactory();
                Intrinsics.checkNotNull(sSLSocketFactory);
                X509ExtendedTrustManager x509ExtendedTrustManager = this.configuration.getX509ExtendedTrustManager();
                Intrinsics.checkNotNull(x509ExtendedTrustManager);
                ((OkHttpClient.Builder)okHttpBuilder).sslSocketFactory(sSLSocketFactory, x509ExtendedTrustManager);
            }
            ConnectionSpec connectionSpec = $this$createOkHttpClient_u24lambda_u247.getConnectionSpec();
            if (connectionSpec != null) {
                ConnectionSpec it = connectionSpec;
                boolean bl3 = false;
                ((OkHttpClient.Builder)okHttpBuilder).connectionSpecs(CollectionsKt.listOf(it));
            }
            HostnameVerifier hostnameVerifier = $this$createOkHttpClient_u24lambda_u247.getHostnameVerifier();
            if (hostnameVerifier != null) {
                HostnameVerifier it = hostnameVerifier;
                boolean bl4 = false;
                ((OkHttpClient.Builder)okHttpBuilder).hostnameVerifier(it);
            }
            Proxy proxy = $this$createOkHttpClient_u24lambda_u247.getProxy();
            if (proxy != null) {
                Proxy it = proxy;
                boolean bl5 = false;
                ((OkHttpClient.Builder)okHttpBuilder).proxy(it);
            }
            ProxySelector proxySelector = $this$createOkHttpClient_u24lambda_u247.getProxySelector();
            if (proxySelector != null) {
                ProxySelector it = proxySelector;
                boolean bl6 = false;
                ((OkHttpClient.Builder)okHttpBuilder).proxySelector(it);
            }
            Authenticator authenticator = $this$createOkHttpClient_u24lambda_u247.getProxyAuthenticator();
            if (authenticator != null) {
                Authenticator it = authenticator;
                boolean bl7 = false;
                ((OkHttpClient.Builder)okHttpBuilder).proxyAuthenticator(it);
            }
            CertificatePinner certificatePinner = $this$createOkHttpClient_u24lambda_u247.getCertificatePinner();
            if (certificatePinner != null) {
                CertificatePinner it = certificatePinner;
                boolean bl8 = false;
                ((OkHttpClient.Builder)okHttpBuilder).certificatePinner(it);
            }
            if (withSignature) {
                CollectionsKt.removeAll(((OkHttpClient.Builder)okHttpBuilder).interceptors(), (Function1)createOkHttpClient.2.INSTANCE);
                ((OkHttpClient.Builder)okHttpBuilder).addInterceptor(this.signatureInterceptor);
            }
            okHttpClient = ((OkHttpClient.Builder)okHttpBuilder).build();
            Integer n = this.configuration.getMaximumConnections();
            if (n == null) break block11;
            int it = ((Number)n).intValue();
            boolean bl9 = false;
            okHttpClient.dispatcher().setMaxRequestsPerHost(it);
        }
        return okHttpClient;
    }

    static /* synthetic */ OkHttpClient createOkHttpClient$default(RetrofitManager retrofitManager, int n, boolean bl, OkHttpClient okHttpClient, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = true;
        }
        if ((n2 & 4) != 0) {
            okHttpClient = null;
        }
        return retrofitManager.createOkHttpClient(n, bl, okHttpClient);
    }

    private final Retrofit createRetrofit(Call.Factory callFactory) {
        Retrofit.Builder retrofitBuilder = new Retrofit.Builder().baseUrl(this.pubnub.baseUrl$pubnub_core_impl()).addConverterFactory(this.pubnub.getMapper().getConverterFactory$pubnub_core_impl());
        if (this.configuration.getGoogleAppEngineNetworking()) {
            retrofitBuilder.callFactory(new AppEngineFactory.Factory(this.configuration));
        } else if (callFactory != null) {
            retrofitBuilder.callFactory(callFactory);
        } else {
            throw new IllegalStateException("Can't instantiate PubNub");
        }
        Retrofit retrofit = retrofitBuilder.build();
        Intrinsics.checkNotNullExpressionValue(retrofit, "retrofitBuilder.build()");
        return retrofit;
    }

    public final void destroy(boolean force) {
        this.closeExecutor(this.transactionClientInstance, force);
        this.closeExecutor(this.subscriptionClientInstance, force);
        this.closeExecutor(this.noSignatureClientInstance, force);
    }

    public static /* synthetic */ void destroy$default(RetrofitManager retrofitManager, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        retrofitManager.destroy(bl);
    }

    private final void closeExecutor(OkHttpClient client, boolean force) {
        if (client != null) {
            client.dispatcher().cancelAll();
            if (force) {
                client.connectionPool().evictAll();
                ExecutorService executorService = client.dispatcher().executorService();
                executorService.shutdown();
            }
        }
    }
}

