/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal;

import com.pubnub.api.PNConfiguration;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.builder.PresenceBuilder;
import com.pubnub.api.builder.SubscribeBuilder;
import com.pubnub.api.builder.UnsubscribeBuilder;
import com.pubnub.api.callbacks.Listener;
import com.pubnub.api.callbacks.SubscribeCallback;
import com.pubnub.api.crypto.CryptoModule;
import com.pubnub.api.endpoints.DeleteMessages;
import com.pubnub.api.endpoints.FetchMessages;
import com.pubnub.api.endpoints.History;
import com.pubnub.api.endpoints.MessageCounts;
import com.pubnub.api.endpoints.Time;
import com.pubnub.api.endpoints.access.Grant;
import com.pubnub.api.endpoints.access.RevokeToken;
import com.pubnub.api.endpoints.access.builder.GrantTokenBuilder;
import com.pubnub.api.endpoints.channel_groups.AddChannelChannelGroup;
import com.pubnub.api.endpoints.channel_groups.AllChannelsChannelGroup;
import com.pubnub.api.endpoints.channel_groups.DeleteChannelGroup;
import com.pubnub.api.endpoints.channel_groups.ListAllChannelGroup;
import com.pubnub.api.endpoints.channel_groups.RemoveChannelChannelGroup;
import com.pubnub.api.endpoints.files.DeleteFile;
import com.pubnub.api.endpoints.files.DownloadFile;
import com.pubnub.api.endpoints.files.GetFileUrl;
import com.pubnub.api.endpoints.files.ListFiles;
import com.pubnub.api.endpoints.files.PublishFileMessage;
import com.pubnub.api.endpoints.files.SendFile;
import com.pubnub.api.endpoints.message_actions.AddMessageAction;
import com.pubnub.api.endpoints.message_actions.GetMessageActions;
import com.pubnub.api.endpoints.message_actions.RemoveMessageAction;
import com.pubnub.api.endpoints.objects_api.channel.GetAllChannelsMetadata;
import com.pubnub.api.endpoints.objects_api.channel.GetChannelMetadata;
import com.pubnub.api.endpoints.objects_api.channel.RemoveChannelMetadata;
import com.pubnub.api.endpoints.objects_api.channel.SetChannelMetadata;
import com.pubnub.api.endpoints.objects_api.members.GetChannelMembers;
import com.pubnub.api.endpoints.objects_api.members.ManageChannelMembers;
import com.pubnub.api.endpoints.objects_api.members.RemoveChannelMembers;
import com.pubnub.api.endpoints.objects_api.members.SetChannelMembers;
import com.pubnub.api.endpoints.objects_api.memberships.GetMemberships;
import com.pubnub.api.endpoints.objects_api.memberships.ManageMemberships;
import com.pubnub.api.endpoints.objects_api.memberships.RemoveMemberships;
import com.pubnub.api.endpoints.objects_api.memberships.SetMemberships;
import com.pubnub.api.endpoints.objects_api.uuid.GetAllUUIDMetadata;
import com.pubnub.api.endpoints.objects_api.uuid.GetUUIDMetadata;
import com.pubnub.api.endpoints.objects_api.uuid.RemoveUUIDMetadata;
import com.pubnub.api.endpoints.objects_api.uuid.SetUUIDMetadata;
import com.pubnub.api.endpoints.presence.GetState;
import com.pubnub.api.endpoints.presence.HereNow;
import com.pubnub.api.endpoints.presence.SetState;
import com.pubnub.api.endpoints.presence.WhereNow;
import com.pubnub.api.endpoints.pubsub.Publish;
import com.pubnub.api.endpoints.pubsub.Signal;
import com.pubnub.api.endpoints.push.AddChannelsToPush;
import com.pubnub.api.endpoints.push.ListPushProvisions;
import com.pubnub.api.endpoints.push.RemoveAllPushChannelsForDevice;
import com.pubnub.api.endpoints.push.RemoveChannelsFromPush;
import com.pubnub.api.v2.BasePNConfiguration;
import com.pubnub.api.v2.callbacks.EventListener;
import com.pubnub.api.v2.callbacks.StatusListener;
import com.pubnub.api.v2.endpoints.pubsub.PublishBuilder;
import com.pubnub.api.v2.endpoints.pubsub.SignalBuilder;
import com.pubnub.api.v2.entities.Channel;
import com.pubnub.api.v2.entities.ChannelGroup;
import com.pubnub.api.v2.entities.ChannelMetadata;
import com.pubnub.api.v2.entities.UserMetadata;
import com.pubnub.api.v2.subscriptions.Subscription;
import com.pubnub.api.v2.subscriptions.SubscriptionSet;
import com.pubnub.internal.BasePubNubImpl;
import com.pubnub.internal.callbacks.DelegatingStatusListener;
import com.pubnub.internal.callbacks.DelegatingSubscribeCallback;
import com.pubnub.internal.endpoints.DeleteMessagesImpl;
import com.pubnub.internal.endpoints.FetchMessagesImpl;
import com.pubnub.internal.endpoints.HistoryImpl;
import com.pubnub.internal.endpoints.MessageCountsImpl;
import com.pubnub.internal.endpoints.TimeImpl;
import com.pubnub.internal.endpoints.access.GrantImpl;
import com.pubnub.internal.endpoints.access.GrantTokenImpl;
import com.pubnub.internal.endpoints.access.RevokeTokenImpl;
import com.pubnub.internal.endpoints.channel_groups.AddChannelChannelGroupImpl;
import com.pubnub.internal.endpoints.channel_groups.AllChannelsChannelGroupImpl;
import com.pubnub.internal.endpoints.channel_groups.DeleteChannelGroupImpl;
import com.pubnub.internal.endpoints.channel_groups.ListAllChannelGroupImpl;
import com.pubnub.internal.endpoints.channel_groups.RemoveChannelChannelGroupImpl;
import com.pubnub.internal.endpoints.files.DeleteFileImpl;
import com.pubnub.internal.endpoints.files.DownloadFileImpl;
import com.pubnub.internal.endpoints.files.GetFileUrlImpl;
import com.pubnub.internal.endpoints.files.ListFilesImpl;
import com.pubnub.internal.endpoints.files.PublishFileMessageImpl;
import com.pubnub.internal.endpoints.files.SendFileImpl;
import com.pubnub.internal.endpoints.message_actions.AddMessageActionImpl;
import com.pubnub.internal.endpoints.message_actions.GetMessageActionsImpl;
import com.pubnub.internal.endpoints.message_actions.RemoveMessageActionImpl;
import com.pubnub.internal.endpoints.objects_api.channel.GetAllChannelsMetadataImpl;
import com.pubnub.internal.endpoints.objects_api.channel.GetChannelMetadataImpl;
import com.pubnub.internal.endpoints.objects_api.channel.RemoveChannelMetadataImpl;
import com.pubnub.internal.endpoints.objects_api.channel.SetChannelMetadataImpl;
import com.pubnub.internal.endpoints.objects_api.members.GetChannelMembersImpl;
import com.pubnub.internal.endpoints.objects_api.members.ManageChannelMembersImpl;
import com.pubnub.internal.endpoints.objects_api.members.RemoveChannelMembersImpl;
import com.pubnub.internal.endpoints.objects_api.members.SetChannelMembersImpl;
import com.pubnub.internal.endpoints.objects_api.memberships.GetMembershipsImpl;
import com.pubnub.internal.endpoints.objects_api.memberships.ManageMembershipsImpl;
import com.pubnub.internal.endpoints.objects_api.memberships.RemoveMembershipsImpl;
import com.pubnub.internal.endpoints.objects_api.memberships.SetMembershipsImpl;
import com.pubnub.internal.endpoints.objects_api.uuid.GetAllUUIDMetadataImpl;
import com.pubnub.internal.endpoints.objects_api.uuid.GetUUIDMetadataImpl;
import com.pubnub.internal.endpoints.objects_api.uuid.RemoveUUIDMetadataImpl;
import com.pubnub.internal.endpoints.objects_api.uuid.SetUUIDMetadataImpl;
import com.pubnub.internal.endpoints.presence.GetStateImpl;
import com.pubnub.internal.endpoints.presence.HereNowImpl;
import com.pubnub.internal.endpoints.presence.SetStateImpl;
import com.pubnub.internal.endpoints.presence.WhereNowImpl;
import com.pubnub.internal.endpoints.pubsub.PublishImpl;
import com.pubnub.internal.endpoints.pubsub.SignalImpl;
import com.pubnub.internal.endpoints.push.AddChannelsToPushImpl;
import com.pubnub.internal.endpoints.push.ListPushProvisionsImpl;
import com.pubnub.internal.endpoints.push.RemoveAllPushChannelsForDeviceImpl;
import com.pubnub.internal.endpoints.push.RemoveChannelsFromPushImpl;
import com.pubnub.internal.v2.callbacks.DelegatingEventListener;
import com.pubnub.internal.v2.entities.ChannelGroupImpl;
import com.pubnub.internal.v2.entities.ChannelImpl;
import com.pubnub.internal.v2.entities.ChannelMetadataImpl;
import com.pubnub.internal.v2.entities.UserMetadataImpl;
import com.pubnub.internal.v2.subscription.SubscriptionImpl;
import com.pubnub.internal.v2.subscription.SubscriptionSetImpl;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PubNubImpl
extends BasePubNubImpl<EventListener, Subscription, Channel, ChannelGroup, ChannelMetadata, UserMetadata, SubscriptionSet, StatusListener>
implements PubNub {
    private static final String PNSDK_PUBNUB_JAVA = "PubNub-Java";
    @NotNull
    private final BasePNConfiguration configuration;

    public PubNubImpl(@NotNull BasePNConfiguration configuration) {
        super(configuration, PNSDK_PUBNUB_JAVA);
        this.configuration = configuration;
    }

    @Override
    @NotNull
    public BasePNConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    @NotNull
    public SubscribeBuilder subscribe() {
        return new SubscribeBuilder(this.getPubNubCore());
    }

    @Override
    @NotNull
    public UnsubscribeBuilder unsubscribe() {
        return new UnsubscribeBuilder(this.getPubNubCore());
    }

    @Override
    @NotNull
    public PresenceBuilder presence() {
        return new PresenceBuilder(this.getPubNubCore());
    }

    @Override
    @NotNull
    public AddChannelsToPush addPushNotificationsOnChannels() {
        return new AddChannelsToPushImpl(this.getPubNubCore());
    }

    @Override
    @NotNull
    public RemoveChannelsFromPush removePushNotificationsFromChannels() {
        return new RemoveChannelsFromPushImpl(this.getPubNubCore());
    }

    @Override
    @NotNull
    public RemoveAllPushChannelsForDevice removeAllPushNotificationsFromDeviceWithPushToken() {
        return new RemoveAllPushChannelsForDeviceImpl(this.getPubNubCore());
    }

    @Override
    @NotNull
    public ListPushProvisions auditPushChannelProvisions() {
        return new ListPushProvisionsImpl(this.getPubNubCore());
    }

    @Override
    @NotNull
    public WhereNow whereNow() {
        return new WhereNowImpl(this.getPubNubCore());
    }

    @Override
    @NotNull
    public HereNow hereNow() {
        return new HereNowImpl(this.getPubNubCore());
    }

    @Override
    @NotNull
    public Time time() {
        return new TimeImpl(this.getPubNubCore());
    }

    @Override
    @NotNull
    public History history() {
        return new HistoryImpl(this.getPubNubCore());
    }

    @Override
    @NotNull
    public FetchMessages fetchMessages() {
        return new FetchMessagesImpl(this.getPubNubCore());
    }

    @Override
    @NotNull
    public DeleteMessages deleteMessages() {
        return new DeleteMessagesImpl(this.getPubNubCore());
    }

    @Override
    @NotNull
    public MessageCounts messageCounts() {
        return new MessageCountsImpl(this.getPubNubCore());
    }

    @Override
    @NotNull
    public Grant grant() {
        return new GrantImpl(this.getPubNubCore());
    }

    @Override
    @NotNull
    public GrantTokenBuilder grantToken() {
        return new GrantTokenImpl(this.getPubNubCore());
    }

    @Override
    @NotNull
    public GrantTokenBuilder grantToken(int ttl) {
        return new GrantTokenImpl(this.getPubNubCore()).ttl(ttl);
    }

    @Override
    @NotNull
    public RevokeToken revokeToken() {
        return new RevokeTokenImpl(this.getPubNubCore());
    }

    @Override
    @NotNull
    public GetState getPresenceState() {
        return new GetStateImpl(this.getPubNubCore());
    }

    @Override
    @NotNull
    public SetState setPresenceState() {
        return new SetStateImpl(this.getPubNubCore());
    }

    @Override
    @NotNull
    public Publish publish() {
        return new PublishImpl(this.getPubNubCore());
    }

    @Override
    @NotNull
    public PublishBuilder publish(@NotNull Object message, @NotNull String channel) {
        return new PublishImpl(this.getPubNubCore()).message(message).channel(channel);
    }

    @Override
    @NotNull
    public Signal signal() {
        return new SignalImpl(this.getPubNubCore());
    }

    @Override
    @NotNull
    public SignalBuilder signal(@NotNull Object message, @NotNull String channel) {
        return new SignalImpl(this.getPubNubCore()).message(message).channel(channel);
    }

    @Override
    @NotNull
    public ListAllChannelGroup listAllChannelGroups() {
        return new ListAllChannelGroupImpl(this.getPubNubCore());
    }

    @Override
    @NotNull
    public AllChannelsChannelGroup listChannelsForChannelGroup() {
        return new AllChannelsChannelGroupImpl(this.getPubNubCore());
    }

    @Override
    @NotNull
    public AddChannelChannelGroup addChannelsToChannelGroup() {
        return new AddChannelChannelGroupImpl(this.getPubNubCore());
    }

    @Override
    @NotNull
    public RemoveChannelChannelGroup removeChannelsFromChannelGroup() {
        return new RemoveChannelChannelGroupImpl(this.getPubNubCore());
    }

    @Override
    @NotNull
    public DeleteChannelGroup deleteChannelGroup() {
        return new DeleteChannelGroupImpl(this.getPubNubCore());
    }

    @Override
    public SetUUIDMetadata setUUIDMetadata() {
        return new SetUUIDMetadataImpl(this.getPubNubCore());
    }

    @Override
    @NotNull
    public GetAllUUIDMetadata getAllUUIDMetadata() {
        return new GetAllUUIDMetadataImpl(this.getPubNubCore());
    }

    @Override
    @NotNull
    public GetUUIDMetadata getUUIDMetadata() {
        return new GetUUIDMetadataImpl(this.getPubNubCore());
    }

    @Override
    @NotNull
    public RemoveUUIDMetadata removeUUIDMetadata() {
        return new RemoveUUIDMetadataImpl(this.getPubNubCore());
    }

    @Override
    public SetChannelMetadata.Builder setChannelMetadata() {
        return new SetChannelMetadataImpl.Builder(this.getPubNubCore());
    }

    @Override
    @NotNull
    public GetAllChannelsMetadata getAllChannelsMetadata() {
        return new GetAllChannelsMetadataImpl(this.getPubNubCore());
    }

    @Override
    @NotNull
    public GetChannelMetadata.Builder getChannelMetadata() {
        return new GetChannelMetadataImpl.Builder(this.getPubNubCore());
    }

    @Override
    public RemoveChannelMetadata.Builder removeChannelMetadata() {
        return new RemoveChannelMetadataImpl.Builder(this.getPubNubCore());
    }

    @Override
    @NotNull
    public GetMemberships getMemberships() {
        return new GetMembershipsImpl(this.getPubNubCore());
    }

    @Override
    @NotNull
    public SetMemberships.Builder setMemberships() {
        return new SetMembershipsImpl.Builder(this.getPubNubCore());
    }

    @Override
    public RemoveMemberships.Builder removeMemberships() {
        return new RemoveMembershipsImpl.Builder(this.getPubNubCore());
    }

    @Override
    public ManageMemberships.Builder manageMemberships() {
        return new ManageMembershipsImpl.Builder(this.getPubNubCore());
    }

    @Override
    public GetChannelMembers.Builder getChannelMembers() {
        return new GetChannelMembersImpl.Builder(this.getPubNubCore());
    }

    @Override
    public SetChannelMembers.Builder setChannelMembers() {
        return new SetChannelMembersImpl.Builder(this.getPubNubCore());
    }

    @Override
    public RemoveChannelMembers.Builder removeChannelMembers() {
        return new RemoveChannelMembersImpl.Builder(this.getPubNubCore());
    }

    @Override
    public ManageChannelMembers.Builder manageChannelMembers() {
        return new ManageChannelMembersImpl.Builder(this.getPubNubCore());
    }

    @Override
    @NotNull
    public AddMessageAction addMessageAction() {
        return new AddMessageActionImpl(this.getPubNubCore());
    }

    @Override
    @NotNull
    public GetMessageActions getMessageActions() {
        return new GetMessageActionsImpl(this.getPubNubCore());
    }

    @Override
    @NotNull
    public RemoveMessageAction removeMessageAction() {
        return new RemoveMessageActionImpl(this.getPubNubCore());
    }

    @Override
    public SendFile.Builder sendFile() {
        return new SendFileImpl.Builder(this.getPubNubCore());
    }

    @Override
    public ListFiles.Builder listFiles() {
        return new ListFilesImpl.Builder(this.getPubNubCore());
    }

    @Override
    public GetFileUrl.Builder getFileUrl() {
        return GetFileUrlImpl.builder(this.getPubNubCore());
    }

    @Override
    public DownloadFile.Builder downloadFile() {
        return DownloadFileImpl.builder(this.getPubNubCore());
    }

    @Override
    public DeleteFile.Builder deleteFile() {
        return DeleteFileImpl.builder(this.getPubNubCore());
    }

    @Override
    public PublishFileMessage.Builder publishFileMessage() {
        return PublishFileMessageImpl.builder(this.getPubNubCore());
    }

    @Override
    public void reconnect() {
        this.reconnect(0L);
    }

    @NotNull
    private CryptoModule getCryptoModuleOrThrow(@Nullable String cipherKey) throws PubNubException {
        if (cipherKey != null) {
            if (this.configuration instanceof PNConfiguration) {
                return CryptoModule.createLegacyCryptoModule(cipherKey, ((PNConfiguration)this.configuration).getUseRandomInitializationVector());
            }
            return CryptoModule.createLegacyCryptoModule(cipherKey, true);
        }
        if (this.configuration.getCryptoModule() != null) {
            return this.configuration.getCryptoModule();
        }
        throw new PubNubException(PubNubError.CRYPTO_ERROR, "Crypto module is not initialized");
    }

    @Override
    @NotNull
    public String decrypt(@NotNull String inputString) throws PubNubException {
        return this.decrypt(inputString, null);
    }

    @Override
    @NotNull
    public String decrypt(@NotNull String inputString, String cipherKey) throws PubNubException {
        if (inputString == null) {
            throw new PubNubException(PubNubError.INVALID_ARGUMENTS);
        }
        return this.getPubNubCore().decrypt(inputString, this.getCryptoModuleOrThrow(cipherKey));
    }

    @Override
    @NotNull
    public InputStream decryptInputStream(@NotNull InputStream inputStream2) throws PubNubException {
        return this.decryptInputStream(inputStream2, null);
    }

    @Override
    @NotNull
    public InputStream decryptInputStream(@NotNull InputStream inputStream2, @Nullable String cipherKey) throws PubNubException {
        if (inputStream2 == null) {
            throw new PubNubException(PubNubError.INVALID_ARGUMENTS);
        }
        return this.getPubNubCore().decryptInputStream(inputStream2, this.getCryptoModuleOrThrow(cipherKey));
    }

    @Override
    @NotNull
    public String encrypt(@NotNull String inputString) throws PubNubException {
        return this.encrypt(inputString, null);
    }

    @Override
    @NotNull
    public String encrypt(@NotNull String inputString, String cipherKey) throws PubNubException {
        if (inputString == null) {
            throw new PubNubException(PubNubError.INVALID_ARGUMENTS);
        }
        return this.getPubNubCore().encrypt(inputString, this.getCryptoModuleOrThrow(cipherKey));
    }

    @Override
    @NotNull
    public InputStream encryptInputStream(@NotNull InputStream inputStream2) throws PubNubException {
        return this.encryptInputStream(inputStream2, null);
    }

    @Override
    @NotNull
    public InputStream encryptInputStream(@NotNull InputStream inputStream2, String cipherKey) throws PubNubException {
        return this.getPubNubCore().encryptInputStream(inputStream2, this.getCryptoModuleOrThrow(cipherKey));
    }

    @Override
    @NotNull
    public Publish fire() {
        return this.publish().shouldStore(false).replicate(false);
    }

    @Override
    @NotNull
    public PublishBuilder fire(Object message, String channel) {
        return this.publish(message, channel).shouldStore(false).replicate(false);
    }

    @Override
    @NotNull
    public List<String> getSubscribedChannels() {
        return this.getPubNubCore().getSubscribedChannels();
    }

    @Override
    @NotNull
    public List<String> getSubscribedChannelGroups() {
        return this.getPubNubCore().getSubscribedChannelGroups();
    }

    @Override
    @NotNull
    public Channel channel(@NotNull String name) {
        return new ChannelImpl(this, name);
    }

    @Override
    @NotNull
    public ChannelGroup channelGroup(@NotNull String name) {
        return new ChannelGroupImpl(this, name);
    }

    @Override
    @NotNull
    public ChannelMetadata channelMetadata(@NotNull String id) {
        return new ChannelMetadataImpl(this, id);
    }

    @Override
    @NotNull
    public UserMetadata userMetadata(@NotNull String id) {
        return new UserMetadataImpl(this, id);
    }

    @Override
    @NotNull
    public SubscriptionSet subscriptionSetOf(@NotNull Set<? extends Subscription> subscriptions) {
        return new SubscriptionSetImpl(this.getPubNubCore(), (Set<SubscriptionImpl>)subscriptions);
    }

    @Override
    public void addListener(@NotNull EventListener listener2) {
        this.getListenerManager().addListener(new DelegatingEventListener(listener2));
    }

    @Override
    public void addListener(@NotNull StatusListener listener2) {
        this.getListenerManager().addListener(new DelegatingStatusListener(listener2));
    }

    @Override
    public void addListener(@NotNull SubscribeCallback listener2) {
        this.getListenerManager().addListener(new DelegatingSubscribeCallback(listener2));
    }

    @Override
    public void removeListener(@NotNull Listener listener2) {
        if (listener2 instanceof SubscribeCallback) {
            super.removeListener(new DelegatingSubscribeCallback((SubscribeCallback)listener2));
        } else if (listener2 instanceof EventListener) {
            super.removeListener(new DelegatingEventListener((EventListener)listener2));
        } else if (listener2 instanceof StatusListener) {
            super.removeListener(new DelegatingStatusListener((StatusListener)listener2));
        } else {
            super.removeListener(listener2);
        }
    }
}

