/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.crypto.cryptor;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0005\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0006\u0010\u0016\u001a\u00020\u0003R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lcom/pubnub/internal/crypto/cryptor/CryptorHeader;", "", "sentinel", "", "version", "", "cryptorId", "cryptorDataSize", "cryptorData", "([BB[B[B[B)V", "getCryptorData", "()[B", "getCryptorDataSize", "getCryptorId", "getSentinel", "getVersion", "()B", "equals", "", "other", "hashCode", "", "toByteArray", "pubnub-core-impl"})
public final class CryptorHeader {
    @NotNull
    private final byte[] sentinel;
    private final byte version;
    @NotNull
    private final byte[] cryptorId;
    @NotNull
    private final byte[] cryptorDataSize;
    @NotNull
    private final byte[] cryptorData;

    public CryptorHeader(@NotNull byte[] sentinel, byte version, @NotNull byte[] cryptorId, @NotNull byte[] cryptorDataSize, @NotNull byte[] cryptorData) {
        Intrinsics.checkNotNullParameter(sentinel, "sentinel");
        Intrinsics.checkNotNullParameter(cryptorId, "cryptorId");
        Intrinsics.checkNotNullParameter(cryptorDataSize, "cryptorDataSize");
        Intrinsics.checkNotNullParameter(cryptorData, "cryptorData");
        this.sentinel = sentinel;
        this.version = version;
        this.cryptorId = cryptorId;
        this.cryptorDataSize = cryptorDataSize;
        this.cryptorData = cryptorData;
    }

    @NotNull
    public final byte[] getSentinel() {
        return this.sentinel;
    }

    public final byte getVersion() {
        return this.version;
    }

    @NotNull
    public final byte[] getCryptorId() {
        return this.cryptorId;
    }

    @NotNull
    public final byte[] getCryptorDataSize() {
        return this.cryptorDataSize;
    }

    @NotNull
    public final byte[] getCryptorData() {
        return this.cryptorData;
    }

    @NotNull
    public final byte[] toByteArray() {
        return ArraysKt.plus(ArraysKt.plus(ArraysKt.plus(ArraysKt.plus(this.sentinel, this.version), this.cryptorId), this.cryptorDataSize), this.cryptorData);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull(other, "null cannot be cast to non-null type com.pubnub.internal.crypto.cryptor.CryptorHeader");
        CryptorHeader cfr_ignored_0 = (CryptorHeader)other;
        if (!Arrays.equals(this.sentinel, ((CryptorHeader)other).sentinel)) {
            return false;
        }
        if (this.version != ((CryptorHeader)other).version) {
            return false;
        }
        if (!Arrays.equals(this.cryptorId, ((CryptorHeader)other).cryptorId)) {
            return false;
        }
        if (!Arrays.equals(this.cryptorDataSize, ((CryptorHeader)other).cryptorDataSize)) {
            return false;
        }
        return Arrays.equals(this.cryptorData, ((CryptorHeader)other).cryptorData);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.sentinel);
        result = 31 * result + this.version;
        result = 31 * result + Arrays.hashCode(this.cryptorId);
        result = 31 * result + Arrays.hashCode(this.cryptorDataSize);
        result = 31 * result + Arrays.hashCode(this.cryptorData);
        return result;
    }
}

