/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints;

import com.pubnub.api.PubNubException;
import com.pubnub.api.builder.PubNubErrorBuilder;
import com.pubnub.api.endpoints.FetchMessages;
import com.pubnub.api.models.consumer.PNBoundedPage;
import com.pubnub.api.models.consumer.history.PNFetchMessagesResult;
import com.pubnub.internal.EndpointInterface;
import com.pubnub.internal.PubNubCore;
import com.pubnub.internal.endpoints.IdentityMappingEndpoint;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchMessagesImpl
extends IdentityMappingEndpoint<PNFetchMessagesResult>
implements FetchMessages {
    private static final Logger log = LoggerFactory.getLogger(FetchMessagesImpl.class);
    private static final int SINGLE_CHANNEL_DEFAULT_MESSAGES = 100;
    private static final int SINGLE_CHANNEL_MAX_MESSAGES = 100;
    private static final int MULTIPLE_CHANNEL_DEFAULT_MESSAGES = 25;
    private static final int MULTIPLE_CHANNEL_MAX_MESSAGES = 25;
    private static final int DEFAULT_MESSAGES_WITH_ACTIONS = 25;
    private static final int MAX_MESSAGES_WITH_ACTIONS = 25;
    private List<String> channels = new ArrayList<String>();
    private Integer maximumPerChannel;
    private Long start;
    private Long end;
    private boolean includeMeta;
    private boolean includeMessageActions;
    private boolean includeMessageType = true;
    private boolean includeUUID = true;

    public FetchMessagesImpl(PubNubCore pubnub) {
        super(pubnub);
    }

    @Override
    @NotNull
    protected EndpointInterface<PNFetchMessagesResult> createAction() {
        return this.pubnub.fetchMessages(this.channels, new PNBoundedPage(this.start, this.end, this.maximumPerChannel), this.includeUUID, this.includeMeta, this.includeMessageActions, this.includeMessageType);
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (this.channels == null || this.channels.isEmpty()) {
            throw new PubNubException(PubNubErrorBuilder.PNERROBJ_CHANNEL_MISSING);
        }
        if (!this.includeMessageActions) {
            if (this.channels.size() == 1) {
                if (this.maximumPerChannel == null || this.maximumPerChannel < 1) {
                    this.maximumPerChannel = 100;
                    log.info("maximumPerChannel param defaulting to " + this.maximumPerChannel);
                } else if (this.maximumPerChannel > 100) {
                    this.maximumPerChannel = 100;
                    log.info("maximumPerChannel param defaulting to " + this.maximumPerChannel);
                }
            } else if (this.maximumPerChannel == null || this.maximumPerChannel < 1) {
                this.maximumPerChannel = 25;
                log.info("maximumPerChannel param defaulting to " + this.maximumPerChannel);
            } else if (this.maximumPerChannel > 25) {
                this.maximumPerChannel = 25;
                log.info("maximumPerChannel param defaulting to " + this.maximumPerChannel);
            }
        } else if (this.maximumPerChannel == null || this.maximumPerChannel < 1 || this.maximumPerChannel > 25) {
            this.maximumPerChannel = 25;
            log.info("maximumPerChannel param defaulting to " + this.maximumPerChannel);
        }
    }

    @Override
    public FetchMessagesImpl channels(List<String> channels) {
        this.channels = channels;
        return this;
    }

    @Override
    public FetchMessagesImpl maximumPerChannel(Integer maximumPerChannel) {
        this.maximumPerChannel = maximumPerChannel;
        return this;
    }

    @Override
    public FetchMessagesImpl start(Long start) {
        this.start = start;
        return this;
    }

    @Override
    public FetchMessagesImpl end(Long end) {
        this.end = end;
        return this;
    }

    @Override
    public FetchMessagesImpl includeMeta(boolean includeMeta) {
        this.includeMeta = includeMeta;
        return this;
    }

    @Override
    public FetchMessagesImpl includeMessageActions(boolean includeMessageActions) {
        this.includeMessageActions = includeMessageActions;
        return this;
    }

    @Override
    public FetchMessagesImpl includeMessageType(boolean includeMessageType) {
        this.includeMessageType = includeMessageType;
        return this;
    }

    @Override
    public FetchMessagesImpl includeUUID(boolean includeUUID) {
        this.includeUUID = includeUUID;
        return this;
    }
}

