/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints;

import com.pubnub.api.PubNubException;
import com.pubnub.api.builder.PubNubErrorBuilder;
import com.pubnub.api.endpoints.MessageCounts;
import com.pubnub.api.models.consumer.history.PNMessageCountResult;
import com.pubnub.internal.EndpointInterface;
import com.pubnub.internal.PubNubCore;
import com.pubnub.internal.endpoints.IdentityMappingEndpoint;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MessageCountsImpl
extends IdentityMappingEndpoint<PNMessageCountResult>
implements MessageCounts {
    private List<String> channels;
    private List<Long> channelsTimetoken;

    public MessageCountsImpl(PubNubCore pubnub) {
        super(pubnub);
    }

    @Override
    @NotNull
    protected EndpointInterface<PNMessageCountResult> createAction() {
        return this.pubnub.messageCounts(this.channels, this.channelsTimetoken);
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (this.channels == null || this.channels.isEmpty()) {
            throw new PubNubException(PubNubErrorBuilder.PNERROBJ_CHANNEL_MISSING);
        }
        if (this.channelsTimetoken == null || this.channelsTimetoken.contains(null)) {
            throw new PubNubException(PubNubErrorBuilder.PNERROBJ_TIMETOKEN_MISSING);
        }
    }

    @Override
    public MessageCountsImpl channels(List<String> channels) {
        this.channels = channels;
        return this;
    }

    @Override
    public MessageCountsImpl channelsTimetoken(List<Long> channelsTimetoken) {
        this.channelsTimetoken = channelsTimetoken;
        return this;
    }
}

