/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.access;

import com.google.gson.JsonElement;
import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.retry.RetryableEndpointGroup;
import com.pubnub.api.v2.BasePNConfiguration;
import com.pubnub.internal.EndpointCore;
import com.pubnub.internal.PubNubCore;
import com.pubnub.internal.PubNubUtilKt;
import com.pubnub.internal.endpoints.access.GrantInterface;
import com.pubnub.internal.managers.MapperManager;
import com.pubnub.internal.models.consumer.access_manager.PNAccessManagerGrantResult;
import com.pubnub.internal.models.consumer.access_manager.PNAccessManagerKeyData;
import com.pubnub.internal.models.consumer.access_manager.PNAccessManagerKeysData;
import com.pubnub.internal.models.server.Envelope;
import com.pubnub.internal.models.server.access_manager.AccessManagerGrantPayload;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0014\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u00012\u00020\u0005B\u009d\u0001\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\t\u0012\b\b\u0002\u0010\f\u001a\u00020\t\u0012\b\b\u0002\u0010\r\u001a\u00020\t\u0012\b\b\u0002\u0010\u000e\u001a\u00020\t\u0012\b\b\u0002\u0010\u000f\u001a\u00020\t\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u000e\b\u0002\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u000e\b\u0002\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\u0002\u0010\u0018J\u001c\u0010(\u001a\u00020)2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140+H\u0002J\u001c\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020.0-2\u0006\u0010/\u001a\u000200H\u0002J\u001c\u00101\u001a\u00020\u00042\u0012\u0010/\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u000202H\u0014J8\u00103\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002042\"\u0010*\u001a\u001e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u001405j\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0014`6H\u0014J\u000e\u00107\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0014J\u000e\u00108\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0014J\b\u00109\u001a\u00020:H\u0014J\b\u0010;\u001a\u00020\tH\u0014J\b\u0010<\u001a\u00020=H\u0016J\b\u0010>\u001a\u00020)H\u0014R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001aR\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001aR\u0014\u0010\f\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\r\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001eR\u0014\u0010\u000f\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001eR\u0014\u0010\u000b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001eR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001eR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010\u000e\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u001eR\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u001aR\u0014\u0010\n\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u001e\u00a8\u0006?"}, d2={"Lcom/pubnub/internal/endpoints/access/GrantEndpoint;", "Lcom/pubnub/internal/EndpointCore;", "Lcom/pubnub/internal/models/server/Envelope;", "Lcom/pubnub/internal/models/server/access_manager/AccessManagerGrantPayload;", "Lcom/pubnub/internal/models/consumer/access_manager/PNAccessManagerGrantResult;", "Lcom/pubnub/internal/endpoints/access/GrantInterface;", "pubnub", "Lcom/pubnub/internal/PubNubCore;", "read", "", "write", "manage", "delete", "get", "update", "join", "ttl", "", "authKeys", "", "", "channels", "channelGroups", "uuids", "(Lcom/pubnub/internal/PubNubCore;ZZZZZZZILjava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getAuthKeys", "()Ljava/util/List;", "getChannelGroups", "getChannels", "getDelete", "()Z", "getGet", "getJoin", "getManage", "getRead", "getTtl", "()I", "getUpdate", "getUuids", "getWrite", "addQueryParams", "", "queryParams", "", "createKeyMap", "", "Lcom/pubnub/internal/models/consumer/access_manager/PNAccessManagerKeyData;", "input", "Lcom/google/gson/JsonElement;", "createResponse", "Lretrofit2/Response;", "doWork", "Lretrofit2/Call;", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getAffectedChannelGroups", "getAffectedChannels", "getEndpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "isAuthRequired", "operationType", "Lcom/pubnub/api/enums/PNOperationType$PNAccessManagerGrant;", "validateParams", "pubnub-core-impl"})
@SourceDebugExtension(value={"SMAP\nGrantEndpoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrantEndpoint.kt\ncom/pubnub/internal/endpoints/access/GrantEndpoint\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,194:1\n215#2,2:195\n215#2,2:197\n*S KotlinDebug\n*F\n+ 1 GrantEndpoint.kt\ncom/pubnub/internal/endpoints/access/GrantEndpoint\n*L\n79#1:195,2\n84#1:197,2\n*E\n"})
public class GrantEndpoint
extends EndpointCore<Envelope<AccessManagerGrantPayload>, PNAccessManagerGrantResult>
implements GrantInterface {
    private final boolean read;
    private final boolean write;
    private final boolean manage;
    private final boolean delete;
    private final boolean get;
    private final boolean update;
    private final boolean join;
    private final int ttl;
    @NotNull
    private final List<String> authKeys;
    @NotNull
    private final List<String> channels;
    @NotNull
    private final List<String> channelGroups;
    @NotNull
    private final List<String> uuids;

    public GrantEndpoint(@NotNull PubNubCore pubnub, boolean read, boolean write, boolean manage, boolean delete, boolean get2, boolean update, boolean join, int ttl, @NotNull List<String> authKeys, @NotNull List<String> channels, @NotNull List<String> channelGroups, @NotNull List<String> uuids) {
        Intrinsics.checkNotNullParameter(pubnub, "pubnub");
        Intrinsics.checkNotNullParameter(authKeys, "authKeys");
        Intrinsics.checkNotNullParameter(channels, "channels");
        Intrinsics.checkNotNullParameter(channelGroups, "channelGroups");
        Intrinsics.checkNotNullParameter(uuids, "uuids");
        super(pubnub);
        this.read = read;
        this.write = write;
        this.manage = manage;
        this.delete = delete;
        this.get = get2;
        this.update = update;
        this.join = join;
        this.ttl = ttl;
        this.authKeys = authKeys;
        this.channels = channels;
        this.channelGroups = channelGroups;
        this.uuids = uuids;
    }

    public /* synthetic */ GrantEndpoint(PubNubCore pubNubCore, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, int n, List list, List list2, List list3, List list4, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            bl2 = false;
        }
        if ((n2 & 8) != 0) {
            bl3 = false;
        }
        if ((n2 & 0x10) != 0) {
            bl4 = false;
        }
        if ((n2 & 0x20) != 0) {
            bl5 = false;
        }
        if ((n2 & 0x40) != 0) {
            bl6 = false;
        }
        if ((n2 & 0x80) != 0) {
            bl7 = false;
        }
        if ((n2 & 0x100) != 0) {
            n = -1;
        }
        if ((n2 & 0x200) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n2 & 0x400) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n2 & 0x800) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        if ((n2 & 0x1000) != 0) {
            list4 = CollectionsKt.emptyList();
        }
        this(pubNubCore, bl, bl2, bl3, bl4, bl5, bl6, bl7, n, list, list2, list3, list4);
    }

    @Override
    public boolean getRead() {
        return this.read;
    }

    @Override
    public boolean getWrite() {
        return this.write;
    }

    @Override
    public boolean getManage() {
        return this.manage;
    }

    @Override
    public boolean getDelete() {
        return this.delete;
    }

    @Override
    public boolean getGet() {
        return this.get;
    }

    @Override
    public boolean getUpdate() {
        return this.update;
    }

    @Override
    public boolean getJoin() {
        return this.join;
    }

    @Override
    public int getTtl() {
        return this.ttl;
    }

    @Override
    @NotNull
    public List<String> getAuthKeys() {
        return this.authKeys;
    }

    @Override
    @NotNull
    public List<String> getChannels() {
        return this.channels;
    }

    @Override
    @NotNull
    public List<String> getChannelGroups() {
        return this.channelGroups;
    }

    @Override
    @NotNull
    public List<String> getUuids() {
        return this.uuids;
    }

    @Override
    protected void validateParams() {
        super.validateParams();
        if (!BasePNConfiguration.Companion.isValid(this.getPubnub().getConfiguration().getSecretKey())) {
            throw new PubNubException(PubNubError.SECRET_KEY_MISSING);
        }
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return this.getChannels();
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannelGroups() {
        return this.getChannelGroups();
    }

    @Override
    @NotNull
    protected Call<Envelope<AccessManagerGrantPayload>> doWork(@NotNull HashMap<String, String> queryParams) {
        Intrinsics.checkNotNullParameter(queryParams, "queryParams");
        this.addQueryParams((Map<String, String>)queryParams);
        return this.getRetrofitManager().getAccessManagerService$pubnub_core_impl().grant(this.getConfiguration().getSubscribeKey(), (Map<String, String>)queryParams);
    }

    @Override
    @NotNull
    protected PNAccessManagerGrantResult createResponse(@NotNull Response<Envelope<AccessManagerGrantPayload>> input) {
        Intrinsics.checkNotNullParameter(input, "input");
        Envelope<AccessManagerGrantPayload> envelope = input.body();
        Intrinsics.checkNotNull(envelope);
        AccessManagerGrantPayload accessManagerGrantPayload = envelope.getPayload$pubnub_core_impl();
        Intrinsics.checkNotNull(accessManagerGrantPayload);
        AccessManagerGrantPayload data = accessManagerGrantPayload;
        Map constructedChannels = new LinkedHashMap();
        Map constructedGroups = new LinkedHashMap();
        String string = data.getChannel$pubnub_core_impl();
        if (string != null) {
            String it = string;
            boolean bl = false;
            Map<String, PNAccessManagerKeyData> map = data.getAuthKeys$pubnub_core_impl();
            Intrinsics.checkNotNull(map);
            constructedChannels.put(it, map);
        }
        if (this.getChannelGroups().size() == 1) {
            String string2 = this.getPubnub().getMapper().elementToString(data.getChannelGroups$pubnub_core_impl());
            Intrinsics.checkNotNull(string2);
            Map<String, PNAccessManagerKeyData> map = data.getAuthKeys$pubnub_core_impl();
            Intrinsics.checkNotNull(map);
            constructedGroups.put(string2, map);
        } else if (this.getChannelGroups().size() > 1) {
            MapperManager mapperManager = this.getPubnub().getMapper();
            JsonElement jsonElement = data.getChannelGroups$pubnub_core_impl();
            Intrinsics.checkNotNull(jsonElement);
            Iterator<Map.Entry<String, JsonElement>> it = mapperManager.getObjectIterator(jsonElement);
            while (it.hasNext()) {
                Map.Entry<String, JsonElement> entry = it.next();
                Intrinsics.checkNotNullExpressionValue(entry, "next()");
                String k = entry.getKey();
                JsonElement v = entry.getValue();
                Intrinsics.checkNotNullExpressionValue(k, "k");
                Intrinsics.checkNotNullExpressionValue(v, "v");
                constructedGroups.put(k, this.createKeyMap(v));
            }
        }
        Map<String, PNAccessManagerKeysData> map = data.getChannels$pubnub_core_impl();
        if (map != null) {
            Map<String, PNAccessManagerKeysData> $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, PNAccessManagerKeysData>> v = $this$forEach$iv.entrySet().iterator();
            while (v.hasNext()) {
                Map.Entry<String, PNAccessManagerKeysData> element$iv;
                Map.Entry<String, PNAccessManagerKeysData> it = element$iv = v.next();
                boolean bl = false;
                String string3 = it.getKey();
                PNAccessManagerKeysData pNAccessManagerKeysData = data.getChannels$pubnub_core_impl().get(it.getKey());
                Intrinsics.checkNotNull(pNAccessManagerKeysData);
                constructedChannels.put(string3, pNAccessManagerKeysData.getAuthKeys());
            }
        }
        Map constructedUuids = new LinkedHashMap();
        Map<String, PNAccessManagerKeysData> map2 = data.getUuids$pubnub_core_impl();
        if (map2 != null) {
            Map<String, PNAccessManagerKeysData> $this$forEach$iv = map2;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, PNAccessManagerKeysData>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, PNAccessManagerKeysData> element$iv;
                Map.Entry<String, PNAccessManagerKeysData> it = element$iv = iterator2.next();
                boolean bl = false;
                String string4 = it.getKey();
                PNAccessManagerKeysData pNAccessManagerKeysData = data.getUuids$pubnub_core_impl().get(it.getKey());
                Intrinsics.checkNotNull(pNAccessManagerKeysData);
                constructedUuids.put(string4, pNAccessManagerKeysData.getAuthKeys());
            }
        }
        String string5 = data.getLevel$pubnub_core_impl();
        Intrinsics.checkNotNull(string5);
        int n = data.getTtl$pubnub_core_impl();
        String string6 = data.getSubscribeKey$pubnub_core_impl();
        Intrinsics.checkNotNull(string6);
        return new PNAccessManagerGrantResult(string5, n, string6, constructedChannels, constructedGroups, constructedUuids);
    }

    @Override
    @NotNull
    public PNOperationType.PNAccessManagerGrant operationType() {
        return PNOperationType.PNAccessManagerGrant;
    }

    @Override
    protected boolean isAuthRequired() {
        return false;
    }

    @Override
    @NotNull
    protected RetryableEndpointGroup getEndpointGroupName() {
        return RetryableEndpointGroup.ACCESS_MANAGER;
    }

    private final Map<String, PNAccessManagerKeyData> createKeyMap(JsonElement input) {
        Map result = new HashMap();
        Iterator<Map.Entry<String, JsonElement>> it = this.getPubnub().getMapper().getObjectIterator(input, "auths");
        while (it.hasNext()) {
            Map.Entry<String, JsonElement> keyMap = it.next();
            PNAccessManagerKeyData pnAccessManagerKeyData = new PNAccessManagerKeyData();
            pnAccessManagerKeyData.setManageEnabled(this.getPubnub().getMapper().getAsBoolean(keyMap.getValue(), "m"));
            pnAccessManagerKeyData.setWriteEnabled(this.getPubnub().getMapper().getAsBoolean(keyMap.getValue(), "w"));
            pnAccessManagerKeyData.setReadEnabled(this.getPubnub().getMapper().getAsBoolean(keyMap.getValue(), "r"));
            pnAccessManagerKeyData.setDeleteEnabled(this.getPubnub().getMapper().getAsBoolean(keyMap.getValue(), "d"));
            pnAccessManagerKeyData.setGetEnabled(this.getPubnub().getMapper().getAsBoolean(keyMap.getValue(), "g"));
            pnAccessManagerKeyData.setUpdateEnabled(this.getPubnub().getMapper().getAsBoolean(keyMap.getValue(), "u"));
            pnAccessManagerKeyData.setJoinEnabled(this.getPubnub().getMapper().getAsBoolean(keyMap.getValue(), "j"));
            result.put(keyMap.getKey(), pnAccessManagerKeyData);
        }
        return result;
    }

    private final void addQueryParams(Map<String, String> queryParams) {
        List<String> $this$addQueryParams_u24lambda_u243 = this.getChannels();
        boolean bl = false;
        if (!((Collection)$this$addQueryParams_u24lambda_u243).isEmpty()) {
            queryParams.put("channel", PubNubUtilKt.toCsv($this$addQueryParams_u24lambda_u243));
        }
        List<String> $this$addQueryParams_u24lambda_u244 = this.getChannelGroups();
        boolean bl2 = false;
        if (!((Collection)$this$addQueryParams_u24lambda_u244).isEmpty()) {
            queryParams.put("channel-group", PubNubUtilKt.toCsv($this$addQueryParams_u24lambda_u244));
        }
        List<String> $this$addQueryParams_u24lambda_u245 = this.getAuthKeys();
        boolean bl3 = false;
        if (!((Collection)$this$addQueryParams_u24lambda_u245).isEmpty()) {
            queryParams.put("auth", PubNubUtilKt.toCsv($this$addQueryParams_u24lambda_u245));
        }
        List<String> $this$addQueryParams_u24lambda_u246 = this.getUuids();
        boolean bl4 = false;
        if (!((Collection)$this$addQueryParams_u24lambda_u246).isEmpty()) {
            queryParams.put("target-uuid", PubNubUtilKt.toCsv($this$addQueryParams_u24lambda_u246));
        }
        if (this.getTtl() >= -1) {
            queryParams.put("ttl", String.valueOf(this.getTtl()));
        }
        queryParams.put("r", this.getRead() ? "1" : "0");
        queryParams.put("w", this.getWrite() ? "1" : "0");
        queryParams.put("m", this.getManage() ? "1" : "0");
        queryParams.put("d", this.getDelete() ? "1" : "0");
        queryParams.put("g", this.getGet() ? "1" : "0");
        queryParams.put("u", this.getUpdate() ? "1" : "0");
        queryParams.put("j", this.getJoin() ? "1" : "0");
    }
}

