/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.files;

import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.models.consumer.files.PNFileUrlResult;
import com.pubnub.api.retry.RetryableEndpointGroup;
import com.pubnub.api.v2.callbacks.Result;
import com.pubnub.internal.EndpointCore;
import com.pubnub.internal.PubNubCore;
import com.pubnub.internal.PubNubUtil;
import com.pubnub.internal.endpoints.files.GetFileUrlInterface;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Request;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004B%\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u001c\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u000e0\rH\u0016J\u0016\u0010\u0014\u001a\u00020\u00032\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016H\u0014J2\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u00182\"\u0010\u0019\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u001aj\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006`\u001bH\u0014J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u001dH\u0014J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u001dH\u0014J\b\u0010\u001f\u001a\u00020 H\u0014J\b\u0010!\u001a\u00020\"H\u0014J\b\u0010#\u001a\u00020\"H\u0014J\b\u0010$\u001a\u00020\"H\u0014J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020\u0012H\u0016J\b\u0010(\u001a\u00020\u0003H\u0016J\b\u0010)\u001a\u00020\u0012H\u0014R\u001a\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u000e0\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/pubnub/internal/endpoints/files/GetFileUrlEndpoint;", "Lcom/pubnub/internal/EndpointCore;", "Lokhttp3/ResponseBody;", "Lcom/pubnub/api/models/consumer/files/PNFileUrlResult;", "Lcom/pubnub/internal/endpoints/files/GetFileUrlInterface;", "channel", "", "fileName", "fileId", "pubNub", "Lcom/pubnub/internal/PubNubCore;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/pubnub/internal/PubNubCore;)V", "cachedCallback", "Ljava/util/function/Consumer;", "Lcom/pubnub/api/v2/callbacks/Result;", "executorService", "Ljava/util/concurrent/ExecutorService;", "async", "", "callback", "createResponse", "input", "Lretrofit2/Response;", "doWork", "Lretrofit2/Call;", "queryParams", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getAffectedChannelGroups", "", "getAffectedChannels", "getEndpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "isAuthRequired", "", "isPubKeyRequired", "isSubKeyRequired", "operationType", "Lcom/pubnub/api/enums/PNOperationType;", "retry", "sync", "validateParams", "pubnub-core-impl"})
public final class GetFileUrlEndpoint
extends EndpointCore<ResponseBody, PNFileUrlResult>
implements GetFileUrlInterface {
    @NotNull
    private final String channel;
    @NotNull
    private final String fileName;
    @NotNull
    private final String fileId;
    private Consumer<Result<PNFileUrlResult>> cachedCallback;
    @NotNull
    private final ExecutorService executorService;

    public GetFileUrlEndpoint(@NotNull String channel, @NotNull String fileName, @NotNull String fileId, @NotNull PubNubCore pubNub) {
        Intrinsics.checkNotNullParameter(channel, "channel");
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        Intrinsics.checkNotNullParameter(fileId, "fileId");
        Intrinsics.checkNotNullParameter(pubNub, "pubNub");
        super(pubNub);
        this.channel = channel;
        this.fileName = fileName;
        this.fileId = fileId;
        ExecutorService executorService = this.getRetrofitManager().getTransactionClientExecutorService();
        if (executorService == null) {
            ExecutorService executorService2 = Executors.newSingleThreadExecutor();
            executorService = executorService2;
            Intrinsics.checkNotNullExpressionValue(executorService2, "newSingleThreadExecutor()");
        }
        this.executorService = executorService;
    }

    @Override
    protected void validateParams() throws PubNubException {
        super.validateParams();
        if (((CharSequence)this.channel).length() == 0) {
            throw new PubNubException(PubNubError.CHANNEL_MISSING);
        }
    }

    @Override
    @NotNull
    public PNFileUrlResult sync() throws PubNubException {
        PNFileUrlResult pNFileUrlResult;
        try {
            Map baseParams = this.createBaseParams();
            Call<ResponseBody> call = this.getRetrofitManager().getFilesService$pubnub_core_impl().downloadFile(this.getConfiguration().getSubscribeKey(), this.channel, this.fileId, this.fileName, baseParams);
            Request request = call.request();
            Intrinsics.checkNotNullExpressionValue(request, "call.request()");
            Request signedRequest = PubNubUtil.INSTANCE.signRequest(request, this.getPubnub().getConfiguration(), PubNubCore.Companion.timestamp());
            pNFileUrlResult = new PNFileUrlResult(signedRequest.url().toString());
        }
        catch (Exception e) {
            throw new PubNubException(e.getMessage(), null, null, 0, null, null, null, null, null, null, null, 2046, null);
        }
        return pNFileUrlResult;
    }

    @Override
    public void async(@NotNull Consumer<Result<PNFileUrlResult>> callback) {
        Intrinsics.checkNotNullParameter(callback, "callback");
        this.cachedCallback = callback;
        this.executorService.execute(() -> GetFileUrlEndpoint.async$lambda$0(this, callback));
    }

    @Override
    @NotNull
    protected Call<ResponseBody> doWork(@NotNull HashMap<String, String> queryParams) throws PubNubException {
        Intrinsics.checkNotNullParameter(queryParams, "queryParams");
        throw new PubNubException(PubNubError.INTERNAL_ERROR);
    }

    @Override
    @NotNull
    protected PNFileUrlResult createResponse(@NotNull Response<ResponseBody> input) throws PubNubException {
        Intrinsics.checkNotNullParameter(input, "input");
        throw new PubNubException(PubNubError.INTERNAL_ERROR);
    }

    @Override
    public void retry() {
        Consumer<Result<PNFileUrlResult>> consumer = this.cachedCallback;
        if (consumer == null) {
            Intrinsics.throwUninitializedPropertyAccessException("cachedCallback");
            consumer = null;
        }
        this.async(consumer);
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return CollectionsKt.listOf(this.channel);
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannelGroups() {
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public PNOperationType operationType() {
        return PNOperationType.FileOperation;
    }

    @Override
    protected boolean isAuthRequired() {
        return true;
    }

    @Override
    protected boolean isSubKeyRequired() {
        return true;
    }

    @Override
    protected boolean isPubKeyRequired() {
        return false;
    }

    @Override
    @NotNull
    protected RetryableEndpointGroup getEndpointGroupName() {
        return RetryableEndpointGroup.FILE_PERSISTENCE;
    }

    private static final void async$lambda$0(GetFileUrlEndpoint this$0, Consumer $callback) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($callback, "$callback");
        try {
            PNFileUrlResult res = this$0.sync();
            $callback.accept(Result.Companion.success(res));
        }
        catch (PubNubException ex) {
            $callback.accept(Result.Companion.failure(ex));
        }
    }
}

