/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.files;

import com.pubnub.api.endpoints.BuilderSteps;
import com.pubnub.api.endpoints.files.SendFile;
import com.pubnub.api.endpoints.files.requiredparambuilder.FilesBuilderSteps;
import com.pubnub.api.endpoints.remoteaction.ExtendedRemoteAction;
import com.pubnub.api.models.consumer.files.PNFileUploadResult;
import com.pubnub.internal.PubNubCore;
import com.pubnub.internal.endpoints.IdentityMappingAction;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;

public class SendFileImpl
extends IdentityMappingAction<PNFileUploadResult>
implements SendFile {
    private final String channel;
    private final String fileName;
    private final InputStream inputStream;
    private Object message;
    private Object meta;
    private Integer ttl;
    private Boolean shouldStore;
    private String cipherKey;

    public SendFileImpl(PubNubCore pubnub, String channel, String fileName, InputStream inputStream2) {
        super(pubnub);
        this.channel = channel;
        this.fileName = fileName;
        this.inputStream = inputStream2;
    }

    @Override
    @NotNull
    protected ExtendedRemoteAction<PNFileUploadResult> createAction() {
        return this.pubnub.sendFile(this.channel, this.fileName, this.inputStream, this.message, this.meta, this.ttl, this.shouldStore, this.cipherKey);
    }

    @Override
    public SendFileImpl message(Object message) {
        this.message = message;
        return this;
    }

    @Override
    public SendFileImpl meta(Object meta) {
        this.meta = meta;
        return this;
    }

    @Override
    public SendFileImpl ttl(Integer ttl) {
        this.ttl = ttl;
        return this;
    }

    @Override
    public SendFileImpl shouldStore(Boolean shouldStore) {
        this.shouldStore = shouldStore;
        return this;
    }

    @Override
    public SendFileImpl cipherKey(String cipherKey) {
        this.cipherKey = cipherKey;
        return this;
    }

    public static class Builder
    implements SendFile.Builder {
        private final PubNubCore pubnub;

        public Builder(PubNubCore pubnub) {
            this.pubnub = pubnub;
        }

        @Override
        public FilesBuilderSteps.FileNameStep<FilesBuilderSteps.InputStreamStep<SendFile>> channel(String channel) {
            return new InnerBuilder(this.pubnub).channel(channel);
        }

        public static class InnerBuilder
        implements BuilderSteps.ChannelStep<FilesBuilderSteps.FileNameStep<FilesBuilderSteps.InputStreamStep<SendFile>>>,
        FilesBuilderSteps.FileNameStep<FilesBuilderSteps.InputStreamStep<SendFile>>,
        FilesBuilderSteps.InputStreamStep<SendFile> {
            private final PubNubCore pubnub;
            private String channelValue;
            private String fileNameValue;

            private InnerBuilder(PubNubCore pubnub) {
                this.pubnub = pubnub;
            }

            @Override
            public FilesBuilderSteps.FileNameStep<FilesBuilderSteps.InputStreamStep<SendFile>> channel(String channel) {
                this.channelValue = channel;
                return this;
            }

            @Override
            public FilesBuilderSteps.InputStreamStep<SendFile> fileName(String fileName) {
                this.fileNameValue = fileName;
                return this;
            }

            @Override
            public SendFile inputStream(InputStream inputStream2) {
                return new SendFileImpl(this.pubnub, this.channelValue, this.fileNameValue, inputStream2);
            }
        }
    }
}

