/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.objects_api.memberships;

import com.pubnub.api.endpoints.objects_api.memberships.ManageMemberships;
import com.pubnub.api.endpoints.objects_api.utils.Include;
import com.pubnub.api.endpoints.objects_api.utils.ObjectsBuilderSteps;
import com.pubnub.api.endpoints.objects_api.utils.PNSortKey;
import com.pubnub.api.endpoints.remoteaction.ExtendedRemoteAction;
import com.pubnub.api.endpoints.remoteaction.MappingRemoteAction;
import com.pubnub.api.models.consumer.objects.PNPage;
import com.pubnub.api.models.consumer.objects_api.membership.PNChannelMembership;
import com.pubnub.api.models.consumer.objects_api.membership.PNManageMembershipResult;
import com.pubnub.internal.EndpointInterface;
import com.pubnub.internal.PubNubCore;
import com.pubnub.internal.endpoints.DelegatingEndpoint;
import com.pubnub.internal.endpoints.objects_api.memberships.SetMembershipsImpl;
import com.pubnub.internal.models.consumer.objects.membership.PNChannelMembership;
import com.pubnub.internal.models.consumer.objects.membership.PNChannelMembershipArrayResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class ManageMembershipsImpl
extends DelegatingEndpoint<PNChannelMembershipArrayResult, PNManageMembershipResult>
implements ManageMemberships {
    private Collection<PNChannelMembership> set;
    private Collection<PNChannelMembership> remove;
    private String uuid;
    private Integer limit;
    private PNPage page;
    private String filter;
    private Collection<PNSortKey> sort = Collections.emptyList();
    private boolean includeTotalCount;
    private boolean includeCustom;
    private Include.PNChannelDetailsLevel includeChannel;

    public ManageMembershipsImpl(Collection<PNChannelMembership> channelsToSet, Collection<PNChannelMembership> channelsToRemove, PubNubCore pubnubInstance) {
        super(pubnubInstance);
        this.set = channelsToSet;
        this.remove = channelsToRemove;
    }

    @Override
    @NotNull
    protected ExtendedRemoteAction<PNManageMembershipResult> mapResult(@NotNull ExtendedRemoteAction<PNChannelMembershipArrayResult> action) {
        return new MappingRemoteAction<PNChannelMembershipArrayResult, PNManageMembershipResult>(action, PNManageMembershipResult::from);
    }

    @Override
    @NotNull
    protected EndpointInterface<PNChannelMembershipArrayResult> createAction() {
        ArrayList<PNChannelMembership.Partial> toSet = new ArrayList<PNChannelMembership.Partial>(this.set.size());
        for (PNChannelMembership channel : this.set) {
            toSet.add(new PNChannelMembership.Partial(channel.getChannel().getId(), channel instanceof PNChannelMembership.ChannelWithCustom ? ((PNChannelMembership.ChannelWithCustom)channel).getCustom() : null, null));
        }
        ArrayList<String> toRemove = new ArrayList<String>(this.remove.size());
        for (PNChannelMembership channel : this.remove) {
            toRemove.add(channel.getChannel().getId());
        }
        return this.pubnub.manageMemberships(toSet, toRemove, this.uuid, this.limit, this.page, this.filter, SetMembershipsImpl.toInternal(this.sort), this.includeTotalCount, this.includeCustom, SetMembershipsImpl.toInternal(this.includeChannel));
    }

    @Override
    public ManageMembershipsImpl set(Collection<PNChannelMembership> set) {
        this.set = set;
        return this;
    }

    @Override
    public ManageMembershipsImpl remove(Collection<PNChannelMembership> remove) {
        this.remove = remove;
        return this;
    }

    @Override
    public ManageMembershipsImpl uuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    @Override
    public ManageMembershipsImpl limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public ManageMembershipsImpl page(PNPage page) {
        this.page = page;
        return this;
    }

    @Override
    public ManageMembershipsImpl filter(String filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public ManageMembershipsImpl sort(Collection<PNSortKey> sort) {
        this.sort = sort;
        return this;
    }

    @Override
    public ManageMembershipsImpl includeTotalCount(boolean includeTotalCount) {
        this.includeTotalCount = includeTotalCount;
        return this;
    }

    @Override
    public ManageMembershipsImpl includeCustom(boolean includeCustom) {
        this.includeCustom = includeCustom;
        return this;
    }

    @Override
    public ManageMembershipsImpl includeChannel(Include.PNChannelDetailsLevel includeChannel) {
        this.includeChannel = includeChannel;
        return this;
    }

    public static class Builder
    implements ManageMemberships.Builder {
        private final PubNubCore pubnubInstance;

        @Override
        public ObjectsBuilderSteps.RemoveOrSetStep.RemoveStep<ManageMemberships, PNChannelMembership> set(final Collection<PNChannelMembership> channelsToSet) {
            return new ObjectsBuilderSteps.RemoveOrSetStep.RemoveStep<ManageMemberships, PNChannelMembership>(){

                @Override
                public ManageMemberships remove(Collection<PNChannelMembership> channelsToRemove) {
                    return new ManageMembershipsImpl(channelsToSet, channelsToRemove, pubnubInstance);
                }
            };
        }

        @Override
        public ObjectsBuilderSteps.RemoveOrSetStep.SetStep<ManageMemberships, PNChannelMembership> remove(final Collection<PNChannelMembership> channelsToRemove) {
            return new ObjectsBuilderSteps.RemoveOrSetStep.SetStep<ManageMemberships, PNChannelMembership>(){

                @Override
                public ManageMemberships set(Collection<PNChannelMembership> channelsToSet) {
                    return new ManageMembershipsImpl(channelsToSet, channelsToRemove, pubnubInstance);
                }
            };
        }

        public Builder(PubNubCore pubnubInstance) {
            this.pubnubInstance = pubnubInstance;
        }
    }
}

