/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.retry;

import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.retry.RetryConfiguration;
import com.pubnub.api.retry.RetryableEndpointGroup;
import com.pubnub.internal.PubNubRetryableException;
import com.pubnub.internal.retry.RetryableBase;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ!\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bH\u0000\u00a2\u0006\u0002\b\u0016J\"\u0010\u0017\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0014\u0012\f\u0012\n\u0018\u00010\u0019j\u0004\u0018\u0001`\u001a0\u0018H\u0002J\u0014\u0010\u001b\u001a\u00020\b2\n\u0010\u001c\u001a\u00060\u0019j\u0002`\u001aH\u0002J\u0016\u0010\u001d\u001a\u00020\b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014H\u0002R \u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/pubnub/internal/retry/RetryableRestCaller;", "T", "Lcom/pubnub/internal/retry/RetryableBase;", "retryConfiguration", "Lcom/pubnub/api/retry/RetryConfiguration;", "endpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "isEndpointRetryable", "", "(Lcom/pubnub/api/retry/RetryConfiguration;Lcom/pubnub/api/retry/RetryableEndpointGroup;Z)V", "call", "Lretrofit2/Call;", "getCall$pubnub_core_impl", "()Lretrofit2/Call;", "setCall$pubnub_core_impl", "(Lretrofit2/Call;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "execute", "Lretrofit2/Response;", "callToBeExecuted", "execute$pubnub_core_impl", "executeRestCall", "Lkotlin/Pair;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "isExceptionRetryable", "e", "shouldRetry", "response", "pubnub-core-impl"})
@SourceDebugExtension(value={"SMAP\nRetryableRestCaller.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RetryableRestCaller.kt\ncom/pubnub/internal/retry/RetryableRestCaller\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n1747#2,3:87\n*S KotlinDebug\n*F\n+ 1 RetryableRestCaller.kt\ncom/pubnub/internal/retry/RetryableRestCaller\n*L\n77#1:87,3\n*E\n"})
public final class RetryableRestCaller<T>
extends RetryableBase<T> {
    private final boolean isEndpointRetryable;
    private final Logger log;
    public Call<T> call;

    public RetryableRestCaller(@NotNull RetryConfiguration retryConfiguration, @NotNull RetryableEndpointGroup endpointGroupName, boolean isEndpointRetryable) {
        Intrinsics.checkNotNullParameter(retryConfiguration, "retryConfiguration");
        Intrinsics.checkNotNullParameter((Object)endpointGroupName, "endpointGroupName");
        super(retryConfiguration, endpointGroupName);
        this.isEndpointRetryable = isEndpointRetryable;
        this.log = LoggerFactory.getLogger((String)this.getClass().getSimpleName());
    }

    @NotNull
    public final Call<T> getCall$pubnub_core_impl() {
        Call<T> call = this.call;
        if (call != null) {
            return call;
        }
        Intrinsics.throwUninitializedPropertyAccessException("call");
        return null;
    }

    public final void setCall$pubnub_core_impl(@NotNull Call<T> call) {
        Intrinsics.checkNotNullParameter(call, "<set-?>");
        this.call = call;
    }

    @NotNull
    public final Response<T> execute$pubnub_core_impl(@NotNull Call<T> callToBeExecuted) {
        Intrinsics.checkNotNullParameter(callToBeExecuted, "callToBeExecuted");
        this.setCall$pubnub_core_impl(callToBeExecuted);
        int numberOfAttempts = 0;
        while (true) {
            Pair<Response<T>, Exception> pair = this.executeRestCall();
            Response<T> response = pair.component1();
            Exception exception = pair.component2();
            if (!this.shouldRetry(response) || numberOfAttempts++ >= this.getMaxRetryNumberFromConfiguration()) {
                if (response.isSuccessful() || exception == null) {
                    return response;
                }
                throw exception;
            }
            int randomDelayInMillis = this.getRandom().nextInt(1000);
            long effectiveDelayInMillis = Duration.getInWholeMilliseconds-impl(this.getDelayBasedOnResponse-5sfh64U$pubnub_core_impl(response)) + (long)randomDelayInMillis;
            this.log.trace("Added random delay so effective retry delay is " + effectiveDelayInMillis);
            Thread.sleep(effectiveDelayInMillis);
            Call<T> call = this.getCall$pubnub_core_impl().clone();
            Intrinsics.checkNotNullExpressionValue(call, "call.clone()");
            this.setCall$pubnub_core_impl(call);
        }
    }

    private final Pair<Response<T>, Exception> executeRestCall() {
        Exception pubNubException = null;
        try {
            Object response;
            try {
                response = this.getCall$pubnub_core_impl().execute();
                response = new Pair<Response<T>, Object>(response, pubNubException);
            }
            catch (Exception e) {
                PubNubError pubNubError = PubNubError.PARSING_ERROR;
                String string = e.toString();
                Call<T> call = this.getCall$pubnub_core_impl();
                pubNubException = new PubNubException(string, pubNubError, null, 0, call, null, null, null, null, null, null, 2028, null);
                if (this.isExceptionRetryable(e)) {
                    pubNubError = PubNubError.CONNECT_EXCEPTION;
                    string = e.toString();
                    throw new PubNubRetryableException(string, pubNubError, 503);
                }
                throw pubNubException;
            }
            return response;
        }
        catch (PubNubRetryableException e) {
            int n = e.getStatusCode();
            Object object = e.getErrorMessage();
            if (object == null || (object = ResponseBody.Companion.create$default(ResponseBody.Companion, (String)object, null, 1, null)) == null) {
                object = ResponseBody.Companion.create$default(ResponseBody.Companion, "", null, 1, null);
            }
            return new Pair(Response.error(n, (ResponseBody)object), pubNubException);
        }
    }

    private final boolean isExceptionRetryable(Exception e) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = RetryableBase.Companion.getRetryableExceptions$pubnub_core_impl();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Class it = (Class)element$iv;
                    boolean bl2 = false;
                    if (!it.isInstance(e)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean shouldRetry(Response<T> response) {
        return !response.isSuccessful() && this.isErrorCodeRetryable(response.raw().code()) && this.isRetryConfSetForThisRestCall$pubnub_core_impl() && this.isEndpointRetryable;
    }
}

