/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.vendor;

import com.pubnub.api.v2.BasePNConfiguration;
import com.pubnub.internal.PubNubCore;
import com.pubnub.internal.PubNubUtil;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;

public class AppEngineFactory
implements Call {
    private Request request;
    private final BasePNConfiguration configuration;

    AppEngineFactory(Request request, BasePNConfiguration configuration) {
        this.request = request;
        this.configuration = configuration;
    }

    @Override
    @NotNull
    public Request request() {
        return this.request;
    }

    @Override
    @NotNull
    public Response execute() throws IOException {
        this.request = PubNubUtil.INSTANCE.signRequest(this.request, this.configuration, PubNubCore.timestamp());
        URL url = this.request.url().url();
        final HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setUseCaches(false);
        connection.setDoOutput(true);
        connection.setRequestMethod(this.request.method());
        Headers headers = this.request.headers();
        if (headers != null) {
            for (int i = 0; i < headers.size(); ++i) {
                String name = headers.name(i);
                connection.setRequestProperty(name, headers.get(name));
            }
        }
        if (this.request.body() != null) {
            BufferedSink outbuf = Okio.buffer(Okio.sink(connection.getOutputStream()));
            this.request.body().writeTo(outbuf);
            outbuf.close();
        }
        connection.connect();
        final BufferedSource source2 = Okio.buffer(Okio.source(connection.getInputStream()));
        if (connection.getResponseCode() != 200) {
            throw new IOException("Fail to call  :: " + source2.readUtf8());
        }
        Response response = new Response.Builder().code(connection.getResponseCode()).message(connection.getResponseMessage()).request(this.request).protocol(Protocol.HTTP_1_1).body(new ResponseBody(){

            @Override
            public MediaType contentType() {
                return MediaType.parse(connection.getContentType());
            }

            @Override
            public long contentLength() {
                long contentLength;
                String contentLengthField = connection.getHeaderField("content-length");
                try {
                    contentLength = Long.parseLong(contentLengthField);
                }
                catch (NumberFormatException ignored) {
                    contentLength = -1L;
                }
                return contentLength;
            }

            @Override
            public BufferedSource source() {
                return source2;
            }
        }).build();
        return response;
    }

    @Override
    public void enqueue(Callback responseCallback) {
    }

    @Override
    public void cancel() {
    }

    @Override
    public boolean isExecuted() {
        return false;
    }

    @Override
    public boolean isCanceled() {
        return false;
    }

    @Override
    @NotNull
    public Timeout timeout() {
        return Timeout.NONE;
    }

    @Override
    @NotNull
    public Call clone() {
        try {
            return (Call)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public static class Factory
    implements Call.Factory {
        private final BasePNConfiguration configuration;

        public Factory(BasePNConfiguration configuration) {
            this.configuration = configuration;
        }

        @Override
        @NotNull
        public Call newCall(Request request) {
            return new AppEngineFactory(request, this.configuration);
        }
    }
}

