/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.component;

public class ApiMethodArg {
    private final String name;
    private final Class<?> type;
    private final String typeArgs;
    private final String rawTypeArgs;
    private final String description;

    public ApiMethodArg(String name, Class<?> type, String typeArgs, String rawTypeArgs, String description) {
        this.name = name;
        this.type = type;
        this.typeArgs = typeArgs;
        this.rawTypeArgs = rawTypeArgs;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getTypeArgs() {
        return this.typeArgs;
    }

    public String getRawTypeArgs() {
        return this.rawTypeArgs;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder(128);
        builder2.append(this.type.getCanonicalName());
        if (this.typeArgs != null) {
            builder2.append("<").append(this.typeArgs).append(">");
        }
        builder2.append(" ").append(this.name);
        return builder2.toString();
    }

    public static ApiMethodArg arg(String name, Class<?> type) {
        return new ApiMethodArg(name, type, null, null, null);
    }

    public static ApiMethodArg arg(String name, Class<?> type, String typeArgs) {
        return new ApiMethodArg(name, type, typeArgs, null, null);
    }

    public static ApiMethodArg arg(String name, Class<?> type, String typeArgs, String description) {
        return new ApiMethodArg(name, type, typeArgs, null, description);
    }
}

