/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.jsse;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import org.apache.camel.CamelContext;
import org.apache.camel.support.jsse.AliasedX509ExtendedKeyManager;
import org.apache.camel.support.jsse.BaseSSLContextParameters;
import org.apache.camel.support.jsse.KeyManagersParameters;
import org.apache.camel.support.jsse.SSLContextClientParameters;
import org.apache.camel.support.jsse.SSLContextServerParameters;
import org.apache.camel.support.jsse.SecureRandomParameters;
import org.apache.camel.support.jsse.TrustManagersParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLContextParameters
extends BaseSSLContextParameters {
    protected static final String DEFAULT_SECURE_SOCKET_PROTOCOL = "TLSv1.3";
    private static final Logger LOG = LoggerFactory.getLogger(SSLContextParameters.class);
    private KeyManagersParameters keyManagers;
    private TrustManagersParameters trustManagers;
    private SecureRandomParameters secureRandom;
    private SSLContextClientParameters clientParameters;
    private SSLContextServerParameters serverParameters;
    private String provider;
    private String secureSocketProtocol;
    private String certAlias;

    public KeyManagersParameters getKeyManagers() {
        return this.keyManagers;
    }

    public void setKeyManagers(KeyManagersParameters keyManagers) {
        this.keyManagers = keyManagers;
    }

    public TrustManagersParameters getTrustManagers() {
        return this.trustManagers;
    }

    public void setTrustManagers(TrustManagersParameters trustManagers) {
        this.trustManagers = trustManagers;
    }

    public SecureRandomParameters getSecureRandom() {
        return this.secureRandom;
    }

    public void setSecureRandom(SecureRandomParameters secureRandom) {
        this.secureRandom = secureRandom;
    }

    public SSLContextClientParameters getClientParameters() {
        return this.clientParameters;
    }

    public void setClientParameters(SSLContextClientParameters clientParameters) {
        this.clientParameters = clientParameters;
    }

    public SSLContextServerParameters getServerParameters() {
        return this.serverParameters;
    }

    public void setServerParameters(SSLContextServerParameters serverParameters) {
        this.serverParameters = serverParameters;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getSecureSocketProtocol() {
        if (this.secureSocketProtocol == null) {
            return DEFAULT_SECURE_SOCKET_PROTOCOL;
        }
        return this.secureSocketProtocol;
    }

    public void setSecureSocketProtocol(String secureSocketProtocol) {
        this.secureSocketProtocol = secureSocketProtocol;
    }

    public String getCertAlias() {
        return this.certAlias;
    }

    public void setCertAlias(String certAlias) {
        this.certAlias = certAlias;
    }

    public SSLContext createSSLContext(CamelContext camelContext) throws GeneralSecurityException, IOException {
        if (camelContext != null) {
            this.setCamelContext(camelContext);
            if (this.keyManagers != null) {
                this.keyManagers.setCamelContext(camelContext);
                if (this.keyManagers.getKeyStore() != null) {
                    this.keyManagers.getKeyStore().setCamelContext(camelContext);
                }
            }
            if (this.trustManagers != null) {
                this.trustManagers.setCamelContext(camelContext);
                if (this.trustManagers.getKeyStore() != null) {
                    this.trustManagers.getKeyStore().setCamelContext(camelContext);
                }
            }
            if (this.secureRandom != null) {
                this.secureRandom.setCamelContext(camelContext);
            }
            if (this.clientParameters != null) {
                this.clientParameters.setCamelContext(camelContext);
            }
            if (this.serverParameters != null) {
                this.serverParameters.setCamelContext(camelContext);
            }
        }
        LOG.trace("Creating SSLContext from SSLContextParameters [{}].", (Object)this);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Available Security providers: {}.", (Object)Arrays.toString(Security.getProviders()));
        }
        KeyManager[] keyManagers = this.keyManagers == null ? null : this.keyManagers.createKeyManagers();
        TrustManager[] trustManagers = this.trustManagers == null ? null : this.trustManagers.createTrustManagers();
        SecureRandom secureRandom = this.secureRandom == null ? null : this.secureRandom.createSecureRandom();
        SSLContext context = this.getProvider() == null ? SSLContext.getInstance(this.parsePropertyValue(this.getSecureSocketProtocol())) : SSLContext.getInstance(this.parsePropertyValue(this.getSecureSocketProtocol()), this.parsePropertyValue(this.getProvider()));
        if (this.getCertAlias() != null && keyManagers != null) {
            for (int idx = 0; idx < keyManagers.length; ++idx) {
                KeyManager keyManager = keyManagers[idx];
                if (!(keyManager instanceof X509KeyManager)) continue;
                X509KeyManager x509KeyManager = (X509KeyManager)keyManager;
                try {
                    keyManagers[idx] = new AliasedX509ExtendedKeyManager(this.parsePropertyValue(this.getCertAlias()), x509KeyManager);
                    continue;
                }
                catch (Exception e) {
                    throw new GeneralSecurityException(e);
                }
            }
        }
        LOG.debug("SSLContext [{}], initialized from [{}], is using provider [{}], protocol [{}], key managers {}, trust managers {}, and secure random [{}].", new Object[]{context, this, context.getProvider(), context.getProtocol(), keyManagers, trustManagers, secureRandom});
        context.init(keyManagers, trustManagers, secureRandom);
        this.configureSSLContext(context);
        context = new BaseSSLContextParameters.SSLContextDecorator(new BaseSSLContextParameters.SSLContextSpiDecorator(context, this.getSSLEngineConfigurers(context), this.getSSLSocketFactoryConfigurers(context), this.getSSLServerSocketFactoryConfigurers(context)));
        return context;
    }

    @Override
    protected void configureSSLContext(SSLContext context) throws GeneralSecurityException {
        LOG.trace("Configuring client and server side SSLContext parameters on SSLContext [{}]...", (Object)context);
        super.configureSSLContext(context);
        if (this.getClientParameters() != null) {
            LOG.trace("Overriding client-side SSLContext parameters on SSLContext [{}] with configured client parameters.", (Object)context);
            this.getClientParameters().configureSSLContext(context);
        }
        if (this.getServerParameters() != null) {
            LOG.trace("Overriding server-side SSLContext parameters on SSLContext [{}] with configured server parameters.", (Object)context);
            this.getServerParameters().configureSSLContext(context);
        }
        LOG.trace("Configured client and server side SSLContext parameters on SSLContext [{}].", (Object)context);
    }

    @Override
    protected List<BaseSSLContextParameters.Configurer<SSLEngine>> getSSLEngineConfigurers(SSLContext context) {
        LOG.trace("Collecting client and server side SSLEngine configurers on SSLContext [{}]...", (Object)context);
        List<BaseSSLContextParameters.Configurer<SSLEngine>> configurers = super.getSSLEngineConfigurers(context);
        if (this.getClientParameters() != null) {
            LOG.trace("Augmenting SSLEngine configurers with configurers from client parameters on SSLContext [{}].", (Object)context);
            configurers.addAll(this.getClientParameters().getSSLEngineConfigurers(context));
        }
        if (this.getServerParameters() != null) {
            LOG.trace("Augmenting SSLEngine configurers with configurers from server parameters on SSLContext [{}].", (Object)context);
            configurers.addAll(this.getServerParameters().getSSLEngineConfigurers(context));
        }
        LOG.trace("Collected client and server side SSLEngine configurers on SSLContext [{}].", (Object)context);
        return configurers;
    }

    @Override
    protected List<BaseSSLContextParameters.Configurer<SSLSocketFactory>> getSSLSocketFactoryConfigurers(SSLContext context) {
        LOG.trace("Collecting SSLSocketFactory configurers on SSLContext [{}]...", (Object)context);
        List<BaseSSLContextParameters.Configurer<SSLSocketFactory>> configurers = super.getSSLSocketFactoryConfigurers(context);
        if (this.getClientParameters() != null) {
            LOG.trace("Augmenting SSLSocketFactory configurers with configurers from client parameters on SSLContext [{}].", (Object)context);
            configurers.addAll(this.getClientParameters().getSSLSocketFactoryConfigurers(context));
        }
        LOG.trace("Collected SSLSocketFactory configurers on SSLContext [{}].", (Object)context);
        return configurers;
    }

    @Override
    protected List<BaseSSLContextParameters.Configurer<SSLServerSocketFactory>> getSSLServerSocketFactoryConfigurers(SSLContext context) {
        LOG.trace("Collecting SSLServerSocketFactory configurers for SSLContext [{}]...", (Object)context);
        List<BaseSSLContextParameters.Configurer<SSLServerSocketFactory>> configurers = super.getSSLServerSocketFactoryConfigurers(context);
        if (this.getServerParameters() != null) {
            LOG.trace("Augmenting SSLServerSocketFactory configurers with configurers from server parameters for SSLContext [{}].", (Object)context);
            configurers.addAll(this.getServerParameters().getSSLServerSocketFactoryConfigurers(context));
        }
        LOG.trace("Collected client and server side SSLServerSocketFactory configurers for SSLContext [{}].", (Object)context);
        return configurers;
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        builder2.append("SSLContextParameters[keyManagers=");
        builder2.append(this.keyManagers);
        builder2.append(", trustManagers=");
        builder2.append(this.trustManagers);
        builder2.append(", secureRandom=");
        builder2.append(this.secureRandom);
        builder2.append(", clientParameters=");
        builder2.append(this.clientParameters);
        builder2.append(", serverParameters=");
        builder2.append(this.serverParameters);
        builder2.append(", provider=");
        builder2.append(this.provider);
        builder2.append(", secureSocketProtocol=");
        builder2.append(this.secureSocketProtocol);
        builder2.append(", certAlias=");
        builder2.append(this.certAlias);
        builder2.append(", getCipherSuites()=");
        builder2.append(this.getCipherSuites());
        builder2.append(", getCipherSuitesFilter()=");
        builder2.append(this.getCipherSuitesFilter());
        builder2.append(", getSecureSocketProtocols()=");
        builder2.append(this.getSecureSocketProtocols());
        builder2.append(", getSecureSocketProtocolsFilter()=");
        builder2.append(this.getSecureSocketProtocolsFilter());
        builder2.append(", getSessionTimeout()=");
        builder2.append(this.getSessionTimeout());
        builder2.append("]");
        return builder2.toString();
    }
}

