/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.jsse;

import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.support.jsse.BaseSSLContextParameters;
import org.apache.camel.support.jsse.ClientAuthentication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLContextServerParameters
extends BaseSSLContextParameters {
    private static final Logger LOG = LoggerFactory.getLogger(SSLContextServerParameters.class);
    protected String clientAuthentication;

    public String getClientAuthentication() {
        return this.clientAuthentication;
    }

    public void setClientAuthentication(String value) {
        this.clientAuthentication = value;
    }

    @Override
    protected boolean getAllowPassthrough() {
        return true;
    }

    @Override
    protected void configureSSLContext(SSLContext context) throws GeneralSecurityException {
        LOG.trace("Configuring server-side SSLContext parameters on SSLContext [{}]...", (Object)context);
        if (this.getSessionTimeout() != null) {
            LOG.debug("Configuring server-side SSLContext session timeout on SSLContext [{}] to [{}].", (Object)context, (Object)this.getSessionTimeout());
            this.configureSessionContext(context.getServerSessionContext(), this.getSessionTimeout());
        }
        LOG.trace("Configured server-side SSLContext parameters on SSLContext [{}].", (Object)context);
    }

    @Override
    protected List<BaseSSLContextParameters.Configurer<SSLEngine>> getSSLEngineConfigurers(SSLContext context) {
        LinkedList<BaseSSLContextParameters.Configurer<SSLEngine>> sslEngineConfigurers = new LinkedList<BaseSSLContextParameters.Configurer<SSLEngine>>();
        if (this.getClientAuthentication() != null) {
            final ClientAuthentication clientAuthValue = ClientAuthentication.valueOf(this.parsePropertyValue(this.getClientAuthentication()));
            BaseSSLContextParameters.Configurer<SSLEngine> sslEngineConfigurer = new BaseSSLContextParameters.Configurer<SSLEngine>(){

                @Override
                public SSLEngine configure(SSLEngine engine) {
                    LOG.trace("Configuring client-auth on SSLEngine [{}] to [{}].", (Object)engine, (Object)clientAuthValue);
                    switch (clientAuthValue) {
                        case NONE: {
                            engine.setWantClientAuth(false);
                            engine.setNeedClientAuth(false);
                            break;
                        }
                        case WANT: {
                            engine.setWantClientAuth(true);
                            break;
                        }
                        case REQUIRE: {
                            engine.setNeedClientAuth(true);
                            break;
                        }
                        default: {
                            throw new RuntimeCamelException("Unknown ClientAuthentication value: " + String.valueOf((Object)clientAuthValue));
                        }
                    }
                    return engine;
                }
            };
            sslEngineConfigurers.add(sslEngineConfigurer);
        }
        return sslEngineConfigurers;
    }

    @Override
    protected List<BaseSSLContextParameters.Configurer<SSLServerSocket>> getSSLServerSocketFactorySSLServerSocketConfigurers(SSLContext context) {
        List<BaseSSLContextParameters.Configurer<SSLServerSocket>> sslServerSocketConfigurers = super.getSSLServerSocketFactorySSLServerSocketConfigurers(context);
        if (this.getClientAuthentication() != null) {
            final ClientAuthentication clientAuthValue = ClientAuthentication.valueOf(this.parsePropertyValue(this.getClientAuthentication()));
            BaseSSLContextParameters.Configurer<SSLServerSocket> sslServerSocketConfigurer = new BaseSSLContextParameters.Configurer<SSLServerSocket>(){

                @Override
                public SSLServerSocket configure(SSLServerSocket socket) {
                    LOG.trace("Configuring client-auth on SSLServerSocket [{}] to [{}].", (Object)socket, (Object)clientAuthValue);
                    switch (clientAuthValue) {
                        case NONE: {
                            socket.setWantClientAuth(false);
                            socket.setNeedClientAuth(false);
                            break;
                        }
                        case WANT: {
                            socket.setWantClientAuth(true);
                            break;
                        }
                        case REQUIRE: {
                            socket.setNeedClientAuth(true);
                            break;
                        }
                        default: {
                            throw new RuntimeCamelException("Unknown ClientAuthentication value: " + String.valueOf((Object)clientAuthValue));
                        }
                    }
                    return socket;
                }
            };
            sslServerSocketConfigurers.add(sslServerSocketConfigurer);
        }
        return sslServerSocketConfigurers;
    }

    @Override
    protected List<BaseSSLContextParameters.Configurer<SSLSocketFactory>> getSSLSocketFactoryConfigurers(SSLContext context) {
        return Collections.emptyList();
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        builder2.append("SSLContextServerParameters[clientAuthentication=");
        builder2.append(this.clientAuthentication);
        builder2.append(", getCipherSuites()=");
        builder2.append(this.getCipherSuites());
        builder2.append(", getCipherSuitesFilter()=");
        builder2.append(this.getCipherSuitesFilter());
        builder2.append(", getSecureSocketProtocols()=");
        builder2.append(this.getSecureSocketProtocols());
        builder2.append(", getSecureSocketProtocolsFilter()=");
        builder2.append(this.getSecureSocketProtocolsFilter());
        builder2.append(", getSessionTimeout()=");
        builder2.append(this.getSessionTimeout());
        builder2.append("]");
        return builder2.toString();
    }
}

