/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pulsar;

import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.pulsar.PulsarEndpoint;
import org.apache.camel.component.pulsar.utils.consumers.SubscriptionInitialPosition;
import org.apache.camel.component.pulsar.utils.consumers.SubscriptionType;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.pulsar.client.api.BatcherBuilder;
import org.apache.pulsar.client.api.CompressionType;
import org.apache.pulsar.client.api.MessageRouter;
import org.apache.pulsar.client.api.MessageRoutingMode;
import org.apache.pulsar.client.api.RedeliveryBackoff;
import org.apache.pulsar.client.api.RegexSubscriptionMode;

public class PulsarEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        PulsarEndpoint target = (PulsarEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "ackgrouptimemillis": 
            case "ackGroupTimeMillis": {
                target.getPulsarConfiguration().setAckGroupTimeMillis(PulsarEndpointConfigurer.property(camelContext, Long.TYPE, value));
                return true;
            }
            case "acktimeoutmillis": 
            case "ackTimeoutMillis": {
                target.getPulsarConfiguration().setAckTimeoutMillis(PulsarEndpointConfigurer.property(camelContext, Long.TYPE, value));
                return true;
            }
            case "acktimeoutredeliverybackoff": 
            case "ackTimeoutRedeliveryBackoff": {
                target.getPulsarConfiguration().setAckTimeoutRedeliveryBackoff(PulsarEndpointConfigurer.property(camelContext, RedeliveryBackoff.class, value));
                return true;
            }
            case "allowmanualacknowledgement": 
            case "allowManualAcknowledgement": {
                target.getPulsarConfiguration().setAllowManualAcknowledgement(PulsarEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "authenticationclass": 
            case "authenticationClass": {
                target.getPulsarConfiguration().setAuthenticationClass(PulsarEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "authenticationparams": 
            case "authenticationParams": {
                target.getPulsarConfiguration().setAuthenticationParams(PulsarEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "batcherbuilder": 
            case "batcherBuilder": {
                target.getPulsarConfiguration().setBatcherBuilder(PulsarEndpointConfigurer.property(camelContext, BatcherBuilder.class, value));
                return true;
            }
            case "batchingenabled": 
            case "batchingEnabled": {
                target.getPulsarConfiguration().setBatchingEnabled(PulsarEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "batchingmaxmessages": 
            case "batchingMaxMessages": {
                target.getPulsarConfiguration().setBatchingMaxMessages(PulsarEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "batchingmaxpublishdelaymicros": 
            case "batchingMaxPublishDelayMicros": {
                target.getPulsarConfiguration().setBatchingMaxPublishDelayMicros(PulsarEndpointConfigurer.property(camelContext, Long.TYPE, value));
                return true;
            }
            case "blockifqueuefull": 
            case "blockIfQueueFull": {
                target.getPulsarConfiguration().setBlockIfQueueFull(PulsarEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler(PulsarEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "chunkingenabled": 
            case "chunkingEnabled": {
                target.getPulsarConfiguration().setChunkingEnabled(PulsarEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "compressiontype": 
            case "compressionType": {
                target.getPulsarConfiguration().setCompressionType(PulsarEndpointConfigurer.property(camelContext, CompressionType.class, value));
                return true;
            }
            case "consumername": 
            case "consumerName": {
                target.getPulsarConfiguration().setConsumerName(PulsarEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "consumernameprefix": 
            case "consumerNamePrefix": {
                target.getPulsarConfiguration().setConsumerNamePrefix(PulsarEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "consumerqueuesize": 
            case "consumerQueueSize": {
                target.getPulsarConfiguration().setConsumerQueueSize(PulsarEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "deadlettertopic": 
            case "deadLetterTopic": {
                target.getPulsarConfiguration().setDeadLetterTopic(PulsarEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "enableretry": 
            case "enableRetry": {
                target.getPulsarConfiguration().setEnableRetry(PulsarEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                target.setExceptionHandler(PulsarEndpointConfigurer.property(camelContext, ExceptionHandler.class, value));
                return true;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                target.setExchangePattern(PulsarEndpointConfigurer.property(camelContext, ExchangePattern.class, value));
                return true;
            }
            case "hashingscheme": 
            case "hashingScheme": {
                target.getPulsarConfiguration().setHashingScheme(PulsarEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "initialsequenceid": 
            case "initialSequenceId": {
                target.getPulsarConfiguration().setInitialSequenceId(PulsarEndpointConfigurer.property(camelContext, Long.TYPE, value));
                return true;
            }
            case "keysharedpolicy": 
            case "keySharedPolicy": {
                target.getPulsarConfiguration().setKeySharedPolicy(PulsarEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(PulsarEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "maxpendingmessages": 
            case "maxPendingMessages": {
                target.getPulsarConfiguration().setMaxPendingMessages(PulsarEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "maxpendingmessagesacrosspartitions": 
            case "maxPendingMessagesAcrossPartitions": {
                target.getPulsarConfiguration().setMaxPendingMessagesAcrossPartitions(PulsarEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "maxredelivercount": 
            case "maxRedeliverCount": {
                target.getPulsarConfiguration().setMaxRedeliverCount(PulsarEndpointConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "messagelistener": 
            case "messageListener": {
                target.getPulsarConfiguration().setMessageListener(PulsarEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "messagerouter": 
            case "messageRouter": {
                target.getPulsarConfiguration().setMessageRouter(PulsarEndpointConfigurer.property(camelContext, MessageRouter.class, value));
                return true;
            }
            case "messageroutingmode": 
            case "messageRoutingMode": {
                target.getPulsarConfiguration().setMessageRoutingMode(PulsarEndpointConfigurer.property(camelContext, MessageRoutingMode.class, value));
                return true;
            }
            case "negativeackredeliverybackoff": 
            case "negativeAckRedeliveryBackoff": {
                target.getPulsarConfiguration().setNegativeAckRedeliveryBackoff(PulsarEndpointConfigurer.property(camelContext, RedeliveryBackoff.class, value));
                return true;
            }
            case "negativeackredeliverydelaymicros": 
            case "negativeAckRedeliveryDelayMicros": {
                target.getPulsarConfiguration().setNegativeAckRedeliveryDelayMicros(PulsarEndpointConfigurer.property(camelContext, Long.TYPE, value));
                return true;
            }
            case "numberofconsumerthreads": 
            case "numberOfConsumerThreads": {
                target.getPulsarConfiguration().setNumberOfConsumerThreads(PulsarEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "numberofconsumers": 
            case "numberOfConsumers": {
                target.getPulsarConfiguration().setNumberOfConsumers(PulsarEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "producername": 
            case "producerName": {
                target.getPulsarConfiguration().setProducerName(PulsarEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "readcompacted": 
            case "readCompacted": {
                target.getPulsarConfiguration().setReadCompacted(PulsarEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "retrylettertopic": 
            case "retryLetterTopic": {
                target.getPulsarConfiguration().setRetryLetterTopic(PulsarEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "sendtimeoutms": 
            case "sendTimeoutMs": {
                target.getPulsarConfiguration().setSendTimeoutMs(PulsarEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "serviceurl": 
            case "serviceUrl": {
                target.getPulsarConfiguration().setServiceUrl(PulsarEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "subscriptioninitialposition": 
            case "subscriptionInitialPosition": {
                target.getPulsarConfiguration().setSubscriptionInitialPosition(PulsarEndpointConfigurer.property(camelContext, SubscriptionInitialPosition.class, value));
                return true;
            }
            case "subscriptionname": 
            case "subscriptionName": {
                target.getPulsarConfiguration().setSubscriptionName(PulsarEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "subscriptiontopicsmode": 
            case "subscriptionTopicsMode": {
                target.getPulsarConfiguration().setSubscriptionTopicsMode(PulsarEndpointConfigurer.property(camelContext, RegexSubscriptionMode.class, value));
                return true;
            }
            case "subscriptiontype": 
            case "subscriptionType": {
                target.getPulsarConfiguration().setSubscriptionType(PulsarEndpointConfigurer.property(camelContext, SubscriptionType.class, value));
                return true;
            }
            case "topicspattern": 
            case "topicsPattern": {
                target.getPulsarConfiguration().setTopicsPattern(PulsarEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "ackgrouptimemillis": 
            case "ackGroupTimeMillis": {
                return Long.TYPE;
            }
            case "acktimeoutmillis": 
            case "ackTimeoutMillis": {
                return Long.TYPE;
            }
            case "acktimeoutredeliverybackoff": 
            case "ackTimeoutRedeliveryBackoff": {
                return RedeliveryBackoff.class;
            }
            case "allowmanualacknowledgement": 
            case "allowManualAcknowledgement": {
                return Boolean.TYPE;
            }
            case "authenticationclass": 
            case "authenticationClass": {
                return String.class;
            }
            case "authenticationparams": 
            case "authenticationParams": {
                return String.class;
            }
            case "batcherbuilder": 
            case "batcherBuilder": {
                return BatcherBuilder.class;
            }
            case "batchingenabled": 
            case "batchingEnabled": {
                return Boolean.TYPE;
            }
            case "batchingmaxmessages": 
            case "batchingMaxMessages": {
                return Integer.TYPE;
            }
            case "batchingmaxpublishdelaymicros": 
            case "batchingMaxPublishDelayMicros": {
                return Long.TYPE;
            }
            case "blockifqueuefull": 
            case "blockIfQueueFull": {
                return Boolean.TYPE;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "chunkingenabled": 
            case "chunkingEnabled": {
                return Boolean.TYPE;
            }
            case "compressiontype": 
            case "compressionType": {
                return CompressionType.class;
            }
            case "consumername": 
            case "consumerName": {
                return String.class;
            }
            case "consumernameprefix": 
            case "consumerNamePrefix": {
                return String.class;
            }
            case "consumerqueuesize": 
            case "consumerQueueSize": {
                return Integer.TYPE;
            }
            case "deadlettertopic": 
            case "deadLetterTopic": {
                return String.class;
            }
            case "enableretry": 
            case "enableRetry": {
                return Boolean.TYPE;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return ExceptionHandler.class;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return ExchangePattern.class;
            }
            case "hashingscheme": 
            case "hashingScheme": {
                return String.class;
            }
            case "initialsequenceid": 
            case "initialSequenceId": {
                return Long.TYPE;
            }
            case "keysharedpolicy": 
            case "keySharedPolicy": {
                return String.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "maxpendingmessages": 
            case "maxPendingMessages": {
                return Integer.TYPE;
            }
            case "maxpendingmessagesacrosspartitions": 
            case "maxPendingMessagesAcrossPartitions": {
                return Integer.TYPE;
            }
            case "maxredelivercount": 
            case "maxRedeliverCount": {
                return Integer.class;
            }
            case "messagelistener": 
            case "messageListener": {
                return Boolean.TYPE;
            }
            case "messagerouter": 
            case "messageRouter": {
                return MessageRouter.class;
            }
            case "messageroutingmode": 
            case "messageRoutingMode": {
                return MessageRoutingMode.class;
            }
            case "negativeackredeliverybackoff": 
            case "negativeAckRedeliveryBackoff": {
                return RedeliveryBackoff.class;
            }
            case "negativeackredeliverydelaymicros": 
            case "negativeAckRedeliveryDelayMicros": {
                return Long.TYPE;
            }
            case "numberofconsumerthreads": 
            case "numberOfConsumerThreads": {
                return Integer.TYPE;
            }
            case "numberofconsumers": 
            case "numberOfConsumers": {
                return Integer.TYPE;
            }
            case "producername": 
            case "producerName": {
                return String.class;
            }
            case "readcompacted": 
            case "readCompacted": {
                return Boolean.TYPE;
            }
            case "retrylettertopic": 
            case "retryLetterTopic": {
                return String.class;
            }
            case "sendtimeoutms": 
            case "sendTimeoutMs": {
                return Integer.TYPE;
            }
            case "serviceurl": 
            case "serviceUrl": {
                return String.class;
            }
            case "subscriptioninitialposition": 
            case "subscriptionInitialPosition": {
                return SubscriptionInitialPosition.class;
            }
            case "subscriptionname": 
            case "subscriptionName": {
                return String.class;
            }
            case "subscriptiontopicsmode": 
            case "subscriptionTopicsMode": {
                return RegexSubscriptionMode.class;
            }
            case "subscriptiontype": 
            case "subscriptionType": {
                return SubscriptionType.class;
            }
            case "topicspattern": 
            case "topicsPattern": {
                return Boolean.TYPE;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        PulsarEndpoint target = (PulsarEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "ackgrouptimemillis": 
            case "ackGroupTimeMillis": {
                return target.getPulsarConfiguration().getAckGroupTimeMillis();
            }
            case "acktimeoutmillis": 
            case "ackTimeoutMillis": {
                return target.getPulsarConfiguration().getAckTimeoutMillis();
            }
            case "acktimeoutredeliverybackoff": 
            case "ackTimeoutRedeliveryBackoff": {
                return target.getPulsarConfiguration().getAckTimeoutRedeliveryBackoff();
            }
            case "allowmanualacknowledgement": 
            case "allowManualAcknowledgement": {
                return target.getPulsarConfiguration().isAllowManualAcknowledgement();
            }
            case "authenticationclass": 
            case "authenticationClass": {
                return target.getPulsarConfiguration().getAuthenticationClass();
            }
            case "authenticationparams": 
            case "authenticationParams": {
                return target.getPulsarConfiguration().getAuthenticationParams();
            }
            case "batcherbuilder": 
            case "batcherBuilder": {
                return target.getPulsarConfiguration().getBatcherBuilder();
            }
            case "batchingenabled": 
            case "batchingEnabled": {
                return target.getPulsarConfiguration().isBatchingEnabled();
            }
            case "batchingmaxmessages": 
            case "batchingMaxMessages": {
                return target.getPulsarConfiguration().getBatchingMaxMessages();
            }
            case "batchingmaxpublishdelaymicros": 
            case "batchingMaxPublishDelayMicros": {
                return target.getPulsarConfiguration().getBatchingMaxPublishDelayMicros();
            }
            case "blockifqueuefull": 
            case "blockIfQueueFull": {
                return target.getPulsarConfiguration().isBlockIfQueueFull();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "chunkingenabled": 
            case "chunkingEnabled": {
                return target.getPulsarConfiguration().isChunkingEnabled();
            }
            case "compressiontype": 
            case "compressionType": {
                return target.getPulsarConfiguration().getCompressionType();
            }
            case "consumername": 
            case "consumerName": {
                return target.getPulsarConfiguration().getConsumerName();
            }
            case "consumernameprefix": 
            case "consumerNamePrefix": {
                return target.getPulsarConfiguration().getConsumerNamePrefix();
            }
            case "consumerqueuesize": 
            case "consumerQueueSize": {
                return target.getPulsarConfiguration().getConsumerQueueSize();
            }
            case "deadlettertopic": 
            case "deadLetterTopic": {
                return target.getPulsarConfiguration().getDeadLetterTopic();
            }
            case "enableretry": 
            case "enableRetry": {
                return target.getPulsarConfiguration().isEnableRetry();
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return target.getExceptionHandler();
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return target.getExchangePattern();
            }
            case "hashingscheme": 
            case "hashingScheme": {
                return target.getPulsarConfiguration().getHashingScheme();
            }
            case "initialsequenceid": 
            case "initialSequenceId": {
                return target.getPulsarConfiguration().getInitialSequenceId();
            }
            case "keysharedpolicy": 
            case "keySharedPolicy": {
                return target.getPulsarConfiguration().getKeySharedPolicy();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "maxpendingmessages": 
            case "maxPendingMessages": {
                return target.getPulsarConfiguration().getMaxPendingMessages();
            }
            case "maxpendingmessagesacrosspartitions": 
            case "maxPendingMessagesAcrossPartitions": {
                return target.getPulsarConfiguration().getMaxPendingMessagesAcrossPartitions();
            }
            case "maxredelivercount": 
            case "maxRedeliverCount": {
                return target.getPulsarConfiguration().getMaxRedeliverCount();
            }
            case "messagelistener": 
            case "messageListener": {
                return target.getPulsarConfiguration().isMessageListener();
            }
            case "messagerouter": 
            case "messageRouter": {
                return target.getPulsarConfiguration().getMessageRouter();
            }
            case "messageroutingmode": 
            case "messageRoutingMode": {
                return target.getPulsarConfiguration().getMessageRoutingMode();
            }
            case "negativeackredeliverybackoff": 
            case "negativeAckRedeliveryBackoff": {
                return target.getPulsarConfiguration().getNegativeAckRedeliveryBackoff();
            }
            case "negativeackredeliverydelaymicros": 
            case "negativeAckRedeliveryDelayMicros": {
                return target.getPulsarConfiguration().getNegativeAckRedeliveryDelayMicros();
            }
            case "numberofconsumerthreads": 
            case "numberOfConsumerThreads": {
                return target.getPulsarConfiguration().getNumberOfConsumerThreads();
            }
            case "numberofconsumers": 
            case "numberOfConsumers": {
                return target.getPulsarConfiguration().getNumberOfConsumers();
            }
            case "producername": 
            case "producerName": {
                return target.getPulsarConfiguration().getProducerName();
            }
            case "readcompacted": 
            case "readCompacted": {
                return target.getPulsarConfiguration().isReadCompacted();
            }
            case "retrylettertopic": 
            case "retryLetterTopic": {
                return target.getPulsarConfiguration().getRetryLetterTopic();
            }
            case "sendtimeoutms": 
            case "sendTimeoutMs": {
                return target.getPulsarConfiguration().getSendTimeoutMs();
            }
            case "serviceurl": 
            case "serviceUrl": {
                return target.getPulsarConfiguration().getServiceUrl();
            }
            case "subscriptioninitialposition": 
            case "subscriptionInitialPosition": {
                return target.getPulsarConfiguration().getSubscriptionInitialPosition();
            }
            case "subscriptionname": 
            case "subscriptionName": {
                return target.getPulsarConfiguration().getSubscriptionName();
            }
            case "subscriptiontopicsmode": 
            case "subscriptionTopicsMode": {
                return target.getPulsarConfiguration().getSubscriptionTopicsMode();
            }
            case "subscriptiontype": 
            case "subscriptionType": {
                return target.getPulsarConfiguration().getSubscriptionType();
            }
            case "topicspattern": 
            case "topicsPattern": {
                return target.getPulsarConfiguration().isTopicsPattern();
            }
        }
        return null;
    }
}

