/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema.generic;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.util.Utf8;
import org.apache.pulsar.client.api.schema.Field;
import org.apache.pulsar.client.impl.schema.generic.VersionedGenericRecord;
import org.apache.pulsar.common.schema.SchemaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericAvroRecord
extends VersionedGenericRecord {
    private static final Logger log = LoggerFactory.getLogger(GenericAvroRecord.class);
    private final Schema schema;
    private final GenericRecord record;

    public GenericAvroRecord(byte[] schemaVersion, Schema schema, List<Field> fields, GenericRecord record) {
        super(schemaVersion, fields);
        this.schema = schema;
        this.record = record;
    }

    @Override
    public Object getField(String fieldName) {
        Object value = this.record.get(fieldName);
        if (value instanceof Utf8) {
            return ((Utf8)value).toString();
        }
        if (value instanceof GenericRecord) {
            GenericRecord avroRecord = (GenericRecord)value;
            Schema recordSchema = avroRecord.getSchema();
            List<Field> fields = recordSchema.getFields().stream().map(f -> new Field(f.name(), f.pos())).collect(Collectors.toList());
            return new GenericAvroRecord(this.schemaVersion, this.schema, fields, avroRecord);
        }
        return value;
    }

    public GenericRecord getAvroRecord() {
        return this.record;
    }

    @Override
    public Object getNativeObject() {
        return this.record;
    }

    @Override
    public SchemaType getSchemaType() {
        return SchemaType.AVRO;
    }
}

