/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.ResourceGroups;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.common.policies.data.ResourceGroup;
import org.apache.pulsar.shade.javax.ws.rs.client.Entity;
import org.apache.pulsar.shade.javax.ws.rs.client.WebTarget;

public class ResourceGroupsImpl
extends BaseResource
implements ResourceGroups {
    private final WebTarget adminResourceGroups;

    public ResourceGroupsImpl(WebTarget web, Authentication auth, long requestTimeoutMs) {
        super(auth, requestTimeoutMs);
        this.adminResourceGroups = web.path("/admin/v2/resourcegroups");
    }

    @Override
    public List<String> getResourceGroups() throws PulsarAdminException {
        return (List)this.sync(() -> this.getResourceGroupsAsync());
    }

    @Override
    public CompletableFuture<List<String>> getResourceGroupsAsync() {
        return this.asyncGetRequest(this.adminResourceGroups, new BaseResource.FutureCallback<List<String>>(){});
    }

    @Override
    public ResourceGroup getResourceGroup(String resourcegroup) throws PulsarAdminException {
        return (ResourceGroup)this.sync(() -> this.getResourceGroupAsync(resourcegroup));
    }

    @Override
    public CompletableFuture<ResourceGroup> getResourceGroupAsync(String name) {
        WebTarget path = this.adminResourceGroups.path(name);
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<ResourceGroup>(){});
    }

    @Override
    public void createResourceGroup(String name, ResourceGroup resourcegroup) throws PulsarAdminException {
        this.sync(() -> this.createResourceGroupAsync(name, resourcegroup));
    }

    @Override
    public CompletableFuture<Void> createResourceGroupAsync(String name, ResourceGroup resourcegroup) {
        WebTarget path = this.adminResourceGroups.path(name);
        return this.asyncPutRequest(path, Entity.entity(resourcegroup, "application/json"));
    }

    @Override
    public void updateResourceGroup(String name, ResourceGroup resourcegroup) throws PulsarAdminException {
        this.sync(() -> this.updateResourceGroupAsync(name, resourcegroup));
    }

    @Override
    public CompletableFuture<Void> updateResourceGroupAsync(String name, ResourceGroup resourcegroup) {
        WebTarget path = this.adminResourceGroups.path(name);
        return this.asyncPutRequest(path, Entity.entity(resourcegroup, "application/json"));
    }

    @Override
    public void deleteResourceGroup(String name) throws PulsarAdminException {
        this.sync(() -> this.deleteResourceGroupAsync(name));
    }

    @Override
    public CompletableFuture<Void> deleteResourceGroupAsync(String name) {
        WebTarget path = this.adminResourceGroups.path(name);
        return this.asyncDeleteRequest(path);
    }
}

